/***************************************************************************

                   document properties dialog class

    -----------------------------------------------------------------------

    begin          : Fri Sep 10 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DocPropsDlg_included
#define DocPropsDlg_included

#include <kdialogbase.h>

#include "DocOptionsPage.h"
#include "LessOptPage.h"
#include "TypeOptPage.h"
#include "TenseOptPage.h"
#include "UsageOptPage.h"
#include "TitlePage.h"

#include <vector>
using namespace std;

class kvoctrainDoc;
class LangPropPage;

class DocPropsDlg : public KDialogBase
{
    TQ_OBJECT
  

public:

  DocPropsDlg
  (
    kvoctrainDoc    *doc,
    const char      *start_page,
    TQComboBox       *lessons,
    TQString          title,
    TQString          author,
    TQString          license,
    TQString          doc_remark,
    vector<TQString>  types,
    vector<TQString>  tenses,
    vector<TQString>  usages,
    TQWidget         *parent = NULL,
    const char      *name = NULL,
    bool             modal = true
  );

  inline bool getSorting()  const { return docOptPage->getSorting(); }

  inline TQString getTitle()      { return titleOptPage->getTitle(); }
  inline TQString getAuthor()     { return titleOptPage->getAuthor(); }
  inline TQString getLicense()    { return titleOptPage->getLicense(); }
  inline TQString getDocRemark()  { return titleOptPage->getDocRemark(); }

  inline void getLesson (TQComboBox *lessons, vector<int>& ret_index) const
    { lessOptPage->getLesson (lessons, ret_index); }

  inline void getTypeNames (vector<TQString> &types, vector<int>& ret_index) const
    { typeOptPage->getTypeNames (types, ret_index); }

  inline void getTenseNames (vector<TQString> &tenses, vector<int>& ret_index) const
    { tenseOptPage->getTenseNames (tenses, ret_index); }

  inline void getUsageLabels (vector<TQString> &usages, vector<int>& ret_index) const
    { useOptPage->getUsageLabels (usages, ret_index); }


protected:

  UsageOptPage   *useOptPage;
  TypeOptPage    *typeOptPage;
  TenseOptPage   *tenseOptPage;
  LessOptPage    *lessOptPage;
  TitlePage      *titleOptPage;
  DocOptionsPage *docOptPage;
};

#endif // DocPropsDlg_included

