#!/opt/trinity/bin/kjscmd

//
// Load an image, scale it, and save it in the specified format.
//

if ( application.args.length >= 3 ) {
    var infile = application.args[0];
    var outfile = application.args[1];
    var scale = application.args[2];

    var img = new Image();
    img.load( infile );
    if ( img.isOk() ) {
	if ( application.args.length > 3 ) {
	    img.format = application.args[3];
	}

	img.smoothScale( img.width*(scale/100.0), img.height*(scale/100.0) );
	img.save( outfile );
    }
}
else {
    System.out.println( 'Usage:' );
    System.err.println( '\timagescale imgfile outfile percent [format]' );
}


