/* This file is part of the KDE project
 *
 * Copyright (C) 2000 Simon Hausmann <hausmann@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <dcopclient.h>
#include <dcopobject.h>
#include <tdeapplication.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <tdeprocess.h>
#include <tdeparts/mainwindow.h>
#include <kdebug.h>
#include "xp_notepad_factory.h"

extern "C"
{
  void *init_libxp_notepadpart()
  {
      return new XP_NotepadFactory( true );
  }
};


KParts::Part *XP_NotepadFactory::createPartObject( TQWidget *parentWidget, const char *widgetName, TQObject *parent, const char *name, const char *className, const TQStringList & )
{
    return new XP_NotepadPart( parentWidget, widgetName, parent, name );
}

XP_NotepadPart::XP_NotepadPart(TQWidget *parentWidget, const char *widgetName,
	                       TQObject *parent, const char *name)
	: XPartHost_KPart(parentWidget, widgetName, parent, name)
{
    m_partProcess = new TDEProcess;
    *m_partProcess << "xnotepard"
		   << tdeApp->dcopClient()->appId() << objId();
    m_partProcess->start();

    tqDebug("---->>>>>> enter loop");
    tdeApp->enter_loop();
    tqDebug("----<<<<<< left loop");
}

XP_NotepadPart::~XP_NotepadPart()
{
    delete m_partProcess;
}

void XP_NotepadPart::createActions( const TQCString &xmlActions )
{
    XPartHost_KPart::createActions( xmlActions );
    tqDebug("----<<<<<< exit loop");
    tdeApp->exit_loop();
}

#include "xp_notepad_factory.moc"
