#include "kmozillapart.h"

#include <dcopclient.h>
#include <dcopobject.h>
#include <tdeapplication.h>
#include <kstdaction.h>
#include <tdeaction.h>
#include <tdemainwindow.h>
#include <tdeprocess.h>
#include <tdeparts/mainwindow.h>
#include <kdebug.h>
#include <tdeaboutdata.h>
#include <tdeparts/genericfactory.h>

typedef KParts::GenericFactory<KMozillaPart> KMozillaPartFactory;
K_EXPORT_COMPONENT_FACTORY( libkmozillapart, KMozillaPartFactory );

KMozillaPart::KMozillaPart(TQWidget *parentWidget, const char *widgetName,
	                   TQObject *parent, const char *name, const TQStringList &)
	: XPartHost_KPart(parentWidget, widgetName, parent, name)
{
    setInstance( KMozillaPartFactory::instance() );

    m_partProcess = new TDEProcess;
    *m_partProcess << "kmozilla"
		   << tdeApp->dcopClient()->appId() << objId();
    m_partProcess->start();

    tqDebug("---->>>>>> enter loop");
    tdeApp->enter_loop();
    tqDebug("----<<<<<< left loop");
}

KMozillaPart::~KMozillaPart()
{
    delete m_partProcess;
}

void KMozillaPart::createActions( const TQCString &xmlActions )
{
    XPartHost_KPart::createActions( xmlActions );
    tqDebug("----<<<<<< exit loop");
    tdeApp->exit_loop();
}

TDEAboutData *KMozillaPart::createAboutData()
{
    return new TDEAboutData( "kmozilla", "kmozilla", "0.1" );
}

#include "kmozillapart.moc"
