//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQObject;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQAccel;

/**

 Handle shortcuts.
 Allow a user to configure shortcuts
 through application configuration files or through the
 KKeyChooser GUI.
 A TDEAccel contains a list of accelerator actions.
 For example, CTRL+Key_P could be a shortcut for printing a document. The key
 codes are listed in qnamespace.h. "Print" could be the action name for printing.
 The action name identifies the shortcut in configuration files and the
 KKeyChooser GUI.
 A TDEAccel object handles key events sent to its parent widget and to all
 children of this parent widget.  The most recently created TDEAccel object
 has precedence over any TDEAccel objects created before it.
 When a shortcut pressed, TDEAccel calls the slot to which it has been
 connected. If you want to set global accelerators, independent of the window
 which has the focus, use TDEGlobalAccel.
 Reconfiguration of a given shortcut can be prevented by specifying
 that an accelerator item is not configurable when it is inserted. A special
 group of non-configurable key bindings are known as the
 standard accelerators.
 The standard accelerators appear repeatedly in applications for
 standard document actions such as printing and saving. A convenience method is
 available to insert and connect these accelerators which are configurable on
 a desktop-wide basis.
 It is possible for a user to choose to have no key associated with
 an action.
 The translated first argument for insertItem() is used only
 in the configuration dialog.
<pre>
 TDEAccel pAccel = new TDEAccel( this );
 // Insert an action "Scroll Up" which is associated with the "Up" key:
 pAccel.insert( "Scroll Up", i18n("Scroll up"),
                       i18n("Scroll up the current document by one line."),
                       Qt.Key_Up, this, TQ_SLOT("slotScrollUp()") );
 // Insert an standard acclerator action.
 pAccel.insert( TDEStdAccel.Print, this, TQ_SLOT("slotPrint()") );
 // Update the shortcuts by read any user-defined settings from the
 // application's config file.
 pAccel.readSettings();
 </pre>
 See {@link TDEAccelSignals} for signals emitted by TDEAccel
		@short Configurable shortcut support for widgets.
		@see TDEGlobalAccel
		@see TDEAccelShortcutList
		@see KKeyChooser
		@see KKeyDialog

*/
public class TDEAccel extends TQAccel  {
	protected TDEAccel(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	/**
		 Creates a new TDEAccel that watches <code>pParent</code>, which is also
		 the TQObject's parent.
			@param pParent the parent and widget to watch for key strokes
			@param psName the name of the TQObject
			 		@short    Creates a new TDEAccel that watches <code>pParent</code>, which is also  the TQObject's parent.
	*/
	public TDEAccel(TQWidget pParent, String psName) {
		super((Class) null);
		newTDEAccel(pParent,psName);
	}
	private native void newTDEAccel(TQWidget pParent, String psName);
	public TDEAccel(TQWidget pParent) {
		super((Class) null);
		newTDEAccel(pParent);
	}
	private native void newTDEAccel(TQWidget pParent);
	/**
		 Creates a new TDEAccel that watches <code>watch.</code>
			@param watch the widget to watch for key strokes
			@param parent the parent of the TQObject
			@param psName the name of the TQObject
			 		@short    Creates a new TDEAccel that watches <code>watch.</code>
	*/
	public TDEAccel(TQWidget watch, TQObject parent, String psName) {
		super((Class) null);
		newTDEAccel(watch,parent,psName);
	}
	private native void newTDEAccel(TQWidget watch, TQObject parent, String psName);
	public TDEAccel(TQWidget watch, TQObject parent) {
		super((Class) null);
		newTDEAccel(watch,parent);
	}
	private native void newTDEAccel(TQWidget watch, TQObject parent);
	/**
			 Returns the TDEAccel's <code>TDEAccelActions</code>, a list of <code>TDEAccelAction.</code>
				@return the TDEAccelActions of the TDEAccel

		@short
	*/
	public native TDEAccelActions actions();
	/**
		 Checks whether the TDEAccel is active.
				@return true if the TQAccel is enabled

		@short    Checks whether the TDEAccel is active.
	*/
	public native boolean isEnabled();
	/**
		 Enables or disables the TDEAccel.
			@param bEnabled true to enable, false to disable
			 		@short    Enables or disables the TDEAccel.
	*/
	public native void setEnabled(boolean bEnabled);
	/**
		 Enable auto-update of connections. This means that the signals
		 are automatically disconnected when you disable an action, and
		 re-enabled when you enable it. By default auto update is turned
		 on. If you disable auto-update, you need to call
		 updateConnections() after changing actions.
			@param bAuto true to enable, false to disable
				@return the value of the flag before this call

		@short    Enable auto-update of connections.
	*/
	public native boolean setAutoUpdate(boolean bAuto);
	/**
		 Create an accelerator action.
			 Usage:
		<pre>
		 insert( "Do Something", i18n("Do Something"),
		   i18n("This action allows you to do something really great with this program to "
		        "the currently open document."),
		   ALT+Key_D, this, TQ_SLOT("slotDoSomething()") );
		</pre>
			@param sAction The internal name of the action.
			@param sLabel An i18n'ized short description of the action displayed when
		  using KKeyChooser to reconfigure the shortcuts.
			@param sWhatsThis An extended description of the action.
			@param cutDef The default shortcut.
			@param pObjSlot Pointer to the slot object.
			@param psMethodSlot Pointer to the slot method.
			@param bConfigurable Allow the user to change this shortcut if set to 'true'.
			@param bEnabled The action will be activated by the shortcut if set to 'true'.
			 		@short    Create an accelerator action.
	*/
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable);
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot);
	/**
		 Same as first insert(), but with separate shortcuts defined for
		 3- and 4- modifier defaults.
			 		@short    Same as first insert(), but with separate shortcuts defined for  3- and 4- modifier defaults.
	*/
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef3, TDEShortcut cutDef4, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef3, TDEShortcut cutDef4, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable);
	public native TDEAccelAction insert(String sAction, String sLabel, String sWhatsThis, TDEShortcut cutDef3, TDEShortcut cutDef4, TQObject pObjSlot, String psMethodSlot);
	/**
		 This is an overloaded function provided for convenience.
		 The advantage of this is when you want to use the same text for the name
		 of the action as for the user-visible label.
			 Usage:
		 <pre>
		 insert( i18n("Do Something"), ALT+Key_D, this, TQ_SLOT("slotDoSomething()") );
		 </pre>
			@param psAction The name AND label of the action.
			@param cutDef The default shortcut for this action.
			@param pObjSlot Pointer to the slot object.
			@param psMethodSlot Pointer to the slot method.
			@param bConfigurable Allow the user to change this shortcut if set to 'true'.
			@param bEnabled The action will be activated by the shortcut if set to 'true'.
			 		@short    This is an overloaded function provided for convenience.
	*/
	public native TDEAccelAction insert(String psAction, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native TDEAccelAction insert(String psAction, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable);
	public native TDEAccelAction insert(String psAction, TDEShortcut cutDef, TQObject pObjSlot, String psMethodSlot);
	/**
		 Similar to the first insert() method, but with the action
		 name, short description, help text, and default shortcuts all
		 set according to one of the standard accelerators.
				@short    Similar to the first insert() method, but with the action  name, short description, help text, and default shortcuts all  set according to one of the standard accelerators.
		@see TDEStdAccel#
	*/
	public native TDEAccelAction insert(int id, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native TDEAccelAction insert(int id, TQObject pObjSlot, String psMethodSlot, boolean bConfigurable);
	public native TDEAccelAction insert(int id, TQObject pObjSlot, String psMethodSlot);
	/**
		 Removes the accelerator action identified by the name.
		 Remember to also call updateConnections().
			@param sAction the name of the action to remove
				@return true if successful, false otherwise

		@short    Removes the accelerator action identified by the name.
	*/
	public native boolean remove(String sAction);
	/**
		 Updates the connections of the accelerations after changing them.
		 This is only necessary if you have disabled auto updates which are
		 on by default.
				@return true if successful, false otherwise

		@short    Updates the connections of the accelerations after changing them.
		@see #setAutoUpdate
		@see #getAutoUpdate
	*/
	public native boolean updateConnections();
	/**
		 Return the shortcut associated with the action named by <code>sAction.</code>
			@param sAction the name of the action
				@return the action's shortcut, or a null shortcut if not found

		@short    Return the shortcut associated with the action named by <code>sAction.</code>
	*/
	public native TDEShortcut shortcut(String sAction);
	/**
		 Set the shortcut to be associated with the action named by <code>sAction.</code>
			@param sAction the name of the action
			@param shortcut the shortcut to set
				@return true if successful, false otherwise

		@short    Set the shortcut to be associated with the action named by <code>sAction.</code>
	*/
	public native boolean setShortcut(String sAction, TDEShortcut shortcut);
	/**
		 Set the slot to be called when the shortcut of the action named
		 by <code>sAction</code> is pressed.
			@param sAction the name of the action
			@param pObjSlot the owner of the slot
			@param psMethodSlot the name of the slot
				@return true if successful, false otherwise

		@short    Set the slot to be called when the shortcut of the action named  by <code>sAction</code> is pressed.
	*/
	public native boolean setSlot(String sAction, TQObject pObjSlot, String psMethodSlot);
	/**
		 Enable or disable the action named by <code>sAction.</code>
			@param sAction the action to en-/disable
			@param bEnabled true to enable, false to disable
				@return true if successful, false otherwise

		@short    Enable or disable the action named by <code>sAction.</code>
	*/
	public native boolean setEnabled(String sAction, boolean bEnabled);
	/**
		 Returns the configuration group of the settings.
				@return the configuration group

		@short    Returns the configuration group of the settings.
		@see TDEConfig
	*/
	public native String configGroup();
	/**
		 Returns the configuration group of the settings.
			@param name the new configuration group
				@short    Returns the configuration group of the settings.
		@see TDEConfig
	*/
	public native void setConfigGroup(String name);
	/**
		 Read all shortcuts from <code>pConfig</code>, or (if <code>pConfig</code>
		 is zero) from the application's configuration file
		 TDEGlobal.config().
			 The group in which the configuration is stored can be
		 set with setConfigGroup().
			@param pConfig the configuration file, or 0 for the application
		         configuration file
				@return true if successful, false otherwise

		@short    Read all shortcuts from <code>pConfig</code>, or (if <code>pConfig</code>  is zero) from the application's configuration file  TDEGlobal.config().
	*/
	public native boolean readSettings(TDEConfigBase pConfig);
	public native boolean readSettings();
	/**
		 Write the current shortcuts to <code>pConfig</code>,
		 or (if <code>pConfig</code> is zero) to the application's
		 configuration file.
			@param pConfig the configuration file, or 0 for the application
		         configuration file
				@return true if successful, false otherwise

		@short    Write the current shortcuts to <code>pConfig</code>,  or (if <code>pConfig</code> is zero) to the application's  configuration file.
	*/
	public native boolean writeSettings(TDEConfigBase pConfig);
	public native boolean writeSettings();
	/**
		 Emits the keycodeChanged() signal.
			 		@short    Emits the keycodeChanged() signal.
	*/
	public native void emitKeycodeChanged();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
