//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQObject;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQWidget;
import org.trinitydesktop.qt.TQObject;

/**

 The TDEIO.Scheduler manages io-slaves for the application.
 It also queues jobs and assigns the job to a slave when one
 becomes available.
 There are 3 possible ways for a job to get a slave:
 <h3>1. Direct</h3>
 This is the default. When you create a job the
 TDEIO.Scheduler will be notified and will find either an existing
 slave that is idle or it will create a new slave for the job.
 Example:
 <pre>
    TransferJob job = TDEIO.get(KURL("http://www.kde.org"));
 </pre>
 <h3>2. Scheduled</h3>
 If you create a lot of jobs, you might want not want to have a
 slave for each job. If you schedule a job, a maximum number
 of slaves will be created. When more jobs arrive, they will be
 queued. When a slave is finished with a job, it will be assigned
 a job from the queue.
 Example:
 <pre>
    TransferJob job = TDEIO.get(KURL("http://www.kde.org"));
    TDEIO.Scheduler.scheduleJob(job);
 </pre>
 <h3>3. Connection Oriented</h3>
 For some operations it is important that multiple jobs use
 the same connection. This can only be ensured if all these jobs
 use the same slave.
 You can ask the scheduler to open a slave for connection oriented
 operations. You can then use the scheduler to assign jobs to this
 slave. The jobs will be queued and the slave will handle these jobs
 one after the other.
 Example:
 <pre>
    Slave slave = TDEIO.Scheduler.getConnectedSlave(
            KURL("pop3://bastian:password@mail.kde.org"));
    TransferJob job1 = TDEIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg1"));
    TDEIO.Scheduler.assignJobToSlave(slave, job1);
    TransferJob job2 = TDEIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg2"));
    TDEIO.Scheduler.assignJobToSlave(slave, job2);
    TransferJob job3 = TDEIO.get(
            KURL("pop3://bastian:password@mail.kde.org/msg3"));
    TDEIO.Scheduler.assignJobToSlave(slave, job3);
    // ... Wait for jobs to finish...
    TDEIO.Scheduler.disconnectSlave(slave);
 </pre>
 Note that you need to explicitly disconnect the slave when the
 connection goes down, so your error handler should contain:
 <pre>
    if (error == TDEIO.ERR_CONNECTION_BROKEN)
        TDEIO.Scheduler.disconnectSlave(slave);
 </pre>
 See {@link SchedulerSignals} for signals emitted by Scheduler
		@short    The TDEIO.Scheduler manages io-slaves for the application.
		@see Slave
		@see Job

*/
public class Scheduler extends TQObject implements DCOPObjectInterface {
	protected Scheduler(Class dummy){super((Class) null);}
	public native TQMetaObject metaObject();
	public native String className();
	public native boolean connect(TQObject sender, String signal, String member);
	public native void debug_info();
	public native boolean process(String fun, byte[] data, StringBuffer replyType, byte[] replyData);
	public native ArrayList functions();
	public native void slotSlaveDied(Slave slave);
	public native void slotSlaveStatus(int pid, String protocol, String host, boolean connected);
	/**
		 Register <code>job</code> with the scheduler.
		 The default is to create a new slave for the job if no slave
		 is available. This can be changed by calling scheduleJob.
			@param job the job to register
		         		@short    Register <code>job</code> with the scheduler.
	*/
	public static native void doJob(SimpleJob job);
	/**
		 Calling ths function makes that <code>job</code> gets scheduled for later
		 execution, if multiple jobs are registered it might wait for
		 other jobs to finish.
			@param job the job to schedule
		         		@short    Calling ths function makes that <code>job</code> gets scheduled for later  execution, if multiple jobs are registered it might wait for  other jobs to finish.
	*/
	public static native void scheduleJob(SimpleJob job);
	/**
		 Stop the execution of a job.
			@param job the job to cancel
		         		@short    Stop the execution of a job.
	*/
	public static native void cancelJob(SimpleJob job);
	/**
		 Called when a job is done.
			@param job the finished job
			@param slave the slave that executed the <code>job</code>
		         		@short    Called when a job is done.
	*/
	public static native void jobFinished(SimpleJob job, Slave slave);
	/**
		 Puts a slave on notice. A next job may reuse this slave if it
		 requests the same URL.
			 A job can be put on hold after it has emit'ed its mimetype.
		 Based on the mimetype, the program can give control to another
		 component in the same process which can then resume the job
		 by simply asking for the same URL again.
			@param job the job that should be stopped
			@param url the URL that is handled by the <code>url</code>
		         		@short    Puts a slave on notice.
	*/
	public static native void putSlaveOnHold(SimpleJob job, KURL url);
	/**
		 Removes any slave that might have been put on hold. If a slave
		 was put on hold it will be killed.
		         		@short    Removes any slave that might have been put on hold.
	*/
	public static native void removeSlaveOnHold();
	/**
		 Send the slave that was put on hold back to TDELauncher. This
		 allows another process to take over the slave and resume the job
		 that was started.
		         		@short    Send the slave that was put on hold back to TDELauncher.
	*/
	public static native void publishSlaveOnHold();
	/**
		 Requests a slave for use in connection-oriented mode.
			@param url This defines the username,password,host & port to
		            connect with.
			@param config Configuration data for the slave.
				@return A pointer to a connected slave or 0 if an error occurred.

		@short    Requests a slave for use in connection-oriented mode.
		@see #assignJobToSlave
		@see #disconnectSlave
	*/
	// TDEIO::Slave* getConnectedSlave(const KURL& arg1,const TDEIO::MetaData& arg2); >>>> NOT CONVERTED
	public static native Slave getConnectedSlave(KURL url);
	public static native boolean assignJobToSlave(Slave slave, SimpleJob job);
	public static native boolean disconnectSlave(Slave slave);
	/**
		 Send the slave that was put on hold back to TDELauncher. This
		 allows another process to take over the slave and resume the job
		 the that was started.
		 Register the mainwindow <code>wid</code> with the TDEIO subsystem
		 Do not call this, it is called automatically from
		 void TDEIO.Job.setWindow(TQWidget).
			@param wid the window to register
				@short    Send the slave that was put on hold back to TDELauncher.
	*/
	public static native void registerWindow(TQWidget wid);
	/**
			 Unregisters the window registered by registerWindow().
		         		@short
	*/
	public static native void unregisterWindow(TQObject wid);
	/**
		 Function to connect signals emitted by the scheduler.
				@short    Function to connect signals emitted by the scheduler.
		@see #slaveConnected
		@see #slaveError
	*/
	public static native boolean connect(String signal, TQObject receiver, String member);
	public static native boolean connect(TQObject sender, String signal, TQObject receiver, String member);
	public static native boolean disconnect(TQObject sender, String signal, TQObject receiver, String member);
	/**
		 When true, the next job will check whether TDELauncher has a slave
		 on hold that is suitable for the job.
			@param b true when TDELauncher has a job on hold
		         		@short    When true, the next job will check whether TDELauncher has a slave   on hold that is suitable for the job.
	*/
	public static native void checkSlaveOnHold(boolean b);
	// void setupSlave(TDEIO::Slave* arg1,const KURL& arg2,const TQString& arg3,const TQString& arg4,bool arg5,const TDEIO::MetaData* arg6); >>>> NOT CONVERTED
	protected native void setupSlave(Slave slave, KURL url, String protocol, String proxy, boolean newSlave);
	// bool startJobScheduled(TDEIO::Scheduler::ProtocolInfo* arg1); >>>> NOT CONVERTED
	protected native boolean startJobDirect();
	public Scheduler() {
		super((Class) null);
		newScheduler();
	}
	private native void newScheduler();
	protected native void startStep();
	protected native void slotCleanIdleSlaves();
	protected native void slotSlaveConnected();
	protected native void slotSlaveError(int error, String errorMsg);
	protected native void slotScheduleCoSlave();
	protected native void slotUnregisterWindow(TQObject arg1);
	/**
		 Returns the object id of the DCOPObject.
				@return the object's id

		@short    Returns the object id of the DCOPObject.
	*/
	public native String objId();
	/**
		 Renames a dcop object, if no other with the same name exists
		 Use with care, all dcop signals are disconnected
			@param objId the new object id
				@short    Renames a dcop object, if no other with the same name exists  Use with care, all dcop signals are disconnected
	*/
	public native boolean setObjId(String objId);
	/**
		 This function is of interest when you used an IDL compiler
		 to generate the implementation for process() but
		 you still want to dispatch some functions dynamically.
		 Dynamically means that methods may appear and vanish
		 during runtime.
			@param fun is the normalized function signature.
		            Such a signature usually looks like
		            foobar(String,int). The return type,
		            qualifiers like "const" etc. are not part of
		            the signature.
			@param data the received data
			@param replyType write the reply type in this string
			@param replyData write the reply data in this array
				@return true if successful, false otherwise. The default implementation
         returns always false.

		@short    This function is of interest when you used an IDL compiler  to generate the implementation for process() but  you still want to dispatch some functions dynamically.
		@see #process
		@see DCOPClient#normalizeFunctionSignature
		@see #functions
		@see DCOPClient#process
	*/
	public native boolean processDynamic(String fun, byte[] data, StringBuffer replyType, byte[] replyData);
	/**
		 This function is of interest when you used an IDL compiler
		 to generate the implementation for functions() but
		 you still want to list some functions dynamically.
		 Dynamically means that the methods may appear and vanish
		 during runtime.
				@return A list of the additional functions, default is an empty list.

		@short    This function is of interest when you used an IDL compiler  to generate the implementation for functions() but  you still want to list some functions dynamically.
		@see #functions
	*/
	public native ArrayList functionsDynamic();
	/**
		 This function is of interest when you used an IDL compiler
		 to generate the implementation for interfaces() but
		 you still want to list some interfaces dynamically.
		 Dynamically means that they may appear and vanish
		 during runtime.
				@return A list of the additional interfaces, default is an empty list.

		@short    This function is of interest when you used an IDL compiler  to generate the implementation for interfaces() but  you still want to list some interfaces dynamically.
		@see #interfaces
	*/
	public native ArrayList interfacesDynamic();
	/**
		 Returns the names of the interfaces, specific ones last. The
		 functions gets reimplemented by the IDL compiler. If you don't
		 use the IDL compiler, consider implementing this function
		 manually if you want your object to be easily explorable.
				@return a list of interfaces

		@short    Returns the names of the interfaces, specific ones last.
		@see #functions
	*/
	public native ArrayList interfaces();
	/**
		 Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as
		 arguments
			@param signal the signal to emit
			@param data the data to send
		   		@short    Emit <code>signal</code> as DCOP signal from this object with <code>data</code> as  arguments
	*/
	public native void emitDCOPSignal(String signal, byte[] data);
	/**
		 Connects to a DCOP signal.
			@param sender the name of the client that emits the signal. When empty
		 the signal will be passed from any client.
			@param senderObj the name of the sending object that emits the signal.
			@param signal the name of the signal. The arguments should match with slot.
			@param slot The name of the slot to call. Its arguments should match with signal.
			@param Volatile If true, the connection will not be reestablished when
		 <code>sender</code> unregisters and reregisters with DCOP. In this case the <code>sender</code>
		 must be registered when the connection is made.
		 If false, the connection will be reestablished when <code>sender</code> reregisters.
		 In this case the connection can be made even if <code>sender</code> is not registered
		 at that time.

			<li>
			<code>Volatile</code> is true and <code>sender</code>  does not exist.
			</li>

			<li>
			<code>signal</code> and <code>slot</code> do not have matching arguments.

			</li>		@return false if a connection could not be established.
 This will be the case when

		@short    Connects to a DCOP signal.
	*/
	public native boolean connectDCOPSignal(String sender, String senderObj, String signal, String slot, boolean Volatile);
	/**
		 Disconnects a DCOP signal.
			 A special case is when both <code>sender</code> & <code>signal</code> are empty. In this
		 case all connections related to this object in the current client
		 are disconnected. (Both connections from as well as to this object!)
			@param sender the name of the client that emits the signal.
			@param senderObj the name of the object that emits the signal.
		 If empty all objects will be disconnected.
			@param signal the name of the signal. The arguments should match with slot.
		 If empty all objects will be disconnected.
			@param slot The name of the slot the signal is connected to.
		 If empty all slots will be disconnected.
				@return false if no connection(s) where removed.

		@short    Disconnects a DCOP signal.
	*/
	public native boolean disconnectDCOPSignal(String sender, String senderObj, String signal, String slot);
	/**
		 Returns the DCOPClient responsible for making the call.
		 Only call this function while you are handling a DCOP call.
				@return the DCOPClient responsible for making the call.
 This information is only guaranteed to be correct when
 entering your DCOP function.

		@short    Returns the DCOPClient responsible for making the call.
	*/
	public native DCOPClient callingDcopClient();
	/**
				@short
	*/
	public native void setCallingDcopClient(DCOPClient arg1);
	/**
		 Checks whether an object with the given id is known in this process.
			 DCOPObjectProxy
		   		@return true if an object with the questionable <code>objId</code> is
         known in this process. This query does not ask proxies.

		@short    Checks whether an object with the given id is known in this process.
	*/
	public static native boolean hasObject(String objId);
	/**
		 Try to find a dcop object with the given id.
		 This function does not query the DCOPObjectProxy.
			@param objId the object id to search
				@return the  DCOPObject for the id <code>objId.</code>

		@short    Try to find a dcop object with the given id.
	*/
	public static native DCOPObjectInterface find(String objId);
	/**
		 Tries to find an object using a partial object id.
		 This function is used for multicasting a DCOP message to
		 several objects inside a single process.
			@param partialId the partial object id to search for
				@return a list of DCOPObjects beginning with the string
 contained in <code>partialId.</code>

		@short    Tries to find an object using a partial object id.
	*/
	// TQPtrList<DCOPObject> match(const TQCString& arg1); >>>> NOT CONVERTED
	/**
		 Creates an object id for the TQObject <code>obj.</code> This is done
		 using the TQObject.name() function.
			@param obj the object whose name will be used
				@return the created object id

		@short    Creates an object id for the TQObject <code>obj.</code>
	*/
	public static native String objectName(TQObject arg1);
}
