//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQUrlInterface;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQUrl;

/**

 @brief Represents and parses a URL
 A prototypical URL looks like:
 @code
   protocol://user:password@hostname:port/path/to/file.ext#reference
 @endcode
 KURL handles escaping of URLs. This means that the specification
 of a full URL will differ from the corresponding string that would specify a
 local file or directory in file-operations like fopen. This is because an URL
 doesn't allow certain characters and escapes them.
 For examle:
 - '#' . "%23"
  (In a URL the hash-character @c '#' is used to specify a "reference", i.e.
  the position within a document)
 - space . "%20"
 The constructor KURL(String) expects a string properly escaped,
 or at least non-ambiguous.
 For instance a local file or directory <tt>"/bar/#foo#"</tt> would have the
 URL <tt>"file:///bar/%23foo%23"</tt>.
 If you have the absolute path and need the URL-escaping you should create
 KURL via the default-constructor and then call setPath(String):
 @code
     KURL kurl;
     kurl.setPath( "/bar/#foo#" );
     String url = kurl.url();    // . "file:///bar/%23foo%23"
 @endcode
 If you have the URL of a local file or directory and need the absolute path,
 you would use path().
 @code
    KURL url( "file:///bar/%23foo%23" );
    ...
    if ( url.isLocalFile() )
       String path = url.path();       // . "/bar/#foo#"
 @endcode
 The other way round: if the user can enter a string, that can be either a
 path or a URL, then you need to use KURL.fromPathOrURL() to build a KURL.
 This must also be considered, when you have separated directory and file
 strings and need to put them together.
 While you can simply concatenate normal path strings, you must take care if
 the directory-part is already an escaped URL.
 (This might be needed if the user specifies a relative path, and your
 program supplies the rest from elsewhere.)
 Wrong:
 @code
    String dirUrl = "file:///bar/";
    String fileName = "#foo#";
    String invalidURL = dirUrl + fileName;   // . "file:///bar/#foo#" won't behave like you would expect.
 @endcode
 Instead you should use addPath().
 Right:
 @code
    KURL url( "file:///bar/" );
    String fileName = "#foo#";
    url.addPath( fileName );
    String validURL = url.url();    // . "file:///bar/%23foo%23"
 @endcode
 Also consider that some URLs contain the password, but this shouldn't be
 visible. Your program should use prettyURL() every time it displays a
 URL, whether in the GUI or in debug output or...
 @code
    KURL url( "ftp://name:password@ftp.faraway.org/bar/%23foo%23");
    String visibleURL = url.prettyURL(); // . "ftp://name@ftp.faraway.org/bar/%23foo%23"
 @endcode
 Note that prettyURL() doesn't change the character escapes (like <tt>"%23"</tt>).
 Otherwise the URL would be invalid and the user wouldn't be able to use it in another
 context.
 KURL has some restrictions regarding the path
 encoding. KURL works internally with the decoded path and
 and encoded query. For example,
 @code
    http://localhost/cgi-bin/test%20me.pl?cmd=Hello%20you
 @endcode
 would result in a decoded path <tt>"/cgi-bin/test me.pl"</tt>
 and in the encoded query <tt>"?cmd=Hello%20you"</tt>.
 Since path is internally always encoded you may <b>not</b> use
 <tt>"%00"</tt> in the path, although this is OK for the query.
		@author Torben Weis <weis@kde.org>

		@short    @brief Represents and parses a URL

*/
public class KURL implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KURL(Class dummy){}

	/**
		 Flags to choose how file: URLs are treated when creating their String
		 representation with prettyURL(int,AdjustementFlags)
			 However it is recommended to use pathOrURL() instead of this variant of prettyURL()
		   		@short    Flags to choose how file: URLs are treated when creating their String  representation with prettyURL(int,AdjustementFlags)
	*/
	public static final int NoAdjustements = 0;
	public static final int StripFileProtocol = 1;

	/**
		 Defines the type of URI we are processing.
		   		@short    Defines the type of URI we are processing.
	*/
	public static final int Auto = 0;
	public static final int Invalid = 1;
	public static final int RawURI = 2;
	public static final int URL = 3;
	public static final int Mailto = 4;

	/**
		 Options for queryItems()
				@short    Options for queryItems()
	*/
	public static final int CaseInsensitiveKeys = 1;

	/**
		 @brief Constructs an empty URL
			 The created instance will also be invalid, see isValid()
		   		@short    @brief Constructs an empty URL
	*/
	public KURL() {
		newKURL();
	}
	private native void newKURL();
	/**
		 @brief Usual constructor, to construct from a string
			 @warning It is dangerous to feed UNIX filenames into this function,
		 this will work most of the time but not always.
			 For example <tt>"/home/Torben%20Weis"</tt> will be considered a URL
		 pointing to the file <tt>"/home/Torben Weis"</tt> instead
		 of to the file <tt>"/home/Torben%20Weis"</tt>.
			 This means that if you have a usual UNIX like path you should not use
		 this constructor. Instead use fromPathOrURL()
			@param url a URL, not a filename. If the URL does not have a protocol
		            part, @c "file:" is assumed
			@param encoding_hint MIB of original encoding of URL.
		        See TQTextCodec.mibEnum()
				@short    @brief Usual constructor, to construct from a string
		@see #fromPathOrURL
	*/
	public KURL(String url, int encoding_hint) {
		newKURL(url,encoding_hint);
	}
	private native void newKURL(String url, int encoding_hint);
	public KURL(String url) {
		newKURL(url);
	}
	private native void newKURL(String url);
	/**
		 @brief Copy constructor
			@param u the KURL to copy
		   		@short    @brief Copy constructor
	*/
	public KURL(KURL u) {
		newKURL(u);
	}
	private native void newKURL(KURL u);
	/**
		 @brief Constructor taking a Qt URL
			 Converts from a Qt URL.
			@param u the TQUrl
		   		@short    @brief Constructor taking a Qt URL
	*/
	public KURL(TQUrlInterface u) {
		newKURL(u);
	}
	private native void newKURL(TQUrlInterface u);
	/**
		 @brief Constructor allowing relative URLs
			 @warning It is dangerous to feed UNIX filenames into this function,
		 this will work most of the time but not always.
			 For example <tt>"/home/Torben%20Weis"</tt> will be considered a URL
		 pointing to the file <tt>"/home/Torben Weis"</tt> instead
		 of to the file <tt>"/home/Torben%20Weis"</tt>.
			 This means that if you have a usual UNIX like path you should not use
		 this constructor. Instead use fromPathOrURL()
			@param _baseurl The base url.
			@param _rel_url A relative or absolute URL.
		        If this is an absolute URL then <code>_baseurl</code> will be ignored.
		        If this is a relative URL it will be combined with <code>_baseurl.</code>
		        Note that <code>_rel_url</code> should be encoded too, in any case.
		        So do NOT pass a path here (use setPath() or addPath() or
		        fromPathOrURL() instead)
			@param encoding_hint MIB of original encoding of URL.
		        See TQTextCodec.mibEnum()
				@short    @brief Constructor allowing relative URLs
		@see #fromPathOrURL
	*/
	public KURL(KURL _baseurl, String _rel_url, int encoding_hint) {
		newKURL(_baseurl,_rel_url,encoding_hint);
	}
	private native void newKURL(KURL _baseurl, String _rel_url, int encoding_hint);
	public KURL(KURL _baseurl, String _rel_url) {
		newKURL(_baseurl,_rel_url);
	}
	private native void newKURL(KURL _baseurl, String _rel_url);
	/**
		 @brief Returns the protocol for the URL
			 Examples for a protocol string are @c "file", @c "http", etc. but also
		 @c "mailto:" and other pseudo protocols.
				@return the protocol of the URL, does not include the colon. If the
         URL is malformed, @c null will be returned

		@short    @brief Returns the protocol for the URL
		@see #setProtocol
		@see #isValid
	*/
	public native String protocol();
	/**
		 @brief Sets the protocol for the URL
			 Examples for a protocol string are @c "file", @c "http", etc. but also
		 @c "mailto:" and other pseudo protocols.
			@param _txt the new protocol of the URL (without colon)
				@short    @brief Sets the protocol for the URL
		@see #protocol
	*/
	public native void setProtocol(String _txt);
	/**
		 @brief Returns the URI processing mode for the URL
				@return the URI processing mode set for this URL

		@short    @brief Returns the URI processing mode for the URL
		@see URIMode
		@see #uriModeForProtocol
	*/
	public native int uriMode();
	/**
		 @brief Returns the decoded user name (login, user id, etc) included in
		        the URL
				@return the user name or @c null if there is no user name

		@short    @brief Returns the decoded user name (login, user id, etc) included in         the URL
		@see #setUser
		@see #hasUser
	*/
	public native String user();
	/**
		 @brief Sets the user name (login, user id, etc) to include in the URL
			 Special characters in the user name will appear encoded in the URL.
		 If there is a password associated with the user, it can be set using
		 setPass().
			@param _txt the name of the user or <code>null</code> to remove the user
				@short    @brief Sets the user name (login, user id, etc) to include in the URL
		@see #user
		@see #hasUser
		@see #hasPass
	*/
	public native void setUser(String _txt);
	/**
		 @brief Tests if this URL has a user name included in it
				@return @c true if the URL has an non-empty user name

		@short    @brief Tests if this URL has a user name included in it
		@see #user
		@see #setUser
		@see #hasPass
	*/
	public native boolean hasUser();
	/**
		 @brief Returns the decoded password (corresponding to user()) included
		        in the URL
			 @note a password can only appear in a URL string if you also set
		 a user, see setUser().
				@return the password or @c null if it does not exist

		@short    @brief Returns the decoded password (corresponding to user()) included         in the URL
		@see #setPass
		@see #hasPass
		@see #hasUser
	*/
	public native String pass();
	/**
		 @brief Sets the password (corresponding to user()) to include in the URL
			 Special characters in the password will appear encoded in the URL.
		 @note a password can only appear in a URL string if you also set
		 a user, see setUser().
			@param _txt the password to set or <code>null</code> to remove the password
				@short    @brief Sets the password (corresponding to user()) to include in the URL
		@see #pass
		@see #hasPass
		@see #hasUser
	*/
	public native void setPass(String _txt);
	/**
		 @brief Tests if this URL has a password included in it
			 @note a password can only appear in a URL string if you also set
		 a user, see setUser().
				@return @c true if there is a non-empty password set

		@short    @brief Tests if this URL has a password included in it
		@see #pass
		@see #setPass
		@see #hasUser
	*/
	public native boolean hasPass();
	/**
		 @brief Returns the decoded hostname included in the URL
				@return the name of the host or @c null if no host is set

		@short    @brief Returns the decoded hostname included in the URL
		@see #setHost
		@see #hasHost
	*/
	public native String host();
	/**
		 @brief Sets the hostname to include in the URL
			 Special characters in the hostname will appear encoded in the URL.
			@param _txt the new name of the host or null to remove the host
				@short    @brief Sets the hostname to include in the URL
		@see #host
		@see #hasHost
	*/
	public native void setHost(String _txt);
	/**
		 @brief Tests if this URL has a hostname included in it
				@return @c true if the URL has a non-empty host

		@short    @brief Tests if this URL has a hostname included in it
		@see #host
		@see #setHost
	*/
	public native boolean hasHost();
	/**
		 @brief Returns the port number included in the URL
				@return the port number or @c 0 if there is no port number specified in
         the URL

		@short    @brief Returns the port number included in the URL
		@see #setPort
		@see #host
	*/
	public native short port();
	/**
		 @brief Sets the port number to include in the URL
			@param _p the new port number or <code>0</code> to have no port number
				@short    @brief Sets the port number to include in the URL
		@see #port
		@see #setHost
	*/
	public native void setPort(short _p);
	/**
		 @brief Returns the current decoded path
			 This does <b>not</b> include the query.
				@return the path of the URL (without query), or @c null if no
         path is set

		@short    @brief Returns the current decoded path
		@see #path(int)
		@see #setPath
		@see #hasPath
	*/
	public native String path();
	/**
		 @brief Returns the current decoded path
			 This does <b>not</b> include the query, see query() for accessing it.
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
				@return the path of the URL (without query), or @c null if no
         path is set

		@short    @brief Returns the current decoded path
		@see #path
		@see #setPath
		@see #hasPath
		@see #adjustPath
	*/
	public native String path(int _trailing);
	/**
		 @brief Sets the decoded path of the URL
			 This does <b>not</b> changed the  query, see setQuery() for that.
			 The <code>path</code> is considered to be decoded, i.e. characters not allowed in
		 path, for example @c '?' will be encoded and does not indicate the
		 beginning of the query part. Something that might look encoded,
		 like @c "%3f" will not become decoded.
			@param path the new, decoded, path or <code>null</code> to remove the path
				@short    @brief Sets the decoded path of the URL
		@see #path
		@see #path(int)
		@see #hasPath
	*/
	public native void setPath(String path);
	/**
		 @brief Tests if this URL has a path included in it
				@return @c true if there is a non-empty path

		@short    @brief Tests if this URL has a path included in it
		@see #path
		@see #setPath
	*/
	public native boolean hasPath();
	/**
		 @brief Resolves @c "." and @c ".." components in path
			 Some servers seem not to like the removal of extra @c '/'
		 even though it is against the specification in RFC 2396.
			@param cleanDirSeparator if <code>true</code>, occurrences of consecutive
		        directory separators (e.g. <tt>"/foo//bar"</tt>) are cleaned up as
		        well
				@short    @brief Resolves @c ".
		@see #hasPath
		@see #adjustPath
	*/
	public native void cleanPath(boolean cleanDirSeparator);
	public native void cleanPath();
	/**
		 @brief Adds or removes a trailing slash to/from the path
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
				@short    @brief Adds or removes a trailing slash to/from the path
		@see #hasPath
		@see #cleanPath
	*/
	public native void adjustPath(int _trailing);
	/**
		 @brief Sets both path and query of the URL in their encoded form
			 This is useful for HTTP. It looks first for @c '?' and decodes then,
		 see setEncodedPath().
		 The encoded path is the concatenation of the current path and the query.
			@param _txt the new encoded path and encoded query
			@param encoding_hint MIB of original encoding of <code>_txt</code> .
		        See TQTextCodec.mibEnum()
				@short    @brief Sets both path and query of the URL in their encoded form
		@see #encodedPathAndQuery
		@see #setPath
		@see #setQuery
	*/
	public native void setEncodedPathAndQuery(String _txt, int encoding_hint);
	public native void setEncodedPathAndQuery(String _txt);
	/**
		 @brief Sets the (already encoded) path of the URL
			@param _txt the new encoded path
			@param encoding_hint MIB of original encoding of <code>_txt</code> .
		        See TQTextCodec.mibEnum()
				@short    @brief Sets the (already encoded) path of the URL
		@see #setEncodedPathAndQuery
		@see #setPath
	*/
	public native void setEncodedPath(String _txt, int encoding_hint);
	public native void setEncodedPath(String _txt);
	/**
		 @brief Returns the encoded path and the query
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
			@param _no_empty_path if set to <code>true</code> then an empty path is substituted
		        by @c "/"
			@param encoding_hint MIB of desired encoding of URL.
		        See TQTextCodec.mibEnum()
				@return the concatenation of the encoded path , @c '?' and the
         encoded query

		@short    @brief Returns the encoded path and the query
		@see #setEncodedPathAndQuery
		@see #path
		@see #query
	*/
	public native String encodedPathAndQuery(int _trailing, boolean _no_empty_path, int encoding_hint);
	public native String encodedPathAndQuery(int _trailing, boolean _no_empty_path);
	public native String encodedPathAndQuery(int _trailing);
	public native String encodedPathAndQuery();
	/**
		 @brief Sets the encoded query of the URL
			 The query should start with a @c '?'. If it doesn't @c '?' is prepended.
			@param _txt this is considered to be encoded. This has a good reason:
		             the query may contain the @c '0' character
			@param encoding_hint MIB of the encoding. Reserved, should be <code>0</code> .
		        See TQTextCodec.mibEnum()
				@short    @brief Sets the encoded query of the URL
		@see #query
	*/
	public native void setQuery(String _txt, int encoding_hint);
	public native void setQuery(String _txt);
	/**
		 @brief Returns the encoded query of the URL
			 The query may contain the @c '0' character.
		 If a query is present it always starts with a @c '?'.
		 A single @c '?' means an empty query.
		 An empty string means no query.
				@return the encoded query or @c null if there is none

		@short    @brief Returns the encoded query of the URL
		@see #setQuery
	*/
	public native String query();
	/**
		 @brief Returns the encoded reference of the URL
			 The reference is <b>never</b> decoded automatically.
				@return the undecoded reference, or @c null if there is none

		@short    @brief Returns the encoded reference of the URL
		@see #setRef
		@see #hasRef
		@see #htmlRef
	*/
	public native String ref();
	/**
		 @brief Sets the encoded reference part (everything after @c '#')
			 This is considered to be encoded, i.e. characters that are not allowed
		 as part of the reference will <b>not</b> be encoded.
			@param _txt the encoded reference or <code>null</code> to remove it
				@short    @brief Sets the encoded reference part (everything after @c '#')
		@see #ref
		@see #hasRef
	*/
	public native void setRef(String _txt);
	/**
		 @brief Tests if the URL has a reference part
				@return @c true if the URL has a reference part. In a URL like
         <tt>"http://www.kde.org/kdebase.tar#tar:/README"</tt> it would
         return @c true as well

		@short    @brief Tests if the URL has a reference part
		@see #ref
		@see #setRef
	*/
	public native boolean hasRef();
	/**
		 @brief Returns decoded the HTML-style reference
		        (the part of the URL after @c '#')
				@return the HTML-style reference

		@short    @brief Returns decoded the HTML-style reference         (the part of the URL after @c '#')
		@see #encodedHtmlRef
		@see #setHTMLRef
		@see #hasHTMLRef
		@see #split
		@see #hasSubURL
		@see #ref
	*/
	public native String htmlRef();
	/**
		 @brief Returns the encoded HTML-style reference
		        (the part of the URL after @c '#')
				@return the HTML-style reference in its original, encoded, form

		@short    @brief Returns the encoded HTML-style reference         (the part of the URL after @c '#')
		@see #htmlRef
		@see #setHTMLRef
		@see #hasHTMLRef
	*/
	public native String encodedHtmlRef();
	/**
		 @brief Sets the decoded HTML-style reference
			@param _ref the new reference. This is considered to be <b>not</b> encoded in
		         contrast to setRef(). Use <code>null</code> to remove it
				@short    @brief Sets the decoded HTML-style reference
		@see #htmlRef
		@see #hasHTMLRef
	*/
	public native void setHTMLRef(String _ref);
	/**
		 @brief Tests if there is an HTML-style reference
				@return @c true if the URL has an HTML-style reference

		@short    @brief Tests if there is an HTML-style reference
		@see #htmlRef
		@see #encodedHtmlRef
		@see #setHTMLRef
		@see #hasRef
	*/
	public native boolean hasHTMLRef();
	/**
		 @brief Tests if the URL is well formed
				@return @c false if the URL is malformed. This function does @em not test
         whether sub URLs are well-formed as well

		@short    @brief Tests if the URL is well formed
	*/
	public native boolean isValid();
	/**
		 @brief Tests if the file is local
				@return @c true if the file is a plain local file and has no filter
         protocols attached to it

		@short    @brief Tests if the file is local
	*/
	public native boolean isLocalFile();
	/**
		 @brief Adds file encoding information
			 Adds encoding information to the URL by adding a @c "charset" parameter.
		 If there is already a charset parameter, it will be replaced.
			@param encoding the encoding to add or <code>null</code> to remove the
		                 encoding
				@short    @brief Adds file encoding information
		@see #fileEncoding
		@see org.trinitydesktop.qt.TQTextCodec#codecForName
	*/
	public native void setFileEncoding(String encoding);
	/**
		 @brief Returns encoding information of the URL
			 The encoding information is the content of the @c "charset" parameter.
				@return an encoding suitable for TQTextCodec.codecForName()
         or @c null if not encoding was specified

		@short    @brief Returns encoding information of the URL
	*/
	public native String fileEncoding();
	/**
		 @brief Tests if the URL has any sub URLs
			 See split() for examples for sub URLs.
				@return @c true if the file has at least one sub URL

		@short    @brief Tests if the URL has any sub URLs
		@see #split
	*/
	public native boolean hasSubURL();
	/**
		 @brief Adds to the current path
			 Assumes that the current path is a directory. <code>_txt</code> is appended to the
		 current path. The function adds @c '/' if needed while concatenating.
		 This means it does not matter whether the current path has a trailing
		 @c '/' or not. If there is none, it becomes appended. If <code>_txt</code>
		 has a leading @c '/' then this one is stripped.
			@param txt the text to add. It is considered to be decoded
				@short    @brief Adds to the current path
		@see #setPath
		@see #hasPath
	*/
	public native void addPath(String txt);
	/**
		 @brief Returns the value of a certain query item
			@param item item whose value we want
				@return the value of the given query item name or @c null if the
         specified item does not exist

		@short    @brief Returns the value of a certain query item
		@see #addQueryItem
		@see #removeQueryItem
		@see #queryItems
		@see #query
	*/
	public native String queryItem(String item);
	/**
		 @brief Returns the value of a certain query item
			@param item item whose value we want
			@param encoding_hint MIB of encoding of query.
		        See TQTextCodec.mibEnum()
				@return the value of the given query item name or @c null if the
         specified item does not exist

		@short    @brief Returns the value of a certain query item
		@see #addQueryItem
		@see #removeQueryItem
		@see #queryItems
		@see #query
	*/
	public native String queryItem(String item, int encoding_hint);
	/**
			   		@short
	*/
	// TQMap<TQString, TQString> queryItems(int arg1); >>>> NOT CONVERTED
	// TQMap<TQString, TQString> queryItems(); >>>> NOT CONVERTED
	/**
		 @brief Returns the list of query items as a map mapping keys to values
			@param options any of QueryItemsOptions <em>OR</em>ed together
			@param encoding_hint MIB of encoding of query.
		        See TQTextCodec.mibEnum()
				@return the map of query items or the empty map if the URL has no
         query items

		@short    @brief Returns the list of query items as a map mapping keys to values
		@see #queryItem
		@see #addQueryItem
		@see #removeQueryItem
		@see #query
	*/
	// TQMap<TQString, TQString> queryItems(int arg1,int arg2); >>>> NOT CONVERTED
	/**
		 @brief Adds an additional query item
			 To replace an existing query item, the item should first be
		 removed with removeQueryItem()
			@param _item name of item to add
			@param _value value of item to add
			@param encoding_hint MIB of encoding to use for _value.
		        See TQTextCodec.mibEnum()
				@short    @brief Adds an additional query item
		@see #queryItem
		@see #queryItems
		@see #query
	*/
	public native void addQueryItem(String _item, String _value, int encoding_hint);
	public native void addQueryItem(String _item, String _value);
	/**
		 @brief Removea an item from the query
			@param _item name of item to remove
				@short    @brief Removea an item from the query
		@see #addQueryItem
		@see #queryItem
		@see #queryItems
		@see #query
	*/
	public native void removeQueryItem(String _item);
	/**
		 @brief Sets the filename of the path
			 In comparison to addPath() this function does not assume that the current
		 path is a directory. This is only assumed if the current path ends
		 with @c '/'.
			 If the current path ends with @c '/' then <code>_txt</code> is just appended,
		 otherwise all text behind the last @c '/' in the current path is erased
		 and <code>_txt</code> is appended then. It does not matter whether <code>_txt</code> starts
		 with @c '/' or not.
			 Any reference is reset.
			@param _txt the filename to be set. It is considered to be decoded
				@short    @brief Sets the filename of the path
		@see #fileName
		@see #setDirectory
		@see #setPath
	*/
	public native void setFileName(String _txt);
	/**
		 @brief Returns the filename of the path
			 <code>_ignore_trailing_slash_in_path</code> tells whether a trailing @c '/' should
		 be ignored. This means that the function would return @c "torben" for
		 <tt>"file:///hallo/torben/"</tt> and <tt>"file:///hallo/torben"</tt>.
			@param _ignore_trailing_slash_in_path if set to <code>false</code>, then everything
		        behind the last @c '/' is considered to be the filename
				@return the filename of the current path. The returned string is decoded.
         @c null if there is no file (and thus no path)

		@short    @brief Returns the filename of the path
		@see #setFileName
		@see #directory
		@see #path
	*/
	public native String fileName(boolean _ignore_trailing_slash_in_path);
	public native String fileName();
	/**
		 @brief Returns the directory of the path
			 The directory is everything between the last and the second last @c '/'
		 is returned. For example <tt>"file:///hallo/torben/"</tt> would return
		 <tt>"/hallo/torben/"</tt> while <tt>"file:///hallo/torben"</tt> would
		 return <tt>"hallo/"</tt>.
			 <code>_ignore_trailing_slash_in_path</code> tells whether a trailing @c '/' should
		 be ignored. This means that the function would return @c "/hallo"
		 (or @c "/hallo" depending on <code>_strip_trailing_slash_from_result</code>) for
		 <tt>"file:///hallo/torben/"</tt> and <tt>"file:///hallo/torben"</tt>.
			@param _strip_trailing_slash_from_result tells whether the returned result
		        should end with @c '/' or not. If the path is empty or just @c "/"
		        then this flag has no effect
			@param _ignore_trailing_slash_in_path if set to <code>false</code>, then everything
		        behind the last @c '/' is considered to be the filename
				@return the directory part of the current path or @c null when
         there is no path. The returned string is decoded

		@short    @brief Returns the directory of the path
		@see #setDirectory
		@see #fileName
		@see #path
	*/
	public native String directory(boolean _strip_trailing_slash_from_result, boolean _ignore_trailing_slash_in_path);
	public native String directory(boolean _strip_trailing_slash_from_result);
	public native String directory();
	/**
		 @brief Sets the directory of the path, leaving the filename empty
			@param dir the decoded directory to set
				@short    @brief Sets the directory of the path, leaving the filename empty
		@see #directory
		@see #setFileName
		@see #setPath
	*/
	public native void setDirectory(String dir);
	/**
		 @brief Changes the directory by descending into the given directory
			 It is assumed the current URL represents a directory.
		 If <code>_dir</code> starts with a @c '/' the current URL will be
		 <tt>"protocol://host/dir"</tt> otherwise <code>_dir</code> will be appended to the
		 path. <code>_dir</code> can be @c ".."
			 This function won't strip protocols. That means that when you are in
		 <tt>"file:///dir/dir2/my.tgz#tar:/"</tt> and you do <tt>cd("..")</tt> you
		 will still be in <tt>"file:///dir/dir2/my.tgz#tar:/"</tt>
			@param _dir the directory to change to
				@return @c true if successful

		@short    @brief Changes the directory by descending into the given directory
		@see #directory
		@see #path
	*/
	public native boolean cd(String _dir);
	/**
		 @brief Returns the URL as string, with all escape sequences intact,
		        encoded in a given charset
			 This is used in particular for encoding URLs in UTF-8 before using them
		 in a drag and drop operation.
			 @note that the string returned by url() will include the password of the
		 URL. If you want to show the URL to the user, use prettyURL().
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
			@param encoding_hint MIB of encoding to use.
		        See TQTextCodec.mibEnum()
				@return the complete URL, with all escape sequences intact, encoded
         in a given charset

		@short    @brief Returns the URL as string, with all escape sequences intact,         encoded in a given charset
		@see #prettyURL
		@see #pathOrURL
		@see #htmlURL
	*/
	public native String url(int _trailing, int encoding_hint);
	public native String url(int _trailing);
	public native String url();
	/**
		 @brief Returns the URL as string in human-friendly format
			 Example:
		 @code
		 http://localhost:8080/test.cgi?test=hello world&name=fred
		 @endcode
			 Does <b>not</b> contain the password if the URL has one, use url() if you
		 need to have it in the string.
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
				@return a human readable URL, with no non-necessary encodings/escaped
         characters. Password will not be shown

		@short    @brief Returns the URL as string in human-friendly format
		@see #url
		@see #pathOrURL
	*/
	public native String prettyURL(int _trailing);
	public native String prettyURL();
	/**
		 @brief Returns the URL as string in human-friendly format
		 Example:
		 @code
		 http://localhost:8080/test.cgi?test=hello world&name=fred
		 @endcode
			 Does <b>not</b> contain the password if the URL has one, use url() if you
		 need to have it in the string.
			 The <code>_trailing</code> parameter allows to ensure the existance or absence of
		 the last (trailing) @c '/' character in the path.
		 If the URL has no path, then no @c '/' is added anyway.
		 And on the other side: if the path is just @c "/", then this character
		 won't be stripped.
			 Reason: <tt>"ftp://weis@host"</tt> means something completely different
		 than <tt>"ftp://weis@host/"</tt>.
		 So adding or stripping the '/' would really alter the URL, while
		 <tt>"ftp://host/path"</tt> and <tt>"ftp://host/path/"</tt> mean the same
		 directory.
			@param _trailing May be ( @c -1, <code>0</code>, @c +1 ). @c -1 strips a trailing
		                  @c '/', @c +1 adds a trailing @c '/' if there is none yet
		                  and <code>0</code> returns the path unchanged
			@param _flags if StripFileProtocol, @c "file://" will be stripped.
		        The use of this method is now discouraged, better use pathOrURL().
				@return a human readable URL, with no non-necessary encodings/escaped
         characters. Password will not be shown

		@short    @brief Returns the URL as string in human-friendly format  Example:  @code  http://localhost:8080/test.
		@see #prettyURL
		@see #url
		@see #pathOrURL
	*/
	public native String prettyURL(int _trailing, int _flags);
	/**
		 @brief Returns the URL as a string depending if it is a local file
			 It will be either the URL (as prettyURL() would return) or, when the URL
		 is a local file without query or ref, the path().
			 Use this method, together with its opposite, fromPathOrURL(),
		 to display and even let the user edit URLs.
				@return the path or URL string depending on its properties

		@short    @brief Returns the URL as a string depending if it is a local file
		@see #prettyURL
		@see #path
		@see #url
		@see #isLocalFile
	*/
	public native String pathOrURL();
	/**
		 @brief Returns the URL as string, escaped for HTML
				@return a human readable URL, with no non-necessary encodings/escaped
         characters which is HTML encoded for safe inclusion in HTML or
         rich text. Password will not be shown.

		@short    @brief Returns the URL as string, escaped for HTML
		@see #prettyURL
		@see #url
		@see #pathOrURL
	*/
	public native String htmlURL();
	/**
		 @brief Tests if the KURL is empty
			 An empty URL has neither path nor protocol set.
				@return @c true if the URL is empty

		@short    @brief Tests if the KURL is empty
		@see #hasPath
		@see #protocol
		@see #isValid
	*/
	public native boolean isEmpty();
	/**
		 @brief Returns the URL that is the best possible candidate for on level
		        higher in the path hierachy
			 This function is useful to implement the "Up" button in a file manager for
		 example.
		 cd() never strips a sub-protocol. That means that if you are in
		 <tt>"file:///home/x.tgz#gzip:/#tar:/"</tt> and hit the up button you
		 expect to see <tt>"file:///home"</tt>. The algorithm tries to go up on the
		 right-most URL. If that is not possible it strips the right most URL. It
		 continues stripping URLs until it can go up.
				@return a URL that is a level higher

		@short    @brief Returns the URL that is the best possible candidate for on level         higher in the path hierachy
		@see #cd
		@see #split
		@see #hasSubURL
		@see #path
	*/
	public native KURL upURL();
	/**
		 @brief Tests if this URL is less than the given URL
			 The current URL is consideres <tt>"less than"</tt> then <code>_u</code> if
		 (tested in this order):
		 - it is not valid but <code>_u</code> is. See isValid()
		 - its protocol is "less than" <code>_u</code>'s protocol. See protocol()
		 - its host is "less than" <code>_u</code>'s host. See host()
		 - its port is "less than" <code>_u</code>'s port. See port()
		 - its path is "less than" <code>_u</code>'s path. See path()
		 - its encoded query is "less than" <code>_u</code>'s encoded query. See query()
		 - its endoded reference is "less than" <code>_u</code>'s encoded reference.
		   See ref()
		 - its username is "less than" <code>_u</code>'s username. See user()
		 - its password is "less than" <code>_u</code>'s password. See pass()
			 Examples:
		 @code
		 KURL url1;
		 KURL url2;
			 boolean lessThan = url1 < url2; // false. Both invalid, no protocols
			 url2.setProtocol( null );
		 lessThan = url1 < url2;            // true. url2 is valid because of setProtocol()
			 url1.setProtocol( null );
		 lessThan = url1 < url2;            // false. Both valid and everything empty
			 url1.setProtocol( "http" );
		 url2.setProtocol( "https" );
		 lessThan = url1 < url2;            // true. "http" < "https"
			 url2.setHost( "api.kde.org" );
		 url2.setProtocol( "http" );
		 url2.setProtocol( "www.kde.org" );
		 lessThan = url1 < url2;            // true. protocols equal and "api" < "www"
			 url1.setProtocol( "https" );
		 url2.setProtocol( "http" );
		 lessThan = url1 < url2;            // false. "https" > "http". host doesn't matter yet
		 @endcode
			@param _u the URL to compare to
				@return @c true if the URL is less than <code>_u.</code> Otherwise @c false
         (equal or greater than)

		@short    @brief Tests if this URL is less than the given URL
		@see #operator==
	*/
	public native boolean op_lt(KURL _u);
	/**
		 @brief Tests if this URL is equal to the given one
			 Tests each member for equality unless one of the URLs is invalid
		 in which case they are not considered equal (even if both are invalid).
			 Same as equals() when used with <code>ignore_trailing</code> set to
		 <code>false</code> (default)
			@param _u the URL to compare to
				@return @c true if equal and neither this URL nor <code>_u</code> is malformed.
         Otherwise @c false

		@short    @brief Tests if this URL is equal to the given one
		@see #equals
		@see #isValid
		@see #operator!=
		@see #operator<
	*/
	public native boolean op_equals(KURL _u);
	/**
		 @brief Tests if this URL is equal to the one given as a string
			 Creates a KURL instance for <code>_u</code> and compares with that using
		 the equality operator for two KURLs.
			 See the respective constructor for known limitations.
			@param _u the string to compare to
				@return @c true if equal and neither this URL nor <code>_u</code> is malformed.
         Otherwise @c false

		@short    @brief Tests if this URL is equal to the one given as a string
		@see KURL(const
		@see #int)
		@see #operator==(const
		@see KURL
		@see #equals
		@see #isValid
		@see #operator!=
		@see #operator<
	*/
	public native boolean op_equals(String _u);
	/**
		 @brief Tests if this URL is different from the given one
			 Tests by negating the result of operator==()
			@param _u the URL to compare to
				@return the negated result of operator==()

		@short    @brief Tests if this URL is different from the given one
		@see #operator==
		@see #operator<
	*/
	public native boolean op_not_equals(KURL _u);
	/**
		 @brief Tests if this URL is different from the one given as a string
			 Tests by negating the result of operator==(String)
			@param _u the URL to compare to
				@return the negated result of operator==(String)

		@short    @brief Tests if this URL is different from the one given as a string
		@see #operator==(const
		@see #operator<
	*/
	public native boolean op_not_equals(String _u);
	/**
		 @brief Compares this URL with another one
			@param u the URL to compare this one with
			@param ignore_trailing set to <code>true</code> to ignore trailing @c '/' characters
				@return @c true if both urls are the same

		@short    @brief Compares this URL with another one
		@see #operator==#
		@see This
		@see #function
		@see #should
		@see #be
		@see #used
		@see #if
		@see #you
		@see #want
		@see #to
		@see #ignore
		@see #trailing
		@see @c
		@see #characters
	*/
	public native boolean equals(KURL u, boolean ignore_trailing);
	public native boolean equals(KURL u);
	/**
		 @brief Tests if the given URL is parent of this URL
			 For instance, <tt>"ftp://host/dir/"</tt> is a parent of
		 <tt>"ftp://host/dir/subdir/subsubdir/"</tt>.
				@return @c true if this URL is a parent of <code>u</code> (or the same URL as <code>u</code>)

		@short    @brief Tests if the given URL is parent of this URL
		@see #equals
		@see #cd
	*/
	public native boolean isParentOf(KURL u);
	/**
		 @brief Splits nested URLs into a list of URLs
			 Example for a nested URL:
		 @code
		 file:///home/weis/kde.tgz#gzip:/#tar:/tdebase
		 @endcode
		 A URL like <tt>"http://www.kde.org#tar:/kde/README.hml#ref1"</tt> will be
		 split in <tt>"http://www.kde.org#ref1"</tt> and
		 <tt>"tar:/kde/README.html#ref1"</tt>.
			 That means in turn that @c "#ref1" is an HTML-style reference and not a
		 new sub URL. Since HTML-style references mark a certain position in a
		 document this reference is appended to every URL.
			 The idea behind this is that browsers, for example, only look at the first
		 URL while the rest is not of interest to them.
			@param _url the URL that has to be split
				@return an empty list on error or the list of split URLs

		@short    @brief Splits nested URLs into a list of URLs
		@see #hasSubURL
		@see KURL(const
		@see #int)
		@see #join
	*/
	public static native ArrayList split(String _url);
	/**
		 @brief Splits nested URLs into a list of URLs
			 Example for a nested URL:
		 @code
		 file:///home/weis/kde.tgz#gzip:/#tar:/tdebase
		 @endcode
		 A URL like <tt>"http://www.kde.org#tar:/kde/README.hml#ref1"</tt> will be
		 split in <tt>"http://www.kde.org#ref1"</tt> and
		 <tt>"tar:/kde/README.html#ref1"</tt>.
			 That means in turn that @c "#ref1" is an HTML-style reference and not a
		 new sub URL. Since HTML-style references mark a certain position in a
		 document this reference is appended to every URL.
			 The idea behind this is that browsers, for example, only look at the first
		 URL while the rest is not of interest to them.
			@param _url the URL that has to be split
				@return an empty list on error or the list of split URLs

		@short    @brief Splits nested URLs into a list of URLs
		@see #hasSubURL
		@see #join
	*/
	public static native ArrayList split(KURL _url);
	/**
		 @brief Joins a list of URLs into a single URL with sub URLs
			 Reverses split(). Only the first URL may have a reference. This reference
		 is considered to be HTML-like and is appended at the end of the resulting
		 joined URL.
			@param _list the list to join
				@return the joined URL or an invalid URL if the list is empty

		@short    @brief Joins a list of URLs into a single URL with sub URLs
		@see #split
	*/
	public static native KURL join(ArrayList _list);
	/**
		 @brief Creates a KURL object from a String representing either an
		        absolute path or a real URL
			 Use this method instead of
		 @code
		 String someDir = ...
		 KURL url = someDir;
		 @endcode
			 Otherwise some characters (e.g. the '#') won't be encoded properly.
			@param text the string representation of the URL to convert
				@return the new KURL

		@short    @brief Creates a KURL object from a String representing either an         absolute path or a real URL
		@see #pathOrURL
		@see KURL(const
		@see #int)
	*/
	public static native KURL fromPathOrURL(String text);
	/**
		 @brief Encodes a string for use in URLs
			 Convenience function.
			 Convert unicoded string to local encoding and use %%-style
		 encoding for all common delimiters / non-ascii characters.
			@param str the string to encode (can be <code>null</code>)
			@param encoding_hint MIB of encoding to use.
		        See TQTextCodec.mibEnum()
				@return the encoded string

		@short    @brief Encodes a string for use in URLs
		@see #encode_string_no_slash
		@see #decode_string
	*/
	public static native String encode_string(String str, int encoding_hint);
	public static native String encode_string(String str);
	/**
		 @brief Encodes a string for use in URLs
			 Convenience function.
			 Convert unicoded string to local encoding and use %%-style
		 encoding for all common delimiters and non-ascii characters
		 as well as the slash @c '/'.
			@param str the string to encode (can be <code>null</code>)
			@param encoding_hint MIB of encoding to use.
		        See TQTextCodec.mibEnum()
				@short    @brief Encodes a string for use in URLs
		@see #encode_string
		@see #decode_string
	*/
	public static native String encode_string_no_slash(String str, int encoding_hint);
	public static native String encode_string_no_slash(String str);
	/**
		 @brief Decodes a string as used in URLs
			 Convenience function.
			 Decode %-style encoding and convert from local encoding to unicode.
			 Reverse of encode_string()
			@param str the string to decode (can be <code>null</code>)
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
				@return the decoded string

		@short    @brief Decodes a string as used in URLs
		@see #encode_string
		@see #encode_string_no_slash
	*/
	public static native String decode_string(String str, int encoding_hint);
	public static native String decode_string(String str);
	/**
		 @brief Tests if a given URL is a relative as opposed to an absolute URL
			 Convenience function.
			 Returns whether <code>_url</code> is likely to be a "relative" URL instead of
		 an "absolute" URL.
			@param _url the URL to examine
				@return @c true when the URL is likely to be "relative",
         @c false otherwise

		@short    @brief Tests if a given URL is a relative as opposed to an absolute URL
		@see #relativeURL
	*/
	public static native boolean isRelativeURL(String _url);
	/**
		 @brief Creates an URL relative to a base URL for a given input URL
			 Convenience function
			 Returns a "relative URL" based on <code>base_url</code> that points to <code>url.</code>
			 If no "relative URL" can be created, e.g. because the protocol
		 and/or hostname differ between <code>base_url</code> and <code>url</code> an absolute
		 URL is returned.
			 @note if <code>base_url</code> represents a directory, it should contain
		       a trailing slash
			@param base_url the URL to derive from
			@param url the URL to point to relatively from <code>base_url</code>
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
				@short    @brief Creates an URL relative to a base URL for a given input URL
		@see #isRelativeURL
		@see #relativePath
		@see #adjustPath
	*/
	public static native String relativeURL(KURL base_url, KURL url, int encoding_hint);
	public static native String relativeURL(KURL base_url, KURL url);
	/**
		 @brief Creates a path relative to a base path for a given input path
			 Convenience function
			 Returns a relative path based on <code>base_dir</code> that points to <code>path.</code>
			@param base_dir the base directory to derive from
			@param path the new target directory
			@param isParent an optional pointer to a booleanean which, if provided, will
		        be set to reflect whether <code>path</code> has <code>base_dir</code> as a parent dir
				@short    @brief Creates a path relative to a base path for a given input path
		@see #relativeURL
	*/
	public static native String relativePath(String base_dir, String path, boolean[] isParent);
	public static native String relativePath(String base_dir, String path);
	/**
		 @brief Determines which URI mode is suitable for processing URIs of a
		        given protocol
			@param protocol the protocol name. See protocol()
				@return the URIMode suitable for the given protocol

		@short    @brief Determines which URI mode is suitable for processing URIs of a         given protocol
		@see #uriMode
	*/
	public static native int uriModeForProtocol(String protocol);
	/**
		 @brief Resets the members to their "null" state
			 All String members get reset to <code>null</code>, the port to <code>0</code>
		 the URIMode to <code>Auto</code> and the URL becomes invalid.
			 This is like assigning a null URL, but more efficient as it doesn't
		 require the temporary object.
			 Called by constructors, assignment operators and the parse methods in case
		 of a parsing error.
				@short    @brief Resets the members to their "null" state
		@see #isValid
		@see #isEmpty
	*/
	protected native void reset();
	/**
		 @brief Parses the given string and fills the URL's values on success
			 Treats the string as an URL.
			@param _url the string to parse
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
		   		@short    @brief Parses the given string and fills the URL's values on success
	*/
	protected native void parseURL(String _url, int encoding_hint);
	protected native void parseURL(String _url);
	/**
		 @brief Parses the given string and fills the URL's values on success
			 Treats the string as a generic URI.
			@param _url the string to parse
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
		   		@short    @brief Parses the given string and fills the URL's values on success
	*/
	protected native void parseRawURI(String _url, int encoding_hint);
	protected native void parseRawURI(String _url);
	/**
		 @brief Parses the given string and fills the URL's values on success
			 Treats the string as a @c "mailto:" URI.
			@param _url the string to parse
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
		   		@short    @brief Parses the given string and fills the URL's values on success
	*/
	protected native void parseMailto(String _url, int encoding_hint);
	protected native void parseMailto(String _url);
	/**
		 @brief Parses the given string and fills the URL's values on success
			@param _url the string to parse
			@param encoding_hint MIB of original encoding of <code>str</code> .
		        See TQTextCodec.mibEnum()
		   		@short    @brief Parses the given string and fills the URL's values on success
	*/
	protected native void parse(String _url, int encoding_hint);
	protected native void parse(String _url);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
