//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQt;
import org.trinitydesktop.qt.QtSupport;
import org.trinitydesktop.qt.TQIODevice;
import org.trinitydesktop.qt.TQIODeviceInterface;

/**

 A class for reading / writing (optionally compressed) tar archives.
 KTar allows you to read and write tar archives, including those
 that are compressed using gzip or bzip2.
		@author Torben Weis <weis@kde.org>, David Faure <faure@kde.org>

		@short    A class for reading / writing (optionally compressed) tar archives.

*/
public class KTar extends KArchive  {
	protected KTar(Class dummy){super((Class) null);}
	/**
		 Creates an instance that operates on the given filename
		 using the compression filter associated to given mimetype.
			@param filename is a local path (e.g. "/home/weis/myfile.tgz")
			@param mimetype "application/x-gzip" or "application/x-bzip2"
		 Do not use application/x-tgz or similar - you only need to
		 specify the compression layer !  If the mimetype is omitted, it
		 will be determined from the filename.
		     		@short    Creates an instance that operates on the given filename  using the compression filter associated to given mimetype.
	*/
	public KTar(String filename, String mimetype) {
		super((Class) null);
		newKTar(filename,mimetype);
	}
	private native void newKTar(String filename, String mimetype);
	public KTar(String filename) {
		super((Class) null);
		newKTar(filename);
	}
	private native void newKTar(String filename);
	/**
		 Creates an instance that operates on the given device.
		 The device can be compressed (KFilterDev) or not (TQFile, etc.).
		 @warning Do not assume that giving a TQFile here will decompress the file,
		 in case it's compressed!
			@param dev the device to read from. If the source is compressed, the
		 TQIODevice must take care of decompression
		     		@short    Creates an instance that operates on the given device.
	*/
	public KTar(TQIODeviceInterface dev) {
		super((Class) null);
		newKTar(dev);
	}
	private native void newKTar(TQIODeviceInterface dev);
	/**
		 The name of the tar file, as passed to the constructor
		 Null if you used the TQIODevice constructor.
				@return the name of the file, or null if unknown

		@short    The name of the tar file, as passed to the constructor  Null if you used the TQIODevice constructor.
	*/
	public native String fileName();
	/**
		 Special function for setting the "original file name" in the gzip header,
		 when writing a tar.gz file. It appears when using in the "file" command,
		 for instance. Should only be called if the underlying device is a KFilterDev!
			@param fileName the original file name
		     		@short    Special function for setting the "original file name" in the gzip header,  when writing a tar.
	*/
	public native void setOrigFileName(String fileName);
	public native boolean writeSymLink(String name, String target, String user, String group, long perm, int atime, int mtime, int ctime);
	public native boolean writeDir(String name, String user, String group);
	public native boolean writeDir(String name, String user, String group, long perm, int atime, int mtime, int ctime);
	public native boolean prepareWriting(String name, String user, String group, int size);
	public native boolean prepareWriting(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime);
	public native boolean doneWriting(int size);
	/**
		 Opens the archive for reading.
		 Parses the directory listing of the archive
		 and creates the KArchiveDirectory/KArchiveFile entries.
			@param mode the mode of the file
		     		@short    Opens the archive for reading.
	*/
	protected native boolean openArchive(int mode);
	protected native boolean closeArchive();
	protected native boolean prepareWriting_impl(String name, String user, String group, int size, long perm, int atime, int mtime, int ctime);
	protected native boolean writeDir_impl(String name, String user, String group, long perm, int atime, int mtime, int ctime);
	protected native boolean writeSymLink_impl(String name, String target, String user, String group, long perm, int atime, int mtime, int ctime);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
