<?xml version="1.0" encoding="utf-8"?>
<!--
  ** Author: Marco Ladermann
  ** Date:   Wed Jan 29 08:41:56 CET 2003 @362 /Internet Time/
  ** Purpose:  Convert tags in the UI file to Qt classes 
  ** Changed:
  **
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:kde="http://kde.org/functions"
>

      <!--
      ** Start of mode 'classes'
      ** The patterns with mode "classes" construct a
      ** result tree fragment of "class" elements with the 
      ** Qt classes that should be used for a ui tag.
      -->
    <xsl:template match="action" mode="classes">
        <class>TQAction</class>
        <class>TQKeySequence</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="actiongroup" mode="classes">
        <class>TQActionGroup</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="color" mode="classes">
        <class>TQColor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="cursor" mode="classes">
        <class>TQCursor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="font" mode="classes">
        <class>TQFont</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="grid" mode="classes">
        <class>TQGridLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="hbox" mode="classes">
        <class>TQHBoxLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="iconset" mode="classes">
        <class>TQIconSet</class>
        <class>TQPixmap</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="item" mode="classes">
        <xsl:if test="name(..) = 'widget'">
            <class><xsl:value-of select="concat(../@class, 'Item')"/></class>
        </xsl:if>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="menubar" mode="classes">
        <class>TQMenuBar</class>
        <class>TQPopupMenu</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="pixmap" mode="classes">
        <class>TQPixmap</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="rect" mode="classes">
        <class>TQRect</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="size" mode="classes">
        <xsl:if test="not(name(../..) = 'spacer')">
            <class>TQSize</class>
        </xsl:if>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="sizepolicy" mode="classes">
        <class>TQSizePolicy</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="spacer" mode="classes">
        <class>TQSpacerItem</class>
        <class>TQSizePolicy</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="toolbar" mode="classes">
        <class>TQToolBar</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="vbox" mode="classes">
        <class>TQVBoxLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="palette" mode="classes">
        <class>TQPalette</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="active|disabled|inactive" mode="classes">
        <class>TQColorGroup</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="signal|slot" mode="classes">
        <xsl:message>Check <xsl:value-of select="name()"/>: <xsl:value-of select="."/></xsl:message>
        <xsl:call-template name="kde:classes-in-signature">
            <xsl:with-param name="signature" select="."/>
        </xsl:call-template>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="widget" mode="classes">
        <xsl:choose>
            <xsl:when test="@class = 'TQLayoutWidget'">
                <class>TQWidget</class>
            </xsl:when>
            <xsl:when test="@class = 'TQDataBrowser'">
                <class>TQDataBrowser</class>
                <class>TQSqlForm</class>
            </xsl:when>
            <xsl:otherwise>
                <class><xsl:value-of select="@class"/></class>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'accel']" mode="classes">
        <class>TQKeySequence</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'toolTip']" mode="classes">
        <class>TQToolTip</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'whatsThis']" mode="classes">
        <class>TQWhatsThis</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'database']" mode="classes">
        <class>TQSqlDatabase</class>
        <class>TQSqlCursor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="text()|@*" mode="classes"/>
    
    <!--
      ** End of mode 'classes'
      -->

    <!--
      ** A mode to get classes corresponding to the tag names. This templates
      ** do not recurse and return a simple text value
      -->
    <xsl:template match="action" mode="toClass">
        <xsl:text>TQAction</xsl:text>
    </xsl:template>
    <xsl:template match="actiongroup" mode="toClass">
        <xsl:text>TQActionGroup</xsl:text>
    </xsl:template>
    <xsl:template match="grid" mode="toClass">
        <xsl:text>TQGridLayout</xsl:text>
    </xsl:template>
    <xsl:template match="hbox" mode="toClass">
        <xsl:text>TQHBoxLayout</xsl:text>
    </xsl:template>
    <xsl:template match="iconset" mode="toClass">
        <xsl:text>TQIconSet</xsl:text>
    </xsl:template>
    <xsl:template match="menubar" mode="toClass">
        <xsl:text>TQMenuBar</xsl:text>
    </xsl:template>
    <xsl:template match="pixmap" mode="toClass">
        <xsl:text>TQPixmap</xsl:text>
    </xsl:template>
    <xsl:template match="spacer" mode="toClass">
        <xsl:text>TQSpacerItem</xsl:text>
    </xsl:template>
    <xsl:template match="toolbar" mode="toClass">
        <xsl:text>TQToolBar</xsl:text>
    </xsl:template>
    <xsl:template match="vbox" mode="toClass">
        <xsl:text>TQVBoxLayout</xsl:text>
    </xsl:template>
    <xsl:template match="widget" mode="toClass">
        <xsl:choose>
            <xsl:when test="@class = 'TQLayoutWidget'">
                <class>TQWidget</class>
            </xsl:when>
            <xsl:otherwise>
                <class><xsl:value-of select="@class"/></class>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="*" mode="toClass">
        <xsl:message terminate="yes">Upps! Which class? <xsl:value-of select="name(.)"/></xsl:message>
    </xsl:template>
    
</xsl:stylesheet>

