#!/usr/bin/env ruby
# A quick and dirty web browser demonstrating the direct instantiation 
# of a TDEHTML part. Needless to say: this is NOT a programming paragon :)
# -- gg.
# AK - ported to ruby

require 'Korundum'

opt =     [ [ "+[url]",      "An URL to open at startup.",         ""            ],
            [ "z",           "A dummy binary option.",             ""            ],
            [ "baz <file>",  "A long option with arg.",            ""            ],
            [ "boz <file>",  "Same as above with default value",   "default.txt" ],
          ]            

#TQt::Internal::setDebug TQt::QtDebugChannel::TQTDB_ALL
# Qt.debug_level = TQt::DebugLevel::High

about = KDE::AboutData.new("kludgeror", "Kludgeror", "0.1", "A basic web browser")
KDE::CmdLineArgs::init(ARGV, about)
KDE::CmdLineArgs::addCmdLineOptions opt
args = KDE::CmdLineArgs::parsedArgs

a = KDE::Application.new # BUG, application shouldn't be needed at the top, lets fix this...

class PartHolder < TQt::Object
    signals "setLocBarText(const TQString&)"
    slots "reload()", "goToURL(const TQString&)", "back()", "openURL(const KURL&)" # BUG - the slots should be normalize wrt spaces by the lib

    attr_accessor :part, :history

    def initialize part, *k
        super(*k)
        @part = part 
        @history = []
    end

    def openURL url
        @part.openURL url
        # BUG - a non existant slot emit says horrible things, nothing interesting for user.. very confusing
        # BUG - signal emitting is *very* wrong
        # emit setLocBarText(url.url)
        @history.unshift url unless url == @history[0]
    end

    def reload
        @part.openURL @part.url
    end

    def goToURL(url)
        url = "http://#{url}" unless url =~ /^\w*:/
        openURL KDE::URL.new(url)
    end

    def back
        return unless @history.length > 1
        @history.shift
        openURL @history[0] unless @history.empty?
    end
end

LOC_ED  = 322
ERASE_B = 323
BACK_B  = 324

url = (args.count > 1) ? args.url(0) : KDE::URL.new("http://loki:8080/xml/index.xml")

puts "Dummy z option activated." if args.isSet "z"
puts "Dummy baz option has value: #{args.getOption "baz"}" if args.isSet "baz"
# puts "Dummy boz option has value: #{args.getOption "boz"}" if args.isSet "boz" # B0rked?

toplevel = KDE::MainWindow.new
doc = KDE::HTMLPart.new toplevel, nil, toplevel, nil, 1
# doc = KDE::HTMLPart.new toplevel, nil, toplevel, nil, 1 # KDE::HTMLPart::BrowserViewGUI
ph = PartHolder.new doc

TQt::Object::connect doc.browserExtension, TQ_SIGNAL("openURLRequest(const KURL&, const KParts::URLArgs&)"),
                    ph, TQ_SLOT("openURL(const KURL&)") # BUG this slot must be screwing up wrt marshalling?

ph.openURL url
toplevel.setCentralWidget doc.widget
toplevel.resize 700, 500

begin
  d, viewMenu, fileMenu, locBar, e = nil
  d = doc.domDocument
    viewMenu = d.documentElement.firstChild.childNodes.item(2).toElement
        e = d.createElement "action"
        e.setAttribute "name", "debugRenderTree"
    viewMenu.appendChild e
        e = d.createElement "action"
        e.setAttribute "name", "debugDOMTree"
    viewMenu.appendChild e
    fileMenu = d.documentElement.firstChild.firstChild.toElement
    fileMenu.appendChild d.createElement("separator")
        e = d.createElement "action"
        e.setAttribute "name", "exit"
    fileMenu.appendChild e
    locBar = d.createElement "toolbar"
    locBar.setAttribute "name", "locationBar"
        e = d.createElement "action"
        e.setAttribute "name", "reload"
    locBar.appendChild e
  d.documentElement.appendChild locBar
end

a1 = KDE::Action.new( "Reload", "reload", KDE::Shortcut.new(TQt::Key_F5), ph, TQ_SLOT("reload()"),  doc.actionCollection, "reload" )
a2 = KDE::Action.new( "Exit",   "system-log-out",   KDE::Shortcut.new(0),          a,  TQ_SLOT("quit()"),    doc.actionCollection, "exit" )

toplevel.guiFactory.addClient doc

locBar = toplevel.toolBar("locationBar");
locBar.insertButton "back", BACK_B, TQ_SIGNAL("clicked()"), 
                    ph, TQ_SLOT("back()"), true, "Go back"
locBar.insertLined url.url, LOC_ED, TQ_SIGNAL("returnPressed(const TQString&)"), ph, TQ_SLOT("goToURL(const TQString&)"), true, "Location"
locBar.insertButton "locationbar_erase", ERASE_B, TQ_SIGNAL("clicked()"), 
                    locBar.getLined(LOC_ED), TQ_SLOT("clear()"), true, "Erase the location bar's content", 2
locBar.setItemAutoSized LOC_ED, true
locBar.getLined(LOC_ED).createPopupMenu
comp = locBar.getLined(LOC_ED).completionObject
comp.setCompletionMode KDE::GlobalSettings::CompletionPopupAuto

TQt::Object::connect(locBar.getLined(LOC_ED), TQ_SIGNAL("returnPressed(const TQString&)"),
                    comp, TQ_SLOT("addItem(const TQString&)"))
TQt::Object::connect(ph, TQ_SIGNAL("setLocBarText(const TQString&)"), # BUG - once again...
                    locBar.getLined(LOC_ED), TQ_SLOT("setText(const TQString&)"))

doc.setJScriptEnabled true
doc.setJavaEnabled true
doc.setPluginsEnabled true
doc.setURLCursor TQt::Cursor.new(TQt::PointingHandCursor)

a.setTopWidget doc.widget

TQt::Object::connect doc, TQ_SIGNAL("setWindowCaption(const TQString&)"),
                    doc.widget.topLevelWidget, TQ_SLOT("setCaption(const TQString&)")
toplevel.show

a.exec
