/***************************************************************************
                          knetworkinfo.h  -  description
                             -------------------
    begin                : Fri Jan 17 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNETWORKINFO_H
#define KNETWORKINFO_H

#include <tqstring.h>
#include <tqptrlist.h>
#include "knetworkinterface.h"
#include "kwirelessinterface.h"
#include "kaddressvalidator.h"
#include "kroutinginfo.h"
#include "kdnsinfo.h"

/**Represents the network information
  *@author Juan Luis Baptiste
  */

class KNetworkInfo {
  public: 
	  KNetworkInfo();
	  ~KNetworkInfo();
  private: // Private attributes
    TQPtrList<KNetworkInterface> deviceList;
    KRoutingInfo *routingInfo;
  /** Path to the network script that permits starting/stopping/reloading the
  network. */
    TQString networkScript;
    KDNSInfo *dnsInfo;
    /** Platform name. */
    TQString platformName;
    TQPtrList<KNetworkInfo> profilesList;
    TQString profileName;
  
  public: // Public attributes
    void setDeviceList(TQPtrList<KNetworkInterface> deviceList);
    void setRoutingInfo(KRoutingInfo *routingInfo);
    void setDNSInfo(KDNSInfo *dnsInfo);
    TQPtrList<KNetworkInterface> getDeviceList();
    KRoutingInfo *getRoutingInfo();
    KDNSInfo *getDNSInfo();
    TQString getNetworkScript();
    void setNetworkScript(TQString script);
    /** Returns the platform name KnetworkConf is running on. */
    TQString getPlatformName();
    /** Sets the platform name KNetworkConf is running on. */
    void setPlatformName(TQString name);
    void setProfilesList(TQPtrList<KNetworkInfo> profilesList);
    TQPtrList<KNetworkInfo> getProfilesList();
    void setProfileName(TQString profileName);
    TQString getProfileName();
};

#endif
