/***************************************************************************
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-2000 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

// Trash Can

#include <tqtooltip.h>
#include <tqlabel.h>
#include <tqpainter.h>

#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>

#include "ksvdraglist.h"
#include "ksvdrag.h"
#include "ActionList.h"
#include "trash.h"

KSVTrash::KSVTrash (TQWidget* parent, const char* name)
  : TQFrame (parent, name),
    mKIL (TDEGlobal::iconLoader()),
    mLabel (new TQLabel(this)),
    mOpen (false)
{
  setLineWidth(1);
  setMidLineWidth(0);

  setFrameStyle (TQFrame::StyledPanel | TQFrame::Sunken);

  mLabel->setPixmap(mKIL->loadIcon("trashcan_empty", TDEIcon::Desktop));
  mPixmapWidth = mLabel->pixmap()->width();
  mLabel->setGeometry(5, 7, mPixmapWidth, mPixmapWidth);

  TQToolTip::add(mLabel, i18n("Drag here to remove services"));
  TQToolTip::add(this, i18n("Drag here to remove services"));
    
  setMinimumSize(sizeHint());
  setAcceptDrops(true);

  mLabel->installEventFilter(this);
  mLabel->setAcceptDrops(true);
}

KSVTrash::~KSVTrash()
{
}

void KSVTrash::dropEvent (TQDropEvent* e)
{
  KSVData data;
  KSVDragList* list = static_cast<KSVDragList*> (e->source());

  if (list && strcmp (list->name(), "Scripts")  && KSVDrag::decodeNative (e, data))
	{
	  e->accept();
	  
	  emit undoAction (new RemoveAction (list, &data));
	  delete list->match (data);
	}
  else
	e->ignore();

  if (mOpen)
    {
      mLabel->repaint(); 
      mOpen = false;
    }
}

void KSVTrash::dragMoveEvent ( TQDragMoveEvent* e )
{
  if (e->provides ("application/x-ksysv") &&
      e->source() && strcmp (e->source()->name(), "Scripts"))
    {
      TQPainter p;
	  
      p.begin(mLabel);
      p.drawPixmap( 0, 0, mKIL->loadIcon("trashcan_full", TDEIcon::Desktop) );
      p.end();
	  
      mOpen = true;
      e->accept();
    }
  else
	e->ignore();
}

void KSVTrash::dragLeaveEvent ( TQDragLeaveEvent* )
{
  if (mOpen)
    {
      mLabel->repaint(); 
      mOpen = false;
    }
}

bool KSVTrash::eventFilter( TQObject *, TQEvent *e )
{
  switch (e->type())
    {
    case TQEvent::DragMove:
      dragMoveEvent ( static_cast<TQDragMoveEvent*> (e) );
      return true;
      break;
      
    case TQEvent::DragLeave:
      dragLeaveEvent ( static_cast<TQDragLeaveEvent*> (e) );
      return true;
      break;
      
    case TQEvent::Drop:
      dropEvent ( static_cast<TQDropEvent*> (e) );
      return true;
      break;

    default:
      return false;
    }
}

TQSize KSVTrash::sizeHint() const
{
  static TQSize size = TQSize (mPixmapWidth + 2 * 5, mPixmapWidth + 2 * 7);

  return size;
}

#include "trash.moc"
