/***************************************************************************
                          kdnsinfo.h  -  description
                             -------------------
    begin                : Sat Jan 18 2003
    copyright            : (C) 2003 by Juan Luis Baptiste
    email                : jbaptiste@merlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KDNSINFO_H
#define KDNSINFO_H

#include <tqstring.h>
#include <tqstringlist.h>
#include <tqptrlist.h>
#include "kknownhostinfo.h"

/**
  *@author Juan Luis Baptiste
  */

class KDNSInfo {
public: 
	KDNSInfo();
	~KDNSInfo();
  TQString getDomainName();
  TQString getMachineName();
  TQStringList getNameServers();
  TQStringList getSearchDomains();
  void setNameServers(const TQStringList &nameServer);
  void setSearchDomains(const TQStringList &searchDomains);
  void setDomainName(const TQString &domain);
  void setMachineName(const TQString &machine);  
  TQPtrList<KKnownHostInfo> getKnownHostsList();
  void addKnownHost(KKnownHostInfo *host);
  bool removeKnownHost(int index);
  void setKnownHostsList(TQPtrList<KKnownHostInfo> hostsList);
private: // Private attributes
  TQStringList nameServers;
  TQStringList searchDomains;
  TQString domainName;
  TQString machineName;
  /** List of known hosts (/etc/hosts). */
  TQPtrList<KKnownHostInfo> knownHosts;
};

#endif
