 /***************************************************************************
    pseudoDtd.cpp
    copyright            : (C) 2001-2002 by Daniel Naber
    email                : daniel.naber@t-online.de
 ***************************************************************************/

/***************************************************************************
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or ( at your option ) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 ***************************************************************************/

#ifndef _PLUGIN_KANT_XMLTOOLS_DTD_H
#define _PLUGIN_KANT_XMLTOOLS_DTD_H

#include <tqdom.h>
#include <tqprogressdialog.h>

/**
 * This class contains the attributes for one element.
 * To get ALL attributes, concatenate the two lists.
 */
class ElementAttributes
{
  public:
    TQStringList optionalAttributes;
    TQStringList requiredAttributes;
};

class PseudoDTD
{

  public:
    PseudoDTD();
    ~PseudoDTD();

    void analyzeDTD( TQString &metaDtdUrl, TQString &metaDtd );

    TQStringList allowedElements( TQString parentElement );
    TQStringList allowedAttributes( TQString parentElement );
    TQStringList attributeValues( TQString element, TQString attribute );
    TQStringList entities( TQString start );
    TQStringList requiredAttributes( const TQString &parentElement ) const;

  protected:

    bool parseElements( TQDomDocument *doc, TQProgressDialog *progress );
    bool parseAttributes( TQDomDocument *doc, TQProgressDialog *progress );
    bool parseAttributeValues( TQDomDocument *doc, TQProgressDialog *progress );
    bool parseEntities( TQDomDocument *doc, TQProgressDialog *progress );

    bool m_sgmlSupport;

    // Entities, e.g. <"nbsp", "160">
    TQMap<TQString,TQString> m_entityList;
    // Elements, e.g. <"a", ( "b", "i", "em", "strong" )>
    TQMap<TQString,TQStringList> m_elementsList;
    // Attributes e.g. <"a", ( "href", "lang", "title" )>
    TQMap<TQString,ElementAttributes> m_attributesList;
    // Attribute values e.g. <"td", <"align", ( "left", "right", "justify" )>>
    TQMap< TQString,TQMap<TQString,TQStringList> > m_attributevaluesList;

};

#endif // _PLUGIN_KANT_XMLTOOLS_DTD_H
