/*
   Copyright (C) 2006 Michael Lentner <michaell@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this library; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/

bool DominoStyle::objectEventHandler( const TQStyleControlElementData &ceData,
                                      ControlElementFlags elementFlags,
                                      void* source,
                                      TQEvent *ev )
{
	if (TDEStyle::objectEventHandler(ceData, elementFlags, source, ev)) {
		return true;
	}

	if (!ceData.widgetObjectTypes.contains("TQObject")) {
		return false;
	}
	TQObject* obj = reinterpret_cast<TQObject*>(source);
	
// 	tqDebug("className:   %s  --  name:  %s", obj->className(), obj->name());
	
	if(dynamic_cast<TQComboBox*>(obj)) {
		
		switch(ev->type()) {
			case TQEvent::Paint: {
				
				TQComboBox* cb = dynamic_cast<TQComboBox*>(obj);
				bool tdehtmlWidget = tdehtmlWidgets.contains(cb);
				const TQColorGroup & g = cb->colorGroup();
				
				TQPixmap buffer;
				TQPainter p;
				if(tdehtmlWidget)
					p.begin(cb);
				else {
					buffer.resize(cb->width(), cb->height());
					p.begin(&buffer);
				}
				
				p.setFont(cb->font());
				
				
				if(!tdehtmlWidget && cb->parentWidget() && cb->parentWidget()->backgroundPixmap()){
					
					TQPoint point = cb->backgroundOffset();
					p.drawTiledPixmap( 0, 0, cb->width(), cb->height(),
							*cb->parentWidget()->backgroundPixmap(),
							point.x(), point.y() );
				}
				
				
				TQStyle::SFlags flags = TQStyle::Style_Default;
				if (cb->isEnabled())
					flags |= TQStyle::Style_Enabled;
				if (cb->hasFocus())
					flags |= TQStyle::Style_HasFocus;
				
				if(!cb->listBox()) {
					
					drawComplexControl( TQStyle::CC_ComboBox, &p, ceData, elementFlags, cb->rect(), g,
							flags, (uint)TQStyle::SC_All, /*(cb->arrowDown ? */TQStyle::SC_ComboBoxArrow /*: TQStyle::SC_None )*/, TQStyleOption::Default, cb);
					
					TQRect re = querySubControlMetrics( TQStyle::CC_ComboBox, ceData, elementFlags, TQStyle::SC_ComboBoxEditField, TQStyleOption::Default, cb );
					re = TQStyle::visualRect(re, cb);
					p.setClipRect( re );
					
					TQString str = 0;
					const TQPixmap *pix = 0;
					if(cb->count() > 0) {
						str = cb->text(cb->currentItem());
						cb->pixmap(cb->currentItem());
					}
					if ( !str.isNull() ) {
// 						p.save();
// 						p.setFont(cb->font());
// 						TQFontMetrics fm(cb->font());
// 						int x = re.x(), y = re.y() + fm.ascent();
// 						if( pix )
// 							x += pix->width() + 5;
// 						p.drawText( x, y, str );
// 						p.restore();
						dominoDrawItem( &p, re, AlignCenter, cb->colorGroup(),
								cb->isEnabled(), 0, str, -1,
								&cb->colorGroup().buttonText(), textEffectSettings.mode > 0 ? 1 : 0 );
					}
					if ( pix ) {
						p.fillRect( re.x(), re.y(), pix->width() + 4, re.height(),
								cb->colorGroup().brush( TQColorGroup::Base ) );
						p.drawPixmap( re.x() + 2, re.y() +
								( re.height() - pix->height() ) / 2, *pix );
					}
				}
				else {
					drawComplexControl( TQStyle::CC_ComboBox, &p, ceData, elementFlags, cb->rect(), g,
							flags, (uint)TQStyle::SC_All, /*(d->arrowDown ? */TQStyle::SC_ComboBoxArrow/* : TQStyle::SC_None )*/, TQStyleOption::Default, cb);
					TQRect re = querySubControlMetrics( TQStyle::CC_ComboBox, ceData, elementFlags, TQStyle::SC_ComboBoxEditField, TQStyleOption::Default, cb );
					re = TQStyle::visualRect(re, cb);
					p.setClipRect( re );
					
					if ( !cb->editable() ) {
						
						TQString str = 0;
						const TQPixmap *pix = 0;
						if(cb->count() > 0) {
							str = cb->text(cb->currentItem());
							pix = cb->pixmap(cb->currentItem());
						}
						
						re.addCoords(+2, 0, 0, -1);
						if(pix) {
							drawItem( &p, TQRect(re.left()+1, re.top(), re.width(), re.height()-1), AlignLeft|AlignVCenter, cb->colorGroup(),
									cb->isEnabled(), pix, 0, -1, &cb->colorGroup().buttonText() );
							re.setX(re.x()+pix->width()+2);
						}
						if(!str.isNull()) {
							dominoDrawItem( &p, TQRect(re.left(), re.top(), re.width(), re.height()), AlignLeft|AlignVCenter, cb->colorGroup(),
									cb->isEnabled(), 0, str, -1, &cb->colorGroup().buttonText(), textEffectSettings.mode > 0 ? 1 : 0 );
						}
						else if(!pix) {
							DominoTQListBoxItem * item = (DominoTQListBoxItem*)cb->listBox()->item( cb->currentItem() );
							if ( item ) {
								int itemh = item->height( cb->listBox() );
								p.translate( re.x(), re.y() +(re.height()- itemh)/2);
								item->paint( &p );
							}
						}
					}
					else if ( cb->listBox() && cb->listBox()->item( cb->currentItem() ) ) {
						
						TQListBoxItem * item = cb->listBox()->item( cb->currentItem() );
						const TQPixmap *pix = item->pixmap();
						if ( pix ) {
							if(re.width() < pix->width())
								return true;
							TQColor color = cb->isEnabled() ? cb->lineEdit()->paletteBackgroundColor() : cb->lineEdit()->palette().active().background();
							TQPixmap* shadowPix = renderLineEditShadow(cb, TQRect(0, 0, pix->width() + 3, re.height()), color, Draw_Left, TQApplication::reverseLayout());
	
							if(!TQApplication::reverseLayout()) {
								int x = re.x();
								int y = re.y();
								int w = pix->width() + 4;
								int h = re.height()+re.y();
								
								TQRegion mask(x+3, y, w+3, h);
								mask += TQRegion(x, y+3, 3, h-9);
								p.setClipRegion(mask);
							}
							bitBlt(shadowPix, 3, ( shadowPix->height() - pix->height() ) / 2, pix);
							p.drawPixmap(re.x(), re.y(), *shadowPix);
							delete shadowPix;
						}
					}
				}
				p.end();
				if(!tdehtmlWidget) {
					p.begin(cb);
					p.drawPixmap(0, 0, buffer);
				}
				
				return true;
				
			}
			case TQEvent::Enter: {
				TQButton* btn = static_cast<TQButton*>(obj);
				if(btn->isEnabled()) {
					hoverWidget = btn;
					btn->repaint(false);
				}
				return false;
			}
			case TQEvent::Leave: {
				TQButton* btn = static_cast<TQButton*>(obj);
				if(btn->isEnabled()) {
					hoverWidget = 0;
					btn->repaint(false);
				}
				return false;
			}
			case TQEvent::PaletteChange: {
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Widget);
				return true;
			}
			case TQEvent::ParentPaletteChange: {
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Parent);
				return false;
			}
			case TQEvent::ApplicationPaletteChange: {
				if(!tdehtmlWidgets.contains(static_cast<TQWidget*>(obj)))
					setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Application);
				return true;
			}
			default:
				return false;
		}
	}

	// don't repaint the combobox if the mouse moves over the listbox.
	if(dynamic_cast<TQListBox*>(obj) && dynamic_cast<TQComboBox*>(obj->parent())) {
		
		if(dynamic_cast<TQComboBox*>(obj->parent())) {
			if(ev->type() == TQEvent::Show) {
				TQComboBox* cb = dynamic_cast<TQComboBox*>(obj->parent());
				cb->repaint(false);
				cb->setUpdatesEnabled(false);
				return false;
			}
			if(ev->type() == TQEvent::Hide) {
				TQComboBox* cb = dynamic_cast<TQComboBox*>(obj->parent());
				cb->setUpdatesEnabled(true);
				cb->repaint(false);
				return false;
			}
		}
		// don't return here
	}
	
	if (dynamic_cast<TQLineEdit*>(obj) || (dynamic_cast<TQFrame*>(obj) && dynamic_cast<TQFrame*>(obj)->frameShape() == TQFrame::LineEditPanel) || obj->isA("TQDateTimeEditor")) {
		
		TQWidget* lineEdit = dynamic_cast<TQWidget*>(obj);
		bool tdehtmlMode = tdehtmlWidgets.contains(lineEdit);
		bool isLineEdit = dynamic_cast<TQLineEdit*>(obj);
		bool isReadOnly = isLineEdit && dynamic_cast<TQLineEdit*>(obj)->isReadOnly();
		TQFrame* frame = dynamic_cast<TQFrame*>(obj);
		if((isReadOnly || tdehtmlMode) && frame->frameWidth() <= 0) {
			return false;
		}
		
		bool isEnabled = lineEdit->isEnabled();
		bool isSpinWidget = false;
		bool isComboBox = false;
		bool isDateTimeEditor = false;
		bool hasPixmap = false;
		bool noFrame = false;
		TQRect r = lineEdit->rect();
		
		if(dynamic_cast<TQComboBox*>(lineEdit->parentWidget())) {
			isComboBox = true;
			TQComboBox* cb = dynamic_cast<TQComboBox*>(lineEdit->parentWidget());
			if(cb->count() > 0 && cb->pixmap(cb->currentItem()))
				hasPixmap = true;
		}
		else if(obj->isA("TQDateTimeEditor"))
			isDateTimeEditor = true;
		else if(dynamic_cast<TQSpinWidget*>(lineEdit->parentWidget()))
			isSpinWidget = true;
		else if(isLineEdit && frame->frameShape() == TQFrame::NoFrame)
			noFrame = true;
		
// 		if(isSpinWidget && !isComboBox && frame->frameShape() == TQFrame::NoFrame)
// 			return false;
		
		int x, y, w, h;
		r.rect(&x, &y, &w, &h);

		switch(ev->type()) {
			case TQEvent::Show:
				if(tdehtmlMode)
					return true;
			case TQEvent::Resize: {
				if(noFrame) return false;
				
				if(isLineEdit) {
					TQRect frameRect(r.x()+1, r.y(), r.width()-1, r.height());
					if(frame->frameRect() != frameRect)
						frame->setFrameRect(frameRect);
					
				}
				
				if(isSpinWidget || isComboBox) {
					
					if(!hasPixmap && !TQApplication::reverseLayout()) {
						TQRegion mask(x+3, y, w-3, h);
						mask += TQRegion(x, y+3, 3, h-6);
						lineEdit->setMask(mask);
					}
					else if(TQApplication::reverseLayout()) {
						TQRegion mask(x, y, w-3, h);
						mask += TQRegion(w-3, y+3, 3, h-6);
						lineEdit->setMask(mask);
					}
					else if(isComboBox)
						lineEdit->clearMask();
				}
				else if(isDateTimeEditor) {
					
					if(!TQApplication::reverseLayout()) {
						TQRegion mask(x+2, y, w-2, h);
						mask += TQRegion(x+1, y+1, 1, h-2);
						mask += TQRegion(x, y+2, 1, h-4);
						lineEdit->setMask(mask);
					}
					else {
						TQRegion mask(x, y, w-2, h);
						mask += TQRegion(w-2, y+1, 1, h-2);
						mask += TQRegion(w-1, y+2, 1, h-4);
						lineEdit->setMask(mask);
					}
				}
				
				if(isLineEdit) {
					lineEdit->repaint(false); // not realy needed, but removes some flicker
					return true;
				}
				return false;
			}
			case TQEvent::Paint: {
				
				if(noFrame)
					return false;
				
				const TQColorGroup cg = lineEdit->colorGroup();
				const TQColor bg = !isEnabled ? cg.background() : lineEdit->paletteBackgroundColor();
				TQPainter p;
				
				if(isSpinWidget || isComboBox || isDateTimeEditor) {
					
					 // TQDateTimeEditor doesn't respect background pixmaps :(
					if(w <1 || h <1 || isDateTimeEditor)
						return false;
					
					uint flags = hasPixmap ? Draw_Right : Draw_Left|Draw_Right;
					TQPixmap* lineEditPix = renderLineEditShadow(lineEdit, lineEdit->rect(), bg, flags, TQApplication::reverseLayout());
					lineEdit->setUpdatesEnabled(false);
					lineEdit->setErasePixmap(*lineEditPix);
					// update the gap which resulted from the altered frame rect...
					lineEdit->erase(TQRect(x, y, 1, h));
					lineEdit->setUpdatesEnabled(true);
					delete lineEditPix;
					return false;
				}
				
				
				// normal lineEdit
				const TQPixmap* parentBgPix = lineEdit->parentWidget() ? lineEdit->parentWidget()->paletteBackgroundPixmap() : 0;
				TQPixmap* lineEditEdges = 0;
				if(tdehtmlMode || parentBgPix || !(lineEditEdges = TQPixmapCache::find(TQString::number(bg.pixel(), 16)+TQString::number(cg.background().pixel(), 16)+"lEditEdges"))) {
					if(tdehtmlMode) {
						
						TQPixmap insidePix = tintImage(qembed_findImage("lineedit4inside"), bg);
						bitBlt(lineEdit, x, y, &insidePix, 0, 0, 4, 4);
						bitBlt(lineEdit, w-4, y, &insidePix, 4, 0, 4, 4);
						bitBlt(lineEdit, x, h-4, &insidePix, 0, 4, 4, 4);
						bitBlt(lineEdit, w-4, h-4, &insidePix, 4, 4, 4, 4);
						
						TQPixmap edgesPix = qembed_findImage("lineedit4edges");
						bitBlt(lineEdit, x, y, &edgesPix, 0, 0, 4, 4);
						bitBlt(lineEdit, w-4, y, &edgesPix, 4, 0, 4, 4);
						bitBlt(lineEdit, x, h-4, &edgesPix, 0, 4, 4, 4);
						bitBlt(lineEdit, w-4, h-4, &edgesPix, 4, 4, 4, 4);
					}
					else {
						
						lineEditEdges = new TQPixmap(8, 8);
						if(parentBgPix) {
							TQPoint offset = lineEdit->parentWidget()->backgroundOffset();
							offset += TQPoint(lineEdit->geometry().x(), lineEdit->geometry().y());
							TQPainter painter(lineEditEdges);
							painter.drawTiledPixmap(0, 0, 4, 4, *parentBgPix, offset.x(), offset.y());
							painter.drawTiledPixmap(4, 0, 4, 4, *parentBgPix, offset.x()+r.width()-4, offset.y());
							painter.drawTiledPixmap(0, 4, 4, 4, *parentBgPix, offset.x(), offset.y()+r.height()-4);
							painter.drawTiledPixmap(4, 4, 4, 4, *parentBgPix, offset.x()+r.width()-4, offset.y()+r.height()-4);
						}
						else
							lineEditEdges->fill(cg.background());
						
						TQPixmap tmpPix = tintImage(qembed_findImage("lineedit4inside"), bg);
						bitBlt(lineEditEdges, 0, 0, &tmpPix, 0, 0, 8, 8);
						
						TQPixmap tmpPix2 = qembed_findImage("lineedit4edges");
						bitBlt(lineEditEdges, 0, 0, &tmpPix2, 0, 0, 8, 8);
						
						if(!parentBgPix)
							TQPixmapCache::insert(TQString::number(bg.pixel(), 16)+TQString::number(cg.background().pixel(), 16)+"lEditEdges", *lineEditEdges);
					}
				}
				
				
				TQPixmap* lineEditPix = 0;
				
				if(tdehtmlMode)
					p.begin(lineEdit);
				else {
					lineEditPix = new TQPixmap(w, h);
					p.begin(lineEditPix);
					
					bitBlt(lineEditPix, x, y, lineEditEdges, 0, 0, 4, 4);
					bitBlt(lineEditPix, w-4, y, lineEditEdges, 4, 0, 4, 4);
					bitBlt(lineEditPix, x, h-4, lineEditEdges, 0, 4, 4, 4);
					bitBlt(lineEditPix, w-4, h-4, lineEditEdges, 4, 4, 4, 4);
					
				}
				
				p.fillRect(TQRect(x+4, y, w-8, h), bg);
				p.fillRect(TQRect(x, y+4, 4, h-8), bg);
				p.fillRect(TQRect(w-4, y+4, 4, h-8), bg);
				
				TQColor top_1 = alphaBlendColors(TQColor(26, 26, 26), bg, 125);
				TQColor top_2 = alphaBlendColors(TQColor(18, 18, 18), bg, 50);
				TQColor top_3 = alphaBlendColors(TQColor(16, 16, 16), bg, 6);
				TQColor bottom = alphaBlendColors(TQColor(0, 0, 0), bg, 30);
					
				TQColor left_1 = alphaBlendColors(TQColor(0, 0, 0), bg, 78);
				TQColor left_2 = alphaBlendColors(TQColor(0, 0, 0), bg, 10);
					
				p.setPen(top_1);
				p.drawLine(x+4, y, w-5, y);
				p.setPen(top_2);
				p.drawLine(x+4, y+1, w-5, y+1);
				p.setPen(top_3);
				p.drawLine(x+4, y+2, w-5, y+2);
				p.setPen(bottom);
				p.drawLine(x+4, h-1, w-5, h-1);
					
				p.setPen(left_1);
				p.drawLine(x, y+4, x, h-4);
				p.drawLine(w-1, y+4, w-1, h-4);
				p.setPen(left_2);
				p.drawLine(x+1, y+4, x+1, h-4);
				p.drawLine(w-2, y+4, w-2, h-4);
				p.end();
				
				
				if(!tdehtmlMode) {
					
					if(isLineEdit) {
						// simply drawing the pixmap would be faster, but the problem with the base color as erase color for disabled lineEdits would remain.
						XSetWindowBackgroundPixmap( lineEdit->x11Display(), lineEdit->winId(), lineEditPix->handle());
// 						// erase the frame
						lineEdit->erase(x, y, w, 2);
						lineEdit->erase(x, h-4, w, 4);
						lineEdit->erase(x, y+2, 3, h-4);
						lineEdit->erase(w-3, y+2, 3, h-4);
					}
					else {
						bitBlt(lineEdit, 0, 0, lineEditPix);
					}
					delete lineEditPix;
				}
				return false;
			}
			case TQEvent::MouseButtonPress:
			case 6/*TQEvent::KeyPress*/: {
				// it will be reseted in TQLineEdit::mouseMoveEvent()
				if(isLineEdit && !tdehtmlMode && isEnabled && !isReadOnly && !isDateTimeEditor)
					static_cast<TQWidget*>(obj)->setCursor(TQt::blankCursor);
				return false;
			}
			case TQEvent::ApplicationPaletteChange:
				if(!tdehtmlMode) {
					lineEdit->setBackgroundMode(TQWidget::PaletteBase);
					lineEdit->setPalette(tqApp->palette());
				}
				return true;
			case TQEvent::ParentPaletteChange:
				if(!tdehtmlMode) {
					lineEdit->setBackgroundMode(TQWidget::PaletteBase);
					lineEdit->setPalette(lineEdit->parentWidget()->palette());
				}
				return true;
			case TQEvent::PaletteChange:
				if(!tdehtmlMode) {
					lineEdit->setBackgroundMode(TQWidget::PaletteBase);
					lineEdit->setPalette(lineEdit->palette());
				}
				return true;
			case TQEvent::Wheel:
			case TQEvent::Hide:
			case 7/*TQEvent::KeyRelease*/:
				// jump to smoothscrolling
				if(_smoothScrolling)
					break;
			default:
				return false;
		}
	}
	
	
	
	
	// argb rubberBand
	if(!strcmp(obj->name(), "qt_viewport") && rubberBandType == ArgbRubber) {
		switch(ev->type()) {
			case TQEvent::ChildRemoved:
			case TQEvent::DragMove:
			case TQEvent::DragEnter: {
				if(rubber) {
					viewPortPressed = false;
					oldRubberRect = TQRect();
					rubber->destroy();
				}
				return false;
			}
			case TQEvent::MouseButtonPress: {
				viewPortPressed = true;
				rubberViewPort = static_cast<const TQWidget*>(obj);
				break;
			}
			case TQEvent::MouseButtonRelease:
				if(rubber) {
					viewPortPressed = false;
					rubberViewPort = 0;
					oldRubberRect = TQRect();
					if(dynamic_cast<TQListView*>(obj->parent()) && rubber->window)
						ignoreNextFocusRect = true;
					rubber->destroy();
				}
				
#if TDE_VERSION >= 0x30506
			case TQEvent::Show: {
				char selectionName[64];
				snprintf(selectionName, 64, "_NET_WM_CM_S%d", DefaultScreen(tqt_xdisplay()));
				Atom compSelection = XInternAtom(tqt_xdisplay(), selectionName, False);
				if(XGetSelectionOwner(tqt_xdisplay(), compSelection)) {
					compositeManagerRunning = true;
				}
				else {
					compositeManagerRunning = false;
				}
			}
#endif
			default:
				break;
		}
	}
	
	
	// smoothscrolling
	if(dynamic_cast<TQScrollView*>(obj) && _smoothScrolling) {
		switch(ev->type()) {
			case TQEvent::Wheel: {
				TQWheelEvent* e = (TQWheelEvent*)ev;
				TQScrollView* sv = dynamic_cast<TQScrollView*>(obj);
				bool pageSteps = false;
				int pageStep = sv->verticalScrollBar()->pageStep();
				int lineStep = sv->verticalScrollBar()->lineStep();
				scrollVertical = e->orientation() == TQt::Vertical;
				
				TQScrollBar* scrollBar = scrollVertical ? sv->verticalScrollBar() : sv->horizontalScrollBar();
				
				int step = TQMIN( TQApplication::wheelScrollLines()*lineStep, pageStep );
				if ( ( e->state() & ControlButton ) || ( e->state() & ShiftButton ) ) {
					step = pageStep;
					pageSteps = true;
				}
				int dy = (e->delta()*step)/120;
				
				e->accept();
				scrollWidget = sv;
				scrollDistance += dy;
				
				// don't accumulate to much
				if(scrollDistance < 0) {
					scrollDistance = pageSteps? TQMAX(scrollDistance, pageStep*2-(pageStep*4)): scrollDistance;
					int minDistance = scrollBar->maxValue() - scrollBar->value();
					scrollDistance = TQMAX(scrollDistance, minDistance-(minDistance*2));
				}
				else {
					scrollDistance = pageSteps? TQMIN(scrollDistance, pageStep*2): scrollDistance;
					scrollDistance = TQMIN(scrollDistance, scrollBar->value());
				}
				
				if(scrollDistance != 0) {
					scrollTimer->start(pageSteps? 4: 14);
				}
				
				return true;
			}
			case 7: { // ?? 7 = TQEvent::KeyRelease
				TQKeyEvent* ke = (TQKeyEvent*)ev;
				if(scrollTimer->isActive() && (ke->key() == TQt::Key_Shift || ke->key() == TQt::Key_Control)) {
					scrollTimer->stop();
					scrollDistance = 0;
				}
				return false;
			}
			case TQEvent::WindowActivate:
			case TQEvent::WindowDeactivate:
				// fixes the scrollbar flicker
				return true;
			case TQEvent::Hide:
			case TQEvent::Show:
				scrollDistance = 0;
				// don't return here (because of konqframe and ?)
			default:
				break;
		}
	}


	if ( dynamic_cast<TQScrollBar*>(obj) ) {
		
		switch(ev->type()) {
			case TQEvent::WindowActivate: {
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				if(sb->backgroundMode() == TQt::NoBackground && !sb->testWState(WState_HasMouse)) {
					sb->setBackgroundMode(TQt::PaletteButton);
				}
				return true;
			}
			case TQEvent::Show: {
				// no flicker in konqi and konsole, hits maybe others, too.
				if(obj->parent()->parent() && (!strcmp(obj->parent()->parent()->name(), "KonqFrame") || !strcmp(obj->parent()->parent()->name(), "tab pages"))) {
					dynamic_cast<TQScrollBar*>(obj)->setBackgroundMode(TQt::NoBackground);
				}
				scrollDistance = 0;
				return true;
			}
			case TQEvent::Hide:
				scrollDistance = 0;
				return true;
			case TQEvent::Resize: {
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				if(sb->backgroundMode() != TQt::NoBackground && sb->isVisible()) {
					sb->setBackgroundMode(TQt::NoBackground);
				}
				return false;
			}
			case TQEvent::ParentPaletteChange: {
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				sb->setBackgroundMode(TQt::PaletteButton);
				sb->setPalette(sb->parentWidget()->palette());
				return true;
			}
			case TQEvent::PaletteChange: {
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				sb->setBackgroundMode(TQt::PaletteButton);
				sb->setPalette(sb->palette());
				return true;
			}
			case TQEvent::ApplicationPaletteChange: { // ###
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				removeCachedSbPix(sb->paletteBackgroundColor());
				sb->setBackgroundMode(TQt::PaletteButton);
// 				sb->update();
				return false;
			}
			case TQEvent::Wheel: {
				if(!_smoothScrolling)
					return false;
				TQWheelEvent* e = (TQWheelEvent*)ev;
				TQScrollBar* sb = dynamic_cast<TQScrollBar*>(obj);
				if(!dynamic_cast<TQScrollView*>(sb->parentWidget()))
					return false;
				
				bool pageSteps = false;
				int pageStep = sb->pageStep();
				int lineStep = sb->lineStep();
				
				int step = TQMIN( TQApplication::wheelScrollLines()*lineStep, pageStep );
				if ( ( e->state() & ControlButton ) || ( e->state() & ShiftButton ) ) {
					step = pageStep;
					pageSteps = true;
				}
				int dy = (e->delta()*step)/120;
				
				e->accept();
				scrollWidget = dynamic_cast<TQScrollView*>(sb->parentWidget());
				scrollDistance += dy;
				
				// don't accumulate to much
				if(scrollDistance < 0) {
					scrollDistance = pageSteps? TQMAX(scrollDistance, pageStep*2-(pageStep*4)): scrollDistance;
					int minDistance = sb->maxValue() - sb->value();
					scrollDistance = TQMAX(scrollDistance, minDistance-(minDistance*2));
				}
				else {
					scrollDistance = pageSteps? TQMIN(scrollDistance, pageStep*2): scrollDistance;
					scrollDistance = TQMIN(scrollDistance, sb->value());
				}
				
				scrollVertical = sb->orientation() == TQt::Vertical;
				if(scrollDistance != 0) {
					scrollTimer->start(pageSteps? 4: 14);
				}
				
				return true;
			}
			case 7: { // ?? 7 = TQEvent::KeyRelease
				TQKeyEvent* ke = (TQKeyEvent*)ev;
				if(scrollTimer->isActive() && (ke->key() == TQt::Key_Shift || ke->key() == TQt::Key_Control)) {
					scrollTimer->stop();
					scrollDistance = 0;
				}
				return false;
			}
			default:
				return false;
		}
	}


	if ( dynamic_cast<TQProgressBar*>(obj) && _animateProgressBar)
	{
		switch(ev->type()) {
			case TQEvent::Show:
				if(!animationTimer->isActive())
					animationTimer->start( 50, false );
				return true;
			case TQEvent::Hide:
				if(animationTimer->isActive())
					animationTimer->stop();
				return true;
			case TQEvent::ApplicationPaletteChange:
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Application);
				return true;
			case TQEvent::ParentPaletteChange:
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Parent);
				return true;
			case TQEvent::PaletteChange:
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Widget);
				return true;
			default:
				return false;
		}
	}
	
	if (dynamic_cast<TQStatusBar*>(obj)) {
		if(ev->type() == TQEvent::PaletteChange) {
			TQStatusBar* sb = dynamic_cast<TQStatusBar*>(obj);
			sb->setPaletteBackgroundColor(tqApp->palette().active().background());
			sb->setPaletteForegroundColor(tqApp->palette().active().foreground());
			return true;
		}
		return false;
	}
	
	if (dynamic_cast<TQGroupBox*>(obj) && dynamic_cast<TQFrame*>(obj)->frameShape() == TQFrame::GroupBoxPanel) {
		TQGroupBox* gb = dynamic_cast<TQGroupBox*>(obj);
		TQRect r = gb->rect();
		
		switch(ev->type()) {
			case TQEvent::Paint: {
// 				if(y+16 > h || 16 > w) // don't overlap the pixmaps
// 					return false;
				renderGroupBox(obj, ev);
				return true;
			}
			case TQEvent::Resize: {
				if(!gb->isFlat())
					renderGroupBox(obj, ev);
				return false;
			}
			case TQEvent::ApplicationPaletteChange:
			case TQEvent::PaletteChange:
			case TQEvent::ParentPaletteChange: {
				
				if(gb->isFlat() || gb->lineWidth() <= 0) {
					return false;
				}
				
				TQColor outsideColor = gb->parentWidget() ? gb->parentWidget()->paletteBackgroundColor() : gb->paletteBackgroundColor();
				TQColor insideColor = groupBoxSettings.tintBackground ? getGroupBoxColor(gb) : gb->paletteBackgroundColor();
				
				TQPalette pal(tqApp->palette());
				pal.setColor(TQPalette::Active, TQColorGroup::Background, insideColor);
				pal.setColor(TQPalette::Inactive, TQColorGroup::Background, insideColor);
				pal.setColor(TQPalette::Disabled, TQColorGroup::Background, insideColor);
				pal.setColor(TQPalette::Disabled, TQColorGroup::Text, alphaBlendColors(pal.active().foreground(), insideColor, 40));
				gb->setPalette(pal);
				
				
				if(gb->isCheckable()) {
					((TQCheckBox*)gb->child("qt_groupbox_checkbox", 0, false))->setPaletteBackgroundColor(outsideColor);
				}
				
				if(groupBoxPixmaps.contains(gb)) {
					delete groupBoxPixmaps[gb];
					groupBoxPixmaps.remove(gb);
				}
				return false;
			}
			default:
				return false;
		}
	}

	if(dynamic_cast<TQSpinWidget*>(obj)) {
		
		switch(ev->type()) {
			case TQEvent::Paint: {
				
				TQSpinWidget* sw = static_cast<TQSpinWidget*>(obj);
				TQPixmap buffer(sw->size());
				TQPainter p(&buffer);
				
				if(sw->parentWidget() && sw->parentWidget()->parentWidget() && sw->parentWidget()->parentWidget()->backgroundPixmap()) {
					TQPoint point = sw->backgroundOffset();
					p.drawTiledPixmap( 0, 0, sw->width(), sw->height(),
							*sw->parentWidget()->parentWidget()->backgroundPixmap(), point.x(), point.y() );
				}
				
				
				
				///////
				TQStyle::SFlags flags = TQStyle::Style_Default;
				if (sw->isEnabled())
					flags |= TQStyle::Style_Enabled;
				if (sw->hasFocus() || sw->focusProxy() && sw->focusProxy()->hasFocus())
					flags |= TQStyle::Style_HasFocus;
				if(spinWidgetDown && sw->hasMouse())
					flags |= TQStyle::Style_Down;
				TQRect fr = TQStyle::visualRect(querySubControlMetrics( TQStyle::CC_SpinWidget, ceData, elementFlags, TQStyle::SC_SpinWidgetFrame, TQStyleOption::Default, sw ), sw );
				drawComplexControl( TQStyle::CC_SpinWidget, &p, ceData, elementFlags, sw->rect(), sw->colorGroup(), flags, (uint)TQStyle::SC_All, TQStyle::SC_None, TQStyleOption::Default, sw );
				p.end();
				p.begin(sw);
				p.drawPixmap(0,0,buffer);
				return true;
			}
			case TQEvent::MouseButtonRelease:
			case TQEvent::MouseButtonPress:
			case TQEvent::MouseButtonDblClick: {
				TQSpinWidget* sw = static_cast<TQSpinWidget*>(obj);
				TQPainter p(sw);
				
				TQStyle::SFlags flags = TQStyle::Style_Default;
				if (sw->isEnabled())
					flags |= TQStyle::Style_Enabled;
				if (sw->hasFocus() || sw->focusProxy() && sw->focusProxy()->hasFocus())
					flags |= TQStyle::Style_HasFocus;
				if(ev->type() != TQEvent::MouseButtonRelease && dynamic_cast<TQSpinBox*>(sw->parentWidget())) {
					TQSpinBox* sb = dynamic_cast<TQSpinBox*>(sw->parentWidget());
					TQMouseEvent* e = (TQMouseEvent*)ev;
					
					if(sb->downRect().contains(e->pos()) && sb->value() != sb->minValue()) {
						flags |= TQStyle::Style_Down;
						spinWidgetDown = true;
					}
					if(sb->upRect().contains(e->pos()) && sb->value() != sb->maxValue()) {
						flags |= TQStyle::Style_Down;
						spinWidgetDown = true;
					}
					if(spinWidgetDown) {
						if(sw->paletteBackgroundPixmap())
							sw->erase();
						drawComplexControl( TQStyle::CC_SpinWidget, &p, ceData, elementFlags, sw->rect(), sw->colorGroup(), flags, (uint)TQStyle::SC_All, TQStyle::SC_None, TQStyleOption::Default, sw);
					}
					return false;
					
				}
				else
					spinWidgetDown = false;
				
				if(sw->paletteBackgroundPixmap())
					sw->erase();
				drawComplexControl( TQStyle::CC_SpinWidget, &p, ceData, elementFlags, sw->rect(), sw->colorGroup(), flags, (uint)TQStyle::SC_All, TQStyle::SC_None, TQStyleOption::Default, sw);
				return false;
			}
			case TQEvent::Enter: {
				TQPushButton* btn = static_cast<TQPushButton*>(obj);
				if(!btn->isEnabled())
					return false;
				hoverWidget = btn;
				btn->repaint(btn->paletteBackgroundPixmap());
				return false;
			}
			case TQEvent::Leave: {
				spinWidgetDown = false;
				TQPushButton* btn = static_cast<TQPushButton*>(obj);
				if(!btn->isEnabled())
					return false;
				hoverWidget = 0;
				btn->repaint(btn->paletteBackgroundPixmap());
				return false;
			}
			case TQEvent::ApplicationPaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Application);
				return true;
			case TQEvent::ParentPaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Parent);
				return true;
			case TQEvent::PaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Parent);
				return true;
			default:
				break;
		}
		return false;
	}

	
	if (dynamic_cast<TQTabBar*>(obj)) {
		
		switch(ev->type()) {
			case TQEvent::Wheel: {
				TQWheelEvent* e = (TQWheelEvent*)ev;
				TQTabWidget* tw = dynamic_cast<TQTabWidget*>(obj->parent());
				if(!tw)
					return false;
				
				int current = tw->currentPageIndex();
				int count = tw->count();
				
				if(count < 2)
					return false;
				
				current = e->delta() > 0 ? current - 1 : current + 1;
				
				if(current > count - 1)
					current = 0;
				else if(current < 0)
					current = count - 1;
				if(tw->page(current)->isEnabled())
					tw->setCurrentPage(current );
				return true;
			}
			case TQEvent::ApplicationPaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Application);
				return true;
			case TQEvent::ParentPaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Parent);
				return true;
			case TQEvent::PaletteChange:
				setDominoButtonPalette(dynamic_cast<TQWidget*>(obj), Palette_Widget);
				return true;
			default:
				return false;
		}
	}
	
	if (dynamic_cast<TQTabWidget*>(obj)) {
		
		TQTabWidget* tw = dynamic_cast<TQTabWidget*>(obj);
		if(tw->isA("KonqFrameTabs")) {
			
			TQColorGroup cg = tqApp->palette().active();
			switch (ev->type()) {
				case TQEvent::Paint: {
					TQRect r = tw->rect();
					int top, height;
					if(tw->tabPosition() == TQTabWidget::Top) {
						top = r.top();
						height =  r.height()-tw->currentPage()->height();
					}
					else {
						top = r.top()+tw->currentPage()->height();
						height = r.height();
					}
					
					TQPainter p(tw);
					p.setPen(cg.background());
					p.drawLine(r.left(), top, r.width(), top);
					
					p.setPen(cg.background().dark(120));
					p.drawLine(r.left(), top+1, r.width(), top+1);
					
					p.setPen(cg.background().dark(konqTabBarContrast+20));
					p.drawLine(r.left(), top+2, r.width(), top+2);
					return true;
				}
				case TQEvent::Show:
				case TQEvent::PaletteChange:
				case TQEvent::ApplicationPaletteChange: {
					if(tw->eraseColor() != cg.background().dark(konqTabBarContrast))
						tw->setEraseColor(cg.background().dark(konqTabBarContrast));
					return true;
				}
				default:
					return false;
			}
		}
		else if(ev->type() == TQEvent::Wheel) {
			if(!tw)
				return false;
			
			TQRect r = tw->rect();
			TQRect re  = ((DominoTQTabWidget*)tw)->tabBar()->rect();
			int top;
			if(tw->tabPosition() == TQTabWidget::Top) {
				top = r.top();
			}
			else {
				top = r.top() + tw->height()-re.height() - 2;
			}
			
			TQWheelEvent* e = (TQWheelEvent*)ev;
			if(TQRect(re.x(), top, r.width(), re.height()).contains(e->pos())) {
				int current = tw->currentPageIndex();
				int count = tw->count();
				if(count < 2)
					return false;
				
				current = e->delta() > 0 ? current - 1 : current + 1;
				
				if(current > count - 1)
					current = 0;
				else if(current < 0)
					current = count - 1;
				if(tw->page(current)->isEnabled())
					tw->setCurrentPage(current);
				return true;
			}
		}
		if(ev->type() == TQEvent::LayoutHint) {
			if(!tw)
				return false;
			TQWidget* w;
			if((w = tw->cornerWidget(TQt::TopRight))) {
				if(!w->width() != 25 || w->height() != 23)
					w->setFixedSize(25, 23);
			}
			if((w = tw->cornerWidget(TQt::TopLeft))) {
				if(!w->width() != 25 || w->height() != 23)
					w->setFixedSize(25, 23);
			}
			if((w = tw->cornerWidget(TQt::BottomRight))) {
				if(!w->width() != 25 || w->height() != 23)
					w->setFixedSize(25, 23);
			}
			if((w = tw->cornerWidget(TQt::BottomLeft))) {
				if(!w->width() != 25 || w->height() != 23)
					w->setFixedSize(25, 23);
			}
			
			return false;
		}
		return false;
 	}
	if(::tqt_cast<TDEToolBarButton*>(obj)) {
		switch(ev->type()) {
			case TQEvent::Paint: {
				TDEToolBar *bar = dynamic_cast<TDEToolBar*>(obj->parent());
				if(!bar) return false;  // KMyMoney2
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				int index = bar->itemIndex(btn->id());
				
				
				if(_toolBtnAsBtn && sideRepaint == false) {
					sideRepaint = true;
					TDEToolBarButton* sideBtn;
					if((sideBtn = bar->getButton(bar->idAt(index-1)))) {
						sideBtn->repaint(false);
					}
					if((sideBtn = bar->getButton(bar->idAt(index+1)))) {
						sideBtn->repaint(false);
					}
					sideRepaint = false;
				}
				
				
				SFlags flags = TQStyle::Style_Default;
				SCFlags active = TQStyle::SC_None;
				if(btn->isOn()) flags |= TQStyle::Style_On;
				if (btn->isDown()) {
					flags  |= TQStyle::Style_Down;
					active |= TQStyle::SC_ToolButton;
				}
				if (btn->isEnabled())  flags |= TQStyle::Style_Enabled;
				if (btn->isEnabled() && btn->hasMouse())    flags |= TQStyle::Style_Raised;
				if (btn->hasFocus())   flags |= TQStyle::Style_HasFocus;
				//SCFlags controls,
				
				TQPainter p(btn);
				
				if(btn->isDown()/* || btn->isOn()*/)
					buttonContour->setState(Contour_Pressed);
				else if(btn == hoverWidget && btn->isEnabled())
					buttonContour->setState(Contour_MouseOver);
				
				drawComplexControl(TQStyle::CC_ToolButton, &p, ceData, elementFlags, btn->rect(), btn->colorGroup(), flags, TQStyle::SC_ToolButton, active, TQStyleOption(), btn);
				buttonContour->reset();
				return true;
			}
			case TQEvent::MouseButtonPress: {
				if(((TQMouseEvent*)ev)->button() == TQt::RightButton)
					return false;
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				btn->setUpdatesEnabled(false);
				if(!btn->isOn()) btn->setOn(true);
				btn->setUpdatesEnabled(true);
				hoverWidget = 0;
				return false;
			}
			case TQEvent::MouseButtonRelease: {
				if(((TQMouseEvent*)ev)->button() == TQt::RightButton)
					return false;
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				btn->setUpdatesEnabled(false);
				if(btn->isOn())  btn->setOn(false);
				btn->setUpdatesEnabled(true);
				if(btn->hasMouse())
					hoverWidget = btn;
				return false;
			}
			case TQEvent::MouseButtonDblClick: {
				if(((TQMouseEvent*)ev)->button() == TQt::RightButton)
					return false;
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				if(!btn->isOn()) btn->setOn(true);
				hoverWidget = 0;
				return false;
			}
			case TQEvent::Enter: {
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				if(btn->isEnabled()) {
					hoverWidget = btn;
					btn->repaint(false);
				}
				return false;
			}
			case TQEvent::Leave: {
				TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
				if(btn == hoverWidget) {
					hoverWidget = 0;
					btn->repaint(false);
				}
				return false;
			}
			case TQEvent::Move: {
				if(_toolBtnAsBtn) {
					TDEToolBarButton* btn = dynamic_cast<TDEToolBarButton*>(obj);
					btn->repaint(false);
				}
				return false;
			}
			case TQEvent::ApplicationPaletteChange: {
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Application);
				return true;
			}
			default:
				return false;
		}
	}

	if(dynamic_cast<TQRadioButton*>(obj) && dynamic_cast<TQRadioButton*>(obj)->paletteBackgroundPixmap()) {
		if (ev->type() == TQEvent::Paint) {
			TQRadioButton* rb = static_cast<TQRadioButton*>(obj);
			
			rb->removeEventFilter(this);
			TQApplication::sendEvent(rb, (TQPaintEvent*)ev);
			rb->installEventFilter(this);
			
			TQStyle::SFlags flags = TQStyle::Style_Default;
			if ( rb->isEnabled() )
				flags |= TQStyle::Style_Enabled;
			if ( rb->hasFocus() )
				flags |= TQStyle::Style_HasFocus;
			if ( rb->isDown() )
				flags |= TQStyle::Style_Down;
			if ( rb->hasMouse() )
				flags |= TQStyle::Style_MouseOver;
			if ( rb->state() == TQButton::On )
				flags |= TQStyle::Style_On;
			else if ( rb->state() == TQButton::Off )
				flags |= TQStyle::Style_Off;
			
			TQPainter p(rb);
			drawControl(CE_RadioButton, &p, ceData, elementFlags, TQRect(0,0,17,17), rb->palette().active(), flags, TQStyleOption::Default, rb);
			return true;
		}
		if (ev->type() == TQEvent::Show && !strcmp(obj->name(), "__tdehtml")) {
			TQRadioButton* rb = static_cast<TQRadioButton*>(obj);
			TQBitmap bm(rb->size());
			bm.fill(color0);
			rb->setMask(bm);
		}
		return false;
	}
	
	if (obj->isA("KonqCheckBox")) {
		
		if (ev->type() == TQEvent::Show || ev->type() == TQEvent::ApplicationPaletteChange) { // at least doesn't flicker in the unchecked state ;-)
			TQButton* btn = dynamic_cast<TQButton*>(obj);
			TQPixmap pix(btn->size());
			pix.fill(tqApp->palette().active().background());
			TQPainter p(&pix);
			drawControl( CE_CheckBox, &p, ceData, elementFlags, TQRect(0,0,18,19), tqApp->palette().active(), Style_Default|Style_Off, TQStyleOption::Default, btn);
			btn->setErasePixmap(pix);
			return true;
		}
		if (ev->type() == TQEvent::Paint) {
			TQButton* btn = dynamic_cast<TQButton*>(obj);
			btn->erase();
			SFlags flags = Style_Default;
			if ( btn->isDown() )
				flags |= Style_Down;
			if ( btn->state() == TQButton::On )
				flags |= Style_On;
			else if ( btn->state() == TQButton::Off )
				flags |= Style_Off;
			if ( btn->isEnabled() )
				flags |= Style_Enabled;
			TQPainter p(btn);
			drawPrimitive(PE_CheckMark, &p, ceData, elementFlags, TQRect(0,0,16,17), tqApp->palette().active(), flags);
			return true;
		}
		return false;
	}
	
	if(dynamic_cast<TQCheckBox*>(obj)) {
		if (ev->type() == TQEvent::Paint) {
			TQCheckBox* cb = static_cast<TQCheckBox*>(obj);
			
			bool tdehtmlWidget = !strcmp(obj->name(), "__tdehtml");
			if(tdehtmlWidget || cb->paletteBackgroundPixmap()) {
				if(tdehtmlWidget) {
					// this prevents the checkbox been erased before the rest of the html page
					TQBitmap bm(cb->size());
					bm.fill(color0);
					cb->setMask(bm);
				}
				else {
					// draws a masked checkbox
					cb->removeEventFilter(this);
					TQApplication::sendEvent(cb, (TQPaintEvent*)ev);
					cb->installEventFilter(this);
				}
				// draws the missing alpha part
				TQStyle::SFlags flags = TQStyle::Style_Default;
				if ( cb->isEnabled() )
					flags |= TQStyle::Style_Enabled;
				if ( cb->hasFocus() )
					flags |= TQStyle::Style_HasFocus;
				if ( cb->isDown() )
					flags |= TQStyle::Style_Down;
				if ( cb->hasMouse() )
					flags |= TQStyle::Style_MouseOver;
				if ( cb->state() == TQButton::On )
					flags |= TQStyle::Style_On;
				else if ( cb->state() == TQButton::Off )
					flags |= TQStyle::Style_Off;
				else if ( cb->state() == TQButton::NoChange )
					flags |= TQStyle::Style_NoChange;
				
				TQPainter p(cb);
				drawControl(CE_CheckBox, &p, ceData, elementFlags, TQRect(0,0,18,19), cb->palette().active(), flags, TQStyleOption::Default, cb);
				return true;
			}
			return false;
		}
		return false;
	}
	
	if(dynamic_cast<TQPopupMenu*>(obj)) {
		switch(ev->type()) {
			case TQEvent::Resize:
			case TQEvent::Show: {
				TQWidget* w = static_cast<TQWidget*>(obj);
				TQRect r = w->rect();
				TQRegion mask(r.x()+2, r.y(), r.width()-4, r.height());
				mask += TQRegion(r.x(), r.y()+2, r.width(), r.height()-4);
				mask += TQRegion(r.x()+1, r.y()+1, r.width()-2, r.height()-2);
				w->setMask(mask);
				return false;
			}
			case TQEvent::Hide:
				static_cast<TQWidget*>(obj)->setBackgroundMode(NoBackground);
				return false;
			default:
				return false;
		}
	}
	
	
	if(dynamic_cast<TQPushButton*>(obj) && !obj->isA("KDockButton_Private") || dynamic_cast<TQToolButton*>(obj) ) {
		TQWidget* w = static_cast<TQWidget*>(obj);

		switch(ev->type()) {
			case TQEvent::Enter: {
				if(!w->isEnabled()) return false;
				hoverWidget = w;
				w->repaint(false);
				return false;
			}
			case TQEvent::Leave: {
				if(!w->isEnabled()) return false;
				hoverWidget = 0;
				w->repaint(false);
				return false;
			}
			case TQEvent::MouseButtonPress: {
				if(dynamic_cast<TQToolButton*>(obj)) {
					TQMouseEvent* e = (TQMouseEvent*)ev;
					if(e->button() == TQt::LeftButton)
						popupMousePressPos = e->pos();
				}
				return false;
			}
			case TQEvent::MouseMove: {
				TQMouseEvent* e = (TQMouseEvent*)ev;
				if(dynamic_cast<TQToolButton*>(obj) && popupTimer->isActive() && ((e->pos()-popupMousePressPos).manhattanLength() > 4 /*TDEGlobalSettings::dndEventDelay()*/))
					popupToolMenu();
				return false;
			}
			case TQEvent::ParentPaletteChange: {
				if(obj->isA("TQToolButton")) {
					
					if(w->parentWidget() && !tdehtmlWidgets.contains(w)) {
						w->setUpdatesEnabled(false);
						if(w->parentWidget()->paletteBackgroundPixmap()) {
							w->setBackgroundOrigin(setPixmapOrigin(w->parentWidget()->backgroundOrigin()));
							setDominoButtonPalette(w, Palette_Parent);
						}
						else {
							w->setBackgroundMode(PaletteBackground);
							w->setBackgroundOrigin(TQWidget::WidgetOrigin);
							setDominoButtonPalette(w, Palette_Parent);
						}
						w->setUpdatesEnabled(true);
						w->repaint(true);
					}
					return true;
				}
				else
					setDominoButtonPalette(w, Palette_Parent);
				return true;
				break;
			}
			case TQEvent::PaletteChange: {
				setDominoButtonPalette(w, Palette_Widget);
				return true;
			}
			case TQEvent::ApplicationPaletteChange: {
				return true;
			}
			default:
				return false;
		}
	}
	if(obj->isA("TQDockWindowHandle") || obj->isA("AppletHandleDrag"))  {
		if ((ev->type() == TQEvent::Enter) &&  static_cast<TQWidget*>(obj)->isEnabled()) {
			TQWidget* w = static_cast<TQWidget*>(obj);
			hoverWidget = w;
			w->repaint(true);
			return false;
		}
		if (ev->type() == TQEvent::Leave && static_cast<TQWidget*>(obj) == hoverWidget) {
			hoverWidget = 0;
			static_cast<TQWidget*>(obj)->repaint(true);
			return false;
		}
		return false;
	}
	
	if(obj->isA("KDockButton_Private")) {
		if (ev->type() == TQEvent::Paint) {
			TQPixmap* btnPix = 0;
			TQButton* btn = static_cast<TQButton*>(obj);
			if(!(btnPix = TQPixmapCache::find(TQString::number(btn->paletteBackgroundColor().pixel(), 16)+btn->name()))) {
				TQPixmap* tmpPix = new TQPixmap(qembed_findImage(btn->name()));
				if(!tmpPix)
					return false;
				btnPix = new TQPixmap(12, 24);
				btnPix->fill(btn->paletteBackgroundColor());
				bitBlt(btnPix, 0, 0, tmpPix);
				TQPixmapCache::insert(TQString::number(btn->paletteBackgroundColor().pixel(), 16)+btn->name(), btnPix);
			}
			
			if(btn->isOn() || btn->isDown())
				bitBlt(btn, 0, 1, btnPix, 0, 12, 12, 12);
			else
				bitBlt(btn, 0, 1, btnPix, 0, 0, 12, 12);
			return true;
		}
		return false;
	}
	
	if(dynamic_cast<TDEPopupTitle*>(obj)) {
		
		switch(ev->type()) {
			case TQEvent::Paint: {
				
				TDEPopupTitle* pt = static_cast<TDEPopupTitle*>(obj);
				TQRect r = pt->rect();
				TQPainter p(pt);
				
				if(pt->parentWidget() && pt->parentWidget()->paletteBackgroundPixmap()) {
					TQPoint point = TQPoint(pt->geometry().x(), pt->geometry().y());
					p.drawTiledPixmap( 0, 0, pt->width(), pt->height(),
							*pt->parentWidget()->backgroundPixmap(),
							point.x(), point.y() );
				}
				
				TQFont f = p.font();
				f.setBold(true);
				p.setFont(f);
				
				if(!pt->icon().isNull()) {
					int titleWidth = p.fontMetrics().width(pt->title());
					p.drawPixmap((r.width()-titleWidth)/2-4-pt->icon().width(), (r.height()-pt->icon().height())/2, pt->icon());
				}
				if (!pt->title().isNull()) {
					p.setPen(alphaBlendColors(_popupMenuColor, pt->paletteForegroundColor(), 150));
					p.drawText(0, 0, r.width(), r.height(), AlignCenter | SingleLine, pt->title());
				}
				return true;
			}
			default:
				return false;
		}
	}
	if(dynamic_cast<TQButton*>(obj) && obj->parent() && obj->parent()->isA("TQToolBox")) {
		TQWidget* w = dynamic_cast<TQWidget*>(obj);
		if(!w->isEnabled())
			return false;
		if(ev->type() == TQEvent::Enter) {
			hoveredToolBoxTab = true;
			w->repaint(false);
			return false;
		}
		if(ev->type() == TQEvent::Leave) {
			hoveredToolBoxTab = false;
			w->repaint(false);
			return false;
		}
		if(ev->type() == TQEvent::Move) {
			hoveredToolBoxTab = false;
			return false;
		}
		return false;
	}
	if(dynamic_cast<TQHeader*>(obj)) {
		switch(ev->type()) {
			case TQEvent::ApplicationPaletteChange:
				static_cast<TQHeader*>(obj)->setBackgroundMode(TQt::PaletteBackground);
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Application);
				return true;
			case TQEvent::ParentPaletteChange:
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Parent);
				return true;
			case TQEvent::PaletteChange:
				static_cast<TQHeader*>(obj)->setBackgroundMode(TQt::PaletteBackground);
				setDominoButtonPalette(static_cast<TQWidget*>(obj), Palette_Widget);
				return true;
			default:
				return false;
		}
		return false;
	}
	
	if(dynamic_cast<TQDockWindow*>(obj)) {
		switch(ev->type()) {
			case TQEvent::LayoutHint: {
				TQDockWindow* dw = dynamic_cast<TQDockWindow*>(obj);
				if(!dw->widget())
					return false;
				if(!dw->area()) {
					dw->setFrameStyle(TQFrame::Panel|TQFrame::Sunken);
					dw->setLineWidth(1);
					TQRect r = dw->rect();
					TQRegion mask(r);
					mask -= TQRegion(0, 0, 1, 1);
					mask -= TQRegion(r.width()-1, 0, 1, 1);
					mask -= TQRegion(0, r.height()-1, 1, 1);
					mask -= TQRegion(r.width()-1, r.height()-1, 1, 1);
					dw->setMask(mask);
				}
				else if(dw->frameStyle() == TQFrame::Panel|TQFrame::Sunken) {
					dw->setFrameStyle(TQFrame::StyledPanel|TQFrame::Sunken);
					dw->setLineWidth(2);
					dw->clearMask();
				}
			}
			default:
				break;
				
		}
	}
	else if(obj->isA("TQWorkspaceChild")) {
		switch(ev->type()) {
			case TQEvent::Show:
			case TQEvent::Resize: {
				TQWidget* w = static_cast<TQWidget*>(obj);
				TQRect r = w->rect();
				TQRegion mask(r);
				mask -= TQRegion(0, 0, 1, 1);
				mask -= TQRegion(r.width()-1, 0, 1, 1);
				mask -= TQRegion(0, r.height()-1, 1, 1);
				mask -= TQRegion(r.width()-1, r.height()-1, 1, 1);
				w->setMask(mask);
			}
			default:
				break;
		}
	}
		
	if(obj->isA("TQDockWindowResizeHandle")) {
		if(ev->type() == TQEvent::PaletteChange)
			static_cast<TQWidget*>(obj)->setBackgroundMode(TQt::PaletteBackground);
		return false;
	}
		
	if(obj->isA("TQWhatsThat")) { // TQWhatsThis
		
		if (ev->type() == TQEvent::Show) {
			TQWidget* w = dynamic_cast<TQWidget*>(obj);
			w->setBackgroundMode(TQt::NoBackground);
			TQRect r = w->rect();
			TQRegion mask(r.x()+3, r.y(), r.width()-6, r.height());
			mask += TQRegion(r.x()+2, r.y()+1, r.width()-4, r.height()-2);
			mask += TQRegion(r.x()+1, r.y()+2, r.width()-2, r.height()-4);
			mask += TQRegion(r.x(), r.y()+3, r.width(), r.height()-6);
			w->setMask(mask);
			return true;
		}
		
		if (ev->type() == TQEvent::Paint) {
			DominoTQWhatsThat* dwt = (DominoTQWhatsThat*)obj;
			TQString text = dwt->text;
			TQRect r = dwt->rect();
			
			int x = r.x();
			int y = r.y();
			int w = r.width();
			int h = r.height();
			
			TQRegion mask(x+1, y+4, w-2, h-8);
			mask += TQRegion(x+2, y+3, w-4, h-6);
			mask += TQRegion(x+3, y+2, w-6, h-4);
			mask += TQRegion(x+4, y+1, w-8, h-2);
			
			TQPainter p(dwt);
			p.setClipRegion(mask);
			renderGradient(&p, TQRect(r.left(), r.top(), r.width(), r.height()), _toolTipColor.light(110), _toolTipColor.dark(105), true);
			p.setClipping(false);
			
			TQColor tabContour2 = tqApp->palette().active().background().dark(150);
			
			p.save();
			p.setPen(tabContour2);
			p.drawLine(x+7,y, w-8,y); // top
			p.drawLine(x+7,h-1, w-8,h-1); // bottom
			p.drawLine(x,y+7, x,h-8); // left
			p.drawLine(w-1,y+7, w-1,h-8); // right
			p.restore();
			
			bitBlt(dwt, x, y, border1, 0, 0, 7, 7);
			bitBlt(dwt, w-7, y, border1, 7, 0, 7, 7);
			bitBlt(dwt, x, h-7, border1, 0, 7, 7, 7);
			bitBlt(dwt, w-7, h-7, border1, 7, 7, 7, 7);
			
			r.addCoords( 12, 8, -12, -8 );
			
			if(TQStyleSheet::mightBeRichText( text )) {
				TQSimpleRichText* srt = new TQSimpleRichText( text, dwt->font());
				srt->draw(&p, r.x(), r.y(), r, tqApp->palette().active(), 0);
			}
			else {
				r.addCoords( 2, 3, 0, 0 );
				p.drawText( r, AlignAuto + AlignTop + WordBreak + ExpandTabs, text );
			}
			
			return true;
		}
		return false;
	}
	
	
	if(obj->isA("KonqFileTip")) {
		
		if (ev->type() == TQEvent::Show || ev->type() == TQEvent::Paint) {
			
			TQWidget* widget = dynamic_cast<TQWidget*>(obj);
			TQRect r = widget->rect();
			
			TQPixmap pix(r.size());
			TQPainter p(&pix);
			renderGradient(&p, TQRect(r.left(), r.top(), r.width(), r.height()), _toolTipColor.light(110), _toolTipColor.dark(105), true);
			
			if(ev->type() == TQEvent::Show) {
				dynamic_cast<TQFrame*>(widget)->setFrameStyle(TQFrame::NoFrame);
				widget->setBackgroundMode(TQt::NoBackground);
				
				TQRegion mask(r.x()+3, r.y(), r.width()-6, r.height());
				mask += TQRegion(r.x()+2, r.y()+1, r.width()-4, r.height()-2);
				mask += TQRegion(r.x()+1, r.y()+2, r.width()-2, r.height()-4);
				mask += TQRegion(r.x(), r.y()+3, r.width(), r.height()-6);
				dynamic_cast<TQFrame*>(widget)->setMask(mask);
				
				TQObjectList *list = const_cast<TQObjectList *>(widget->children());
				TQObjectListIt it( *list );
				TQObject * o;
				while ( (o = it.current()) != 0 ) {
					++it;
					if(dynamic_cast<TQLabel*>(o)) {
						TQLabel* l = dynamic_cast<TQLabel*>(o);
						l->setBackgroundOrigin(TQWidget::ParentOrigin);
						l->setPaletteBackgroundPixmap(pix);
					}
				}
			}
			p.end();
			
			if(ev->type() == TQEvent::Paint) {
				
				int x = r.x();
				int y = r.y();
				int w = r.width();
				int h = r.height();
				
				TQRegion mask(x+1, y+4, w-2, h-8);
				mask += TQRegion(x+2, y+3, w-4, h-6);
				mask += TQRegion(x+3, y+2, w-6, h-4);
				mask += TQRegion(x+4, y+1, w-8, h-2);
				
				p.begin(widget);
				p.setClipRegion(mask);
				p.drawPixmap(0, 0, pix);
				p.setClipping(false);
				
				TQColor tabContour2 = tqApp->palette().active().background().dark(150);
				p.setPen(tabContour2);
				p.drawLine(x+7,y, w-8,y); // top
				p.drawLine(x+7,h-1, w-8,h-1); // bottom
				p.drawLine(x,y+7, x,h-8); // left
				p.drawLine(w-1,y+7, w-1,h-8); // right
				
				bitBlt(widget, x, y, border1, 0, 0, 7, 7);
				bitBlt(widget, w-7, y, border1, 7, 0, 7, 7);
				bitBlt(widget, x, h-7, border1, 0, 7, 7, 7);
				bitBlt(widget, w-7, h-7, border1, 7, 7, 7, 7);
				
			}
			
			return true;
		}
		return false;
	}
	
	if(obj->isA("TQTipLabel")) {
		
		if (ev->type() == TQEvent::Show) {
			TQLabel* l = dynamic_cast<TQLabel*>(obj);
			l->resize( l->width()+2, l->height()+2);
			l->setBackgroundMode(TQt::NoBackground);
			int x, y, w, h;
			l->rect().rect(&x, &y, &w, &h);
			
			TQRegion mask(x, y+3, w, h-6);
			mask += TQRegion(x+1, y+2, w-2, h-4);
			mask += TQRegion(x+2, y+1, w-4, h-2);
			mask += TQRegion(x+3, y, w-6, h);
			l->setMask(mask);
			return true;
		}
		if (ev->type() == TQEvent::Paint) {
			
			TQLabel* label = dynamic_cast<TQLabel*>(obj);
			TQRect r = label->rect();
			
			int x = r.x();
			int y = r.y();
			int w = r.width();
			int h = r.height();
			
			// one pixel smaler as the mask
			TQRegion mask(x+1, y+4, w-2, h-8);
			mask += TQRegion(x+2, y+3, w-4, h-6);
			mask += TQRegion(x+3, y+2, w-6, h-4);
			mask += TQRegion(x+4, y+1, w-8, h-2);
			
			TQPainter p(label);
			p.setClipRegion(mask);
			
			renderGradient(&p, TQRect(r.left(), r.top(), r.width(), r.height()), _toolTipColor.light(110), _toolTipColor.dark(105), true);
			p.setClipping(false);
			
			TQColor tabContour2 = tqApp->palette().active().background().dark(150);

			p.save();
			p.setPen(tabContour2);
			p.drawLine(x+7,y, w-8,y); // top
			p.drawLine(x+7,h-1, w-8,h-1); // bottom
			p.drawLine(x,y+7, x,h-8); // left
			p.drawLine(w-1,y+7, w-1,h-8); // right
			p.restore();

			bitBlt(label, x, y, border1, 0, 0, 7, 7);
			bitBlt(label, w-7, y, border1, 7, 0, 7, 7);
			bitBlt(label, x, h-7, border1, 0, 7, 7, 7);
			bitBlt(label, w-7, h-7, border1, 7, 7, 7, 7);
			
			if(TQStyleSheet::mightBeRichText(label->text()))
			{
				TQSimpleRichText* srt = new TQSimpleRichText(label->text(), label->font());
				srt->setWidth(r.width()-5);
				srt->draw(&p, r.x()+4, r.y(), r, tqApp->palette().active(), 0);
				delete srt;
			}
			else
			{
				r.addCoords(2, 3, 0, 0);
				p.drawText(r, AlignAuto + AlignTop, label->text());
			}
		}
		return true;
	}
	if(obj->isA("TQViewportWidget") && dynamic_cast<TQTextEdit*>(obj->parent())) {
		switch(ev->type()) {
			case TQEvent::MouseButtonPress:
			case 6/*TQEvent::KeyPress*/: {
				TQTextEdit* te = dynamic_cast<TQTextEdit*>(obj->parent());
				if(te->isEnabled() && !te->isReadOnly())
					static_cast<TQWidget*>(obj)->setCursor(TQt::blankCursor);
				return false;
			}
			default:
				return false;
		}
	}

	if (dynamic_cast<TQFrame*>(obj)) { // at last because other widgets may include a frame.
		
		TQFrame* f = dynamic_cast<TQFrame*>(obj);
		const TQRect r = f->rect();
		
		if (ev->type() == TQEvent::Paint) {
			
			switch(f->frameShape()){
				case TQFrame::HLine: {
					TQPainter p(f);
// 					p.setPen(f->paletteBackgroundColor().dark(120));
					p.setPen(alphaBlendColors(f->paletteForegroundColor(), f->paletteBackgroundColor(), 40));
					p.drawLine(0,0,f->frameRect().width(),0);
					return true;
				}
				case TQFrame::VLine: {
					TQPainter p(f);
					p.setPen(alphaBlendColors(f->paletteForegroundColor(), f->paletteBackgroundColor(), 40));
					p.drawLine(0,0,0,f->frameRect().height());
					return true;
				}
				case TQFrame::WinPanel:
				case TQFrame::Panel: {
					if(f->parentWidget() && f->parentWidget()->isA("KDockSplitter")) {
						
						if(!f->erasePixmap()) {
							bool horizontal = (r.width() > r.height());
							TQPixmap pix(r.size());
							TQPainter p(&pix);
							renderGradient(&p, r, lightenColor(f->paletteBackgroundColor(), 40), darkenColor(f->paletteBackgroundColor(), 30), horizontal);
							f->setErasePixmap(pix);
						}
						return true;
					}
					
					TQPainter p(f);
					TQColor frameColor;
					if(f->frameShape() == TQFrame::Panel && f->frameShadow() == TQFrame::Plain) // used as a selection in kspread
						frameColor = f->paletteBackgroundColor().dark(160);
					else if(dynamic_cast<TQListBox*>(obj) && dynamic_cast<TQComboBox*>(obj->parent()))
						frameColor = f->paletteBackgroundColor().dark(190);
					else
						frameColor = f->paletteBackgroundColor().dark(120);
					
						
					p.setPen(frameColor);
					p.drawRect(f->rect());
					
					TQPaintEvent* e = (TQPaintEvent*)ev;
					p.setClipRegion(e->region().intersect(f->contentsRect()));
					DominoTQFrame* df = (DominoTQFrame*)f;
					df->drawContents(&p);
					
					DominoTQWidget* dw = (DominoTQWidget*)f;
					TQPaintEvent* event = new TQPaintEvent(e->region().intersect(f->contentsRect()));
					dw->paintEvent(event);
					return true;
				}
				case TQFrame::ToolBarPanel: {
					if(f->isA("KonqSidebarTree")) {
						TQPainter p(f);
						p.setPen(tqApp->palette().active().background().dark(120));
						p.drawRect(f->rect());
						return true;
					}
					return false;
				}
				case TQFrame::Box: {
					if(f->parentWidget() && !strcmp(f->parentWidget()->name(), "KonqFrame")) {
						TQPainter p(f);
						p.fillRect(r.width()-16, r.height()-16, 15, 15, tqApp->palette().active().background()); // 15x15 scrollview cornerwidget gap
						return true;
					}
					else if(konquerorMode && f->isA("TDEHTMLView")) {
						TQPainter p(f);
						p.setPen(tqApp->palette().active().background().dark(120));
						p.drawRect(f->rect());
						return true;
					}
				}
				default:
					return false;
			}
		}
		
		if (ev->type() == TQEvent::Show || ev->type() == TQEvent::ApplicationPaletteChange) { // ApplicationPaletteChange for style changes
			
			switch(f->frameShape()){
				case TQFrame::TabWidgetPanel:
					if(ev->type() == TQEvent::ApplicationPaletteChange) {
						
						if(f->lineWidth() != 4)
							f->setLineWidth(4);
						if(f->frameRect() != TQRect(0, 0, f->width(), f->height()-1))
							f->setFrameRect(TQRect(0, 0, f->width(), f->height()-1));
						if(f->margin() != 0)
							f->setMargin(0);
						
						TQWidget* w = f->parentWidget();
						for(int i=0; i<3; i++) { // the third parentcheck is for the tabWidget on kcm tdehtml_plugins
							if(!w) break;
							if(dynamic_cast<TQGroupBox*>(w)) {
								f->setPaletteBackgroundColor(tqApp->palette().active().background());
								break;
							}
							w = w->parentWidget();
						}
					}
					return true;
				case TQFrame::Box:
					if(f->parentWidget() && !strcmp(f->parentWidget()->name(), "KonqFrame")) {
						f->setEraseColor(tqApp->palette().active().background().dark(120));
						f->erase();
						return true;
					}
				case TQFrame::Panel:
					if(ev->type() == TQEvent::ApplicationPaletteChange && f->parentWidget() && f->parentWidget()->isA("KDockSplitter")) {
						f->setBackgroundMode(TQt::PaletteBackground);
						return true;
					}
				default:
					return false;
			}
			return false;
		}
		if(ev->type() == TQEvent::LayoutHint && f->frameShape() == TQFrame::TabWidgetPanel) { // don't look broken in kcm stylePreview
			if(f->lineWidth() != 4)
				f->setLineWidth(4);
			if(f->frameRect() != TQRect(0, 0, f->width(), f->height()-1))
				f->setFrameRect(TQRect(0, 0, f->width(), f->height()-1));
			if(f->margin() != 0)
				f->setMargin(0);
			
			return false;
		}
	}
	
	// nothing matched
	return false;
	
}
