/*
	Copyright (C) 2006 Michael Lentner <michaell@gmx.net>
	
	based on KDE2 Default KWin client:
	Copyright (C) 1999, 2001 Daniel Duley <mosfet@kde.org>
	Matthias Ettrich <ettrich@kde.org>
	Karol Szwed <gallium@kde.org>
	
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Library General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/

#ifndef _DOMINOCLIENT_H
#define _DOMINOCLIENT_H

#include <kcommondecoration.h>
#include <kdecorationfactory.h>
#include <tqlayout.h>

namespace Domino {

class DominoClient;
class TitleBar;

class DominoHandler: public TQObject, public KDecorationFactory
{
	public:
		DominoHandler();
		~DominoHandler();
				KDecoration* createDecoration( KDecorationBridge* b );
		bool reset( unsigned long changed );
		virtual bool supports( Ability ability );
		
		TQColor buttonContourColor;
		TQColor buttonMouseOverContourColor;
		TQColor buttonPressedContourColor;
		
		bool customButtonColor;
		TQColor buttonColor;
		bool customButtonIconColor;
		TQColor buttonIconColor;
		bool customBorderColor;
		TQColor borderColor;
		bool darkLines;
		
	private:
		unsigned long readConfig( bool update );
		void createPixmaps();
		void freePixmaps();

};


class DominoButton : public KCommonDecorationButton
{
	public:
		DominoButton(ButtonType type, DominoClient *parent, const char *name);
		~DominoButton();

		void reset(unsigned long changed);

	protected:
		void enterEvent(TQEvent *);
		void leaveEvent(TQEvent *);
		void drawButton(TQPainter *p);
		void drawButtonLabel(TQPainter*) {;}

		bool isMouseOver;
		DominoClient* client;
};


class DominoClient : public KCommonDecoration
{
	TQ_OBJECT
	public:
		DominoClient( KDecorationBridge* b, KDecorationFactory* f );
		~DominoClient();

		virtual TQString visibleName() const;
		virtual TQString defaultButtonsLeft() const;
		virtual TQString defaultButtonsRight() const;
		virtual bool decorationBehaviour(DecorationBehaviour behaviour) const;
		virtual int layoutMetric(LayoutMetric lm, bool respectWindowState = true, const KCommonDecorationButton * = 0) const;
		virtual KCommonDecorationButton *createButton(ButtonType type);
		void borders( int& left, int& right, int& top, int& bottom ) const;
		
		void init();
		void reset( unsigned long changed );
		void resize( const TQSize& s );
		void updateMask();
		
		void updateWindowShape();
		void updateCaption();
		void shadeChange();
		void activeChange();
		void iconChange();
		
		TitleBar* titleBar;
		TQWidget* borderTopLeft;
		TQWidget* borderTopRight;
		TQWidget* borderBottomLeft;
		TQWidget* borderBottomRight;
		TQWidget* borderLeft;
		TQWidget* borderRight;
		TQWidget* borderBottom;
		TQGridLayout* mainlayout;
		TQButton* menuButton;
		
		void setPixmaps();
		bool titleBarMouseOver;
		bool globalMouseTracking;
		
	public slots:
		void slotShade();
		void menuButtonDestroyed();

	protected:
		bool eventFilter(TQObject*, TQEvent*);
		void paintEvent(TQPaintEvent*);
		void resizeEvent(TQResizeEvent*);
		void showEvent(TQShowEvent*);

	private:
		
		void createLayout();
};

class TitleBar : public TQWidget
{
	public:
		TitleBar(TQWidget* parent=0, const char* name=0) : TQWidget(parent, name) {}
		void enterEvent(TQEvent * e);
		bool eventFilter(TQObject*, TQEvent*);
		DominoClient* client;
};



void renderGradient(TQPainter *painter, TQRect &rect,
	    TQColor &c1, TQColor &c2, const char* name = 0);
TQColor alphaBlendColors(const TQColor &backgroundColor, const TQColor &foregroundColor, const int alpha);
TQImage tintImage(const TQImage &img, const TQColor &tintColor);
}

#endif
