# -*- mode: makefile; coding: utf-8 -*-
# Copyright © 2002,2003 Colin Walters <walters@debian.org>
# Copyright © 2003,2012, 2014, 2016 Jonas Smedegaard <dr@jones.dk>
# Description: Builds and cleans packages which have a Makefile
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

_cdbs_scripts_path ?= /usr/lib/cdbs
_cdbs_rules_path ?= /usr/share/cdbs/1/rules
_cdbs_class_path ?= /usr/share/cdbs/1/class

ifndef _cdbs_class_makefile
_cdbs_class_makefile = 1

include $(_cdbs_rules_path)/buildcore.mk$(_cdbs_makefile_suffix)
include $(_cdbs_class_path)/tde-makefile-vars.mk$(_cdbs_makefile_suffix)

cdbs_make_flavors = $(sort $(DEB_MAKE_FLAVORS))
cdbs_make_builddir_check = $(if $(call cdbs_streq,$(DEB_BUILDDIR),$(DEB_SRCDIR)),\
	$(error DEB_MAKE_FLAVORS in use: \
		DEB_BUILDDIR must be different from DEB_SRCDIR$(comma) \
		and needs to be declared before including makefile.mk))
cdbs_make_build_stamps = $(if $(cdbs_make_flavors),\
	$(cdbs_make_builddir_check)\
	$(patsubst %,debian/stamp-makefile-build/%,\
		$(cdbs_make_flavors)),\
	debian/stamp-makefile-build)
cdbs_make_install_stamps = $(if $(cdbs_make_flavors),\
	$(cdbs_make_builddir_check)\
	$(patsubst %,debian/stamp-makefile-install/%,\
		$(cdbs_make_flavors)),\
	debian/stamp-makefile-install)
cdbs_make_check_stamps = $(if $(cdbs_make_flavors),\
	$(cdbs_make_builddir_check)\
	$(patsubst %,debian/stamp-makefile-check/%,\
		$(cdbs_make_flavors)),\
	debian/stamp-makefile-check)
cdbs_make_clean_nonstamps = $(if $(cdbs_make_flavors),\
	$(patsubst %,makefile-clean/%,$(cdbs_make_flavors)),\
	makefile-clean)
cdbs_make_curflavor = $(strip $(if $(cdbs_make_flavors),\
	$(filter-out %/,$(subst /,/ ,$@))))
cdbs_make_curbuilddir = $(strip $(if $(cdbs_make_flavors),\
	$(subst @FLAVOR@,$(cdbs_make_curflavor),$(or $(strip \
		$(DEB_MAKE_BUILDDIRSKEL_$(cdbs_make_curflavor))),$(strip \
		$(DEB_MAKE_BUILDDIRSKEL)))),\
	$(cdbs_curbuilddir)))
cdbs_make_curdestdir = $(strip $(if $(cdbs_make_flavors),\
	$(subst @FLAVOR@,$(cdbs_make_curflavor),$(or $(strip \
		$(DEB_MAKE_DESTDIRSKEL_$(cdbs_make_curflavor))),$(strip \
		$(DEB_MAKE_DESTDIRSKEL)))),\
	$(cdbs_curdestdir)))

DEB_PHONY_RULES += makefile-clean $(cdbs_make_clean_nonstamps)

pre-build::
	$(if $(cdbs_make_flavors),\
		mkdir -p \
			debian/stamp-makefile-build \
			debian/stamp-makefile-install)
	$(and $(cdbs_make_flavors),$(DEB_MAKE_CHECK_TARGET),\
		mkdir -p debian/stamp-makefile-check)

common-build-arch common-build-indep:: $(cdbs_make_build_stamps)
$(cdbs_make_build_stamps):
	+$(DEB_MAKE_INVOKE) $(DEB_MAKE_BUILD_TARGET)
	touch $@

cleanbuilddir:: makefile-clean
makefile-clean:: $(if $(cdbs_make_flavors),$(cdbs_make_clean_nonstamps))
	$(if $(cdbs_make_flavors),\
		-rmdir --ignore-fail-on-non-empty \
			debian/stamp-makefile-build \
			debian/stamp-makefile-install,\
		rm -f \
			debian/stamp-makefile-build \
			debian/stamp-makefile-install)

$(cdbs_make_clean_nonstamps)::
	$(if $(DEB_MAKE_CLEAN_TARGET),\
		+-$(DEB_MAKE_INVOKE) -k $(DEB_MAKE_CLEAN_TARGET),\
		$(call cdbs_warn,DEB_MAKE_CLEAN_TARGET unset$(comma) \
			not running clean))
	$(if $(cdbs_make_flavors),\
		rm -f \
			$(@:makefile-clean%=debian/stamp-makefile-build%) \
			$(@:makefile-clean%=debian/stamp-makefile-install%))

common-install-arch common-install-indep:: common-install-impl
common-install-impl:: $(cdbs_make_install_stamps)
$(cdbs_make_install_stamps)::
	$(if $(DEB_MAKE_INSTALL_TARGET),\
		+$(DEB_MAKE_INVOKE) $(DEB_MAKE_INSTALL_TARGET),\
		$(call cdbs_warn,DEB_MAKE_INSTALL_TARGET unset$(comma) \
			skipping default makefile.mk common-install target))
	$(if $(DEB_MAKE_INSTALL_TARGET),\
		touch $@)

ifeq (,$(filter nocheck,$(DEB_BUILD_OPTIONS)))
common-build-arch common-build-indep:: $(cdbs_make_check_stamps)
$(cdbs_make_check_stamps) : debian/stamp-makefile-check% : debian/stamp-makefile-build%
	$(if $(DEB_MAKE_CHECK_TARGET),\
		+$(DEB_MAKE_INVOKE) $(DEB_MAKE_CHECK_TARGET),\
		$(call cdbs_warn,DEB_MAKE_CHECK_TARGET unset$(comma) \
			not running checks))
	$(if $(DEB_MAKE_CHECK_TARGET),\
		touch $@)

makefile-clean::
	$(if $(DEB_MAKE_CHECK_TARGET),\
		$(if $(cdbs_make_flavors),\
			-rmdir --ignore-fail-on-non-empty \
				debian/stamp-makefile-check,\
		rm -f debian/stamp-makefile-check))

$(cdbs_make_clean_nonstamps)::
	$(if $(cdbs_make_flavors),\
		rm -f $(@:makefile-clean%=debian/stamp-makefile-check%))
endif

endif
