/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "RosegardenApplication.h"

#include "misc/Debug.h"
#include "document/ConfigGroups.h"
#include "document/RosegardenGUIDoc.h"
#include "gui/application/RosegardenDCOP.h"
#include "gui/kdeext/KTmpStatusMsg.h"
#include "RosegardenGUIApp.h"
#include <tdecmdlineargs.h>
#include <tdelocale.h>
#include <tdemainwindow.h>
#include <tdemessagebox.h>
#include <tdeprocess.h>
#include <tdeuniqueapplication.h>
#include <tqcstring.h>
#include <tqeventloop.h>
#include <tqsessionmanager.h>
#include <tqstring.h>
#include <dcopclient.h>
#include <tdeconfig.h>
#include <kstatusbar.h>


namespace Rosegarden
{

int RosegardenApplication::newInstance()
{
    TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

    if (RosegardenGUIApp::self() && args->count() &&
            RosegardenGUIApp::self()->getDocument() &&
            RosegardenGUIApp::self()->getDocument()->saveIfModified()) {
        // Check for modifications and save if necessary - if cancelled
        // then don't load the new file.
        //
        RosegardenGUIApp::self()->openFile(args->arg(0));
    }

    return TDEUniqueApplication::newInstance();
}

bool RosegardenApplication::isSequencerRegistered()
{
    if (noSequencerMode())
        return false;
    return dcopClient()->isApplicationRegistered(ROSEGARDEN_SEQUENCER_APP_NAME);
}

bool RosegardenApplication::sequencerSend(TQCString dcopCall, TQByteArray params)
{
    if (noSequencerMode())
        return false;

    return dcopClient()->send(ROSEGARDEN_SEQUENCER_APP_NAME,
                              ROSEGARDEN_SEQUENCER_IFACE_NAME,
                              dcopCall, params);
}

bool RosegardenApplication::sequencerCall(TQCString dcopCall, TQCString& replyType, TQByteArray& replyData,
        TQByteArray params, bool useEventLoop)
{
    if (noSequencerMode())
        return false;
    return dcopClient()->call(ROSEGARDEN_SEQUENCER_APP_NAME,
                              ROSEGARDEN_SEQUENCER_IFACE_NAME,
                              dcopCall, params, replyType, replyData, useEventLoop);
}

void RosegardenApplication::sfxLoadExited(TDEProcess *proc)
{
    if (!proc->normalExit()) {
        TQString configGroup = config()->group();
        config()->setGroup(SequencerOptionsConfigGroup);
        TQString soundFontPath = config()->readEntry("soundfontpath", "");
        config()->setGroup(configGroup);

        KMessageBox::error(mainWidget(),
                           i18n("Failed to load soundfont %1").arg(soundFontPath));
    } else {
        RG_DEBUG << "RosegardenApplication::sfxLoadExited() : sfxload exited normally\n";
    }

}

void RosegardenApplication::slotSetStatusMessage(TQString msg)
{
    TDEMainWindow* mainWindow = dynamic_cast<TDEMainWindow*>(mainWidget());
    if (mainWindow) {
        if (msg.isEmpty())
            msg = KTmpStatusMsg::getDefaultMsg();
        mainWindow->statusBar()->changeItem(TQString("  %1").arg(msg), KTmpStatusMsg::getDefaultId());
    }

}

void
RosegardenApplication::refreshGUI(int maxTime)
{
    eventLoop()->processEvents(TQEventLoop::ExcludeUserInput |
                               TQEventLoop::ExcludeSocketNotifiers,
                               maxTime);
}

void RosegardenApplication::saveState(TQSessionManager& sm)
{
    emit aboutToSaveState();
    TDEUniqueApplication::saveState(sm);
}

RosegardenApplication* RosegardenApplication::rgApp()
{
    return dynamic_cast<RosegardenApplication*>(tdeApplication());
}

TQByteArray RosegardenApplication::Empty;

}

#include "RosegardenApplication.moc"
