/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateprecisiondialog.h"

#include <tqlabel.h>
#include <tqspinbox.h>
#include <tdelocale.h>
#include <tqhbox.h>
#include <kguiitem.h>
#include <tqlayout.h>
#include <kpushbutton.h>
#include <tdeversion.h>

QalculatePrecisionDialog::QalculatePrecisionDialog(TQWidget *parent, const char *name) : KDialogBase(parent, name, false, i18n("Precision"), Apply | Close, Close, true) {

#if TDE_VERSION_MAJOR < 4 && TDE_VERSION_MINOR < 2
	setButtonApplyText(i18n("Recalculate"));
#else
	setButtonApply(KGuiItem(i18n("Recalculate")));
#endif	
	setMainWidget(new TQWidget(this));
	TQHBoxLayout *box = new TQHBoxLayout(mainWidget());
	box->setSpacing(spacingHint());
	box->addWidget(new TQLabel(i18n("Precision:"), mainWidget()));
	precisionBox = new TQSpinBox(1, 100000, 1, mainWidget());
	precisionBox->setButtonSymbols(TQSpinBox::PlusMinus);
	box->addWidget(precisionBox);

	resize(TQSize(300, minimumSizeHint().height()).expandedTo(minimumSizeHint()));

}


QalculatePrecisionDialog::~QalculatePrecisionDialog() {}


#include "qalculateprecisiondialog.moc"
