#!/usr/bin/env python

import sys, random
from PyTQt.tqt import *

TRUE = 1
FALSE = 0

MAXPOINTS = 2000;  # maximum number of points
MAXCOLORS = 40;

#
# ConnectWidget - draws connected lines
#

class ConnectWidget(TQWidget):
	def __init__(self):
		TQWidget.__init__(self)
		self.setEraseColor( TQt.white )                # white background
		self.count = 0;
		self.down = FALSE
		
		self.points = []
		self.colors = []

		for i in range(MAXPOINTS):           # init arrays
			self.points.append(TQPoint())
		for i in range(MAXCOLORS):
			self.colors.append(TQColor( random.randint(0,255), random.randint(0,255), random.randint(0,255) ))

#
# Handles paint events for the connect widget.
#
	def paintEvent(self, pe):
		paint = TQPainter( self )
		for i in range(self.count-1):               # connect all points
			for j in range(i+1, self.count):
				paint.setPen( self.colors[random.randint(0,MAXCOLORS-1)] ) # set random pen color
				paint.drawLine( self.points[i], self.points[j] )           # draw line

#
# Handles mouse press events for the connect widget.
#
	def mousePressEvent(self, me):
		self.down = TRUE
		self.count = 0                                  # start recording points
		self.erase()                                    # erase widget contents

#
# Handles mouse release events for the connect widget.
#
	def mouseReleaseEvent(self, me ):
		self.down = FALSE                               # done recording points
		self.update()                                   # draw the lines

#
# Handles mouse move events for the connect widget.
#
	def mouseMoveEvent(self, me):	
		if self.down and self.count < MAXPOINTS:
			paint = TQPainter( self )
			self.points[self.count] = TQPoint(me.pos())   # add point
			paint.drawPoint( me.pos() )          # plot point
			self.count = self.count+1

#
# Create and display a ConnectWidget.
#
a = TQApplication( sys.argv )
connect = ConnectWidget()
connect.setCaption( "PyTQt Example - Draw lines")
a.setMainWidget( connect )
connect.show()
a.exec_loop()
