// This is an example not a library
/*
 * This file is part of the Polkit-qt project
 * Copyright (C) 2009 Jaroslav Reznik <jreznik@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB. If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef POLKIT_TQT_AGENT_TDE_LISTENER_H
#define POLKIT_TQT_AGENT_TDE_LISTENER_H

#include "polkit-tqt-agent-listener.h"

namespace PolkitTQt
{
  class Details;

namespace Agent
{
  class AsyncResult;
}

}

class TQtListener : public PolkitTQt::Agent::Listener
{
  TQ_OBJECT

  public:
    TQtListener(TQObject *parent = nullptr);

  public slots:
    void initiateAuthentication(const TQString &actionId, const TQString &message,
            const TQString &iconName, const PolkitTQt::Details &details,
            const TQString &cookie, const PolkitTQt::Identity::List &identities,
            PolkitTQt::Agent::AsyncResult *result);
    bool initiateAuthenticationFinish();
    void cancelAuthentication();

    void request(const TQString &request, bool echo);
    void completed(bool gainedAuthorization);
    void showError(const TQString &text);
    void showInfo(const TQString &text);

  private:
    // Disable copy
    TQtListener(const TQtListener&);
    TQtListener& operator=(const TQtListener&);
};

#endif
