#!/usr/bin/perl -w
use strict;
use blib;

package MyWidget;
use strict;
use TQt;
use TQt::isa qw(TQt::Widget);

use LCDRange;
use CannonField;

sub NEW {
    shift->SUPER::NEW(@_);

    my $quit = TQt::PushButton("&Quit", this, "quit");
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQ_SIGNAL('clicked()'), TQ_SLOT('quit()'));

    my $angle = LCDRange(this, "angle");
    $angle->setRange(5, 70);

    my $cannonField = CannonField(this, "cannonField");

    $cannonField->connect($angle, TQ_SIGNAL('valueChanged(int)'), TQ_SLOT('setAngle(int)'));
    $angle->connect($cannonField, TQ_SIGNAL('angleChanged(int)'), TQ_SLOT('setValue(int)'));

    my $grid = TQt::GridLayout(this, 2, 2, 10);
    $grid->addWidget($quit, 0, 0);
    $grid->addWidget($angle, 1, 0, &AlignTop);
    $grid->addWidget($cannonField, 1, 1);
    $grid->setColStretch(1, 10);

    $angle->setValue(60);
    $angle->setFocus();
}

package main;
use TQt;
use MyWidget;

TQt::Application::setColorSpec(&TQt::Application::CustomColor);
my $a = TQt::Application(\@ARGV);

my $w = MyWidget;
$w->setGeometry(100, 100, 500, 355);
$a->setMainWidget($w);
$w->show;
exit $a->exec;
