/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "toolinfo.h"
#include <tqfile.h>
#include <iostream>
#include <cstdlib>
#include <unistd.h>
#include <tdelocale.h>
#include <tdestandarddirs.h>
#include <tdemessagebox.h>
#include <tqtimer.h>
#include <tqstringlist.h>
#include <tqfileinfo.h>

ToolInfo::ToolInfo( const TQString &Name)
{
	this->Name = Name;
	this->programsInPath = programsInPath;
	this->found = false;
	TryPath_first="";
	/*
		if (!PathToExec.isEmpty())
			SearchPathList.append(PathToExec);*/
// 	if (config->KvpncDebugLevel > 2)
// 		std::cout << "Checking for: " << Name.ascii() << std::endl;

	Version=i18n("No info");

	env = new TQStringList();
	*env << "LC_ALL=C" << "LANG=C" << "PATH=/bin:/usr/bin:/usr/sbin:/sbin";

	collectRunning=false;
	collectOpenvpnCapabilitiesRunning=false;
	collectToolInfo();
}

bool ToolInfo::collectToolInfo()
{
	if(programsInPath)
	{
		addSearchPath("/usr/local/sbin");
		addSearchPath("/usr/sbin");
		addSearchPath("/sbin");
		addSearchPath("/usr/local/bin");
		addSearchPath("/usr/bin");
		addSearchPath("/bin");
		
		addSearchPath(TQString (TQString(getenv("HOME"))+"/bin"));
	}

	bool success = false;
	found = false;

	if ( TryPath_first.isEmpty() )
		TryPath_first=Name;

	TQStringList::Iterator it;
	if (TQFile (TryPath_first).exists() && TQFileInfo(TryPath_first).isFile() )
		{
// 			if (GlobalConfig->KvpncDebugLevel > 2)
// 				std::cout << Name.ascii() <<  "found at: " << TryPath_first.ascii() << ", was first try" << std::endl;
			found = true;
			PathToExec=TryPath_first;
	}
	else
	{
// 		if (GlobalConfig->KvpncDebugLevel > 2)
// 		{
// 			std::cout << TQString(i18n("Trying first %1 at %2 has been failed, trying other paths").arg(Name).arg(TryPath_first)).ascii() << std::endl;
// 			std::cout << "searchpath list: " << SearchPathList.join(" ").ascii() << std::endl;
// 		}
// std::cout << "searchpath list: " << SearchPathList.join(" ").ascii() << std::endl;
		for (TQStringList::Iterator it = SearchPathList.begin();it != SearchPathList.end();it++)
		{
			TQString TryPath=TQString(*it)+"/"+Name;
// 			if (GlobalConfig->KvpncDebugLevel > 2)
// 				std::cout << TQString (i18n("Trying %1 at: %2").arg(Name).arg(TryPath)).ascii() << std::endl;
	
			if (!TryPath.isEmpty()  && TQFile (TryPath).exists() && TQFileInfo(TryPath).isFile() )
			{
// 				if (GlobalConfig->KvpncDebugLevel > 2)
// 					std::cout << TQString(i18n("%1 found at: %2").arg(Name).arg(TryPath)).ascii() << std::endl;
				found=true;
				PathToExec=TryPath;
				break;
			}
		}
	}

	if ( found)
	{

		CollectToolInfoProcess = new TQProcess(this);
		CollectToolInfoProcess->clearArguments();
		connect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectToolInfo() ) );
		connect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectToolInfo() ) );
		//connect( CollectToolInfoProcess, TQ_SIGNAL( processExited () ), this, TQ_SLOT(processFinished()  ) );
		bool run=true;

		//FIXME how it could be better?
		CollectToolInfoProcess->addArgument(PathToExec);
		if (Name == "vpnc")
			CollectToolInfoProcess->addArgument("--version");
		else if (Name == "vpnclient") { }
		else	if (Name == "ipsec")
			CollectToolInfoProcess->addArgument("--version");
		else	if (Name == "racoon" )
		{
			// we need to do some stupid hack...
			// /usr/sbin/racoon -> /usr/sbin/setkey
			CollectToolInfoProcess->clearArguments();
			CollectToolInfoProcess->addArgument(TQString(PathToExec.left(PathToExec.length()-6)+"setkey"));
			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "setkey")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "openvpn")
			CollectToolInfoProcess->addArgument("--version");
		else	if (Name == "openssl")
			CollectToolInfoProcess->addArgument("version");
		else	if (Name == "pppd")
			CollectToolInfoProcess->addArgument("--version");
		else	if (Name == "iptables")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "kill")
		{
			// 			run=false;
			// 			success=true;
			CollectToolInfoProcess->addArgument("-V");
		}
		else	if (Name == "killall")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "ping")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "ip")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "ifconfig")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "route")
			CollectToolInfoProcess->addArgument("-V");
		else	if (Name == "pptp")
			;
		else	if (Name == "l2tpd")
			CollectToolInfoProcess->addArgument("-D");
		else	if (Name == "xl2tpd")
			CollectToolInfoProcess->addArgument("-v");
		else	if (Name == "openl2tpd")
		{
			CollectToolInfoProcess->addArgument("-c");
			CollectToolInfoProcess->addArgument("-");
			CollectToolInfoProcess->addArgument("-f");
		}
		else if (Name =="pkcs11-tool")
			CollectToolInfoProcess->addArgument("-I");
		else if (Name =="vtund")
			CollectToolInfoProcess->addArgument("-h");
		else if (Name == "cisco_cert_mgr");
		else if (Name =="tail")
			CollectToolInfoProcess->addArgument("--version");
		else if (Name =="ssh")
			CollectToolInfoProcess->addArgument("-V");
		else if (Name =="ksshaskpass")
			CollectToolInfoProcess->addArgument("--version");
// 		else if (Name =="gnome-ssh-askpass")
// 			CollectToolInfoProcess->addArgument("--version");
		else if (Name =="netstat")
			CollectToolInfoProcess->addArgument("--version");
		else
		{
// 			if (GlobalConfig->KvpncDebugLevel > 2)
// 				std::cout << "Invalid tool (" << Name.ascii() <<")!" << std::endl;
			run=false;
			success=false;
		}

		collectRunning=false;

		if (run )
		{

			if ( !PathToExec.isEmpty() && !CollectToolInfoProcess->start(env) )
			{
				std::cerr << (i18n("Unable to start collectToolInfo process (%1)!").arg(Name)).ascii() << std::endl;
				//delete CollectToolInfoProcess;
				collectRunning=false;
				success=false;
			}
			else
			{
				collectRunning=true;

				while(CollectToolInfoProcess->isRunning() && collectRunning)
				{
					if (Name == "l2tpd" || Name == "pkcs11-tool" || Name == "cisco_cert_mgr"  || Name == "vpnclient")
					{
						usleep(500);
						CollectToolInfoProcess->kill();
					}
				}

				//KMessageBox::information(0,TQString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version),"aaa");
				// 		disconnect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectToolInfo() ) );
				// 		disconnect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectToolInfo() ) );
				// 		delete CollectToolInfoProcess;
				success=true;
			}
		}

		disconnect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectToolInfo() ) );
		disconnect( CollectToolInfoProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectToolInfo() ) );

		delete CollectToolInfoProcess;
		CollectToolInfoProcess=0L;

		//std::cout << "Name: " << Name << ", Path: " << PathToExec << ", Version: " << Version << std::endl;

		if (Name=="openvpn")
			getOpenvpnCapabilities();
	}
	else
	{
// 		if (GlobalConfig->KvpncDebugLevel > 2)
// 			std::cout << TQString(i18n("%1 not found.").arg(Name)).ascii() << std::endl;
	}
	return success;
}

void ToolInfo::getOpenvpnCapabilities()
{

	if (Name=="openvpn" && !PathToExec.isEmpty())
	{

		CollectOpenvpnCapabilitiesProcess = new TQProcess(this);
		CollectOpenvpnCapabilitiesProcess->clearArguments();
		connect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectOpenvpnCapabilies() ) );
		connect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectOpenvpnCapabilies() ) );
		connect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( processExited () ), this, TQ_SLOT(processFinished()  ) );

		//FIXME how it could be better?
		CollectOpenvpnCapabilitiesProcess->addArgument(PathToExec);
		if (Name == "vpnc")
			CollectOpenvpnCapabilitiesProcess->addArgument("--help");

		collectOpenvpnCapabilitiesRunning=false;

		if ( !PathToExec.isEmpty() && !CollectOpenvpnCapabilitiesProcess->start(env) )
		{
			std::cerr << i18n("Unable to start collectToolInfo process (%1)!").arg(Name).ascii() << std::endl;

			//delete CollectToolInfoProcess;
			collectOpenvpnCapabilitiesRunning=false;
		}
		else
		{
			collectOpenvpnCapabilitiesRunning=true;
			while(CollectOpenvpnCapabilitiesProcess->isRunning() && collectOpenvpnCapabilitiesRunning)
			{
				// wait...
			}

			//KMessageBox::information(0,TQString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version),"aaa");
			// 		disconnect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectOpenvpnCapabilies() ) );
			// 		disconnect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectOpenvpnCapabilies() ) );
			// 		delete CollectOpenvpnCapabilitiesProcess;
		}

		disconnect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStdout() ), this, TQ_SLOT( readStdOutCollectOpenvpnCapabilies() ) );
		disconnect( CollectOpenvpnCapabilitiesProcess, TQ_SIGNAL( readyReadStderr() ), this, TQ_SLOT( readStdErrCollectOpenvpnCapabilies() ) );


		//std::cout << "Name: " << Name << ", Path: " << PathToExec << ", Version: " << Version << std::endl;
	}
}

void ToolInfo::addSearchPath(const TQString& path )
{

	// 	std::cout << "Path added: " << path << std::endl;
	if (!path.isEmpty())
		SearchPathList.insert(SearchPathList.end(), TQString(path));
	else

		return;
}

void ToolInfo::removeSearchPath(const TQString& path )
{

	// 	std::cout << "Path removed: " << path << std::endl;
	if (!path.isEmpty())
		SearchPathList.remove(TQString(path));
	else

		return;
}


/* == slots  == */
/**
 *
 */
void ToolInfo::readStdOutCollectToolInfo ()
{
	while (CollectToolInfoProcess->canReadLineStdout())
	{
		TQString msg = TQString( CollectToolInfoProcess->readLineStdout() );
		//	TQString msg = TQString( CollectToolInfoProcess->readStdout() );
		// 		std::cout << "Checking for: " << Name.ascii() << std::endl;
		// 		std::cout << "stdout collectToolInfo: " << msg.ascii() <<std::endl;

		//FIXME how it could be better?
		if (Name == "vpnc")
		{
			if ( msg.find( "version", 0, false ) > -1 )
			{
// 												std::cout << "stdout collectToolInfo: " << msg.ascii() << std::endl;
// 												std::cout << "stdout collectToolInfo: 2,2 " << msg.simplifyWhiteSpace().section(' ',2,2).ascii() << std::endl;
				Version = msg.simplifyWhiteSpace().section(' ',2,2);
			}
			if ( msg.find( "Built without openssl (certificate) support.", 0, false ) > -1 )
			{
// 				Capabilities+=i18n("no openssl support")+";";
			}
			else if ( msg.find( "Built with openssl (certificate) support.", 0, false ) > -1 )
			{
				Capabilities=i18n("openssl (certificate) support")+";";
			}
		}
		else if (Name == "vpnclient" || Name =="cisco_cert_mgr")
		{
			if ( msg.find( "Cisco Systems VPN Client", 0, false ) > -1 )
				Version = msg.section(' ',5,6); // "Cisco Systems VPN Client Version 4.8.00 (0490)"
		}
		else if (Name == "ipsec")
		{
			if ( msg.find( "wan", 0, false ) > -1 )
			{
				// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
// 				if ( msg.find( "openswan", 0, false ) > -1 )
// 					Version = msg.section(' ',2,2);
// 				else
					Version = msg.section(' ',1,2); // "Openswan Ux.x.x/kx.x.x"
					if (msg.section(' ',1,2).contains('/'))
						Version = msg.section(' ',1,2).section('/',0,0); // "Openswan Ux.x.x"
					else
						Version = msg.section(' ',1,2);
			}
		}
		else	if (Name == "racoon" || Name == "racoonctl")
		{

			// we need to do some stupid hack...
			// /usr/sbin/racoon -> /usr/sbin/setkey
			CollectToolInfoProcess->addArgument(TQString(PathToExec.left(PathToExec.length()-6)+"setkey"));
			if ( msg.find( "ipsec-tools", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3);
			}
		}
		else	if (Name == "setkey")
		{
			if ( msg.find( "ipsec-tools", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3);
			}
		}
		else	if (Name == "openvpn")
		{
			if ( msg.find( "built", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "openssl")
		{
			if ( msg.find( "OpenSSL", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "pppd")
		{
			if ( msg.find( "version", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "iptables")
		{
			if ( msg.find( "iptables", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "ping")
		{
			if ( msg.find( "ping", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "ip")
		{
			if ( msg.find( "ip", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "kill")
		{
			if ( msg.find( "kill", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3).section(')',0,0);
			}
		}
		else	if (Name == "pkcs11-tool")
		{
			if ( msg.find( "version", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
			else if ( msg.find( "Error: can't open /var/run/openct/status", 0, false ) > -1 )
			{
				std::cerr << "stdout collectToolInfo (pkcs11): " << msg.ascii() << std::endl;
				CollectToolInfoProcess->kill();
			}
		}
		else	if (Name == "xl2tpd")
		{
			if ( msg.find( "version:", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3).stripWhiteSpace();
			}
		}
		else	if (Name == "openl2tpd")
		{
			if ( msg.find( "OpenL2TP V", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1).remove(',').remove('V');
				std::cerr << "stdout collectToolInfo (openl2tpd): " << msg.ascii() << std::endl;
				CollectToolInfoProcess->kill();
			}
		}
		else	if (Name == "vtund")
		{
			if ( msg.find( "VTun ver", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,3).stripWhiteSpace();
			}
		}
		else	if (Name == "tail")
		{
			if ( msg.find( "tail ", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',3,3).stripWhiteSpace();
			}
		}
		else	if (Name == "ksshaskpass")
		{
			if ( msg.find( "Ksshaskpass:", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1).stripWhiteSpace();
			}
		}
		else	if (Name == "gnome-ssh-askpass")
		{
// 			if ( msg.find( "askpass", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
// 				Version = msg.section(' ',3,3).stripWhiteSpace();
					Version=i18n("unknown");
			}
		}
		else	if (Name == "netstat")
		{
			if ( msg.find( "netstat ", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1).stripWhiteSpace();
			}
		}
		else
		{
// 			KMessageBox::information(0,TQString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version+", err: "+msg),"aaa");
		}
	}
	collectRunning=false;
}

void ToolInfo::readStdErrCollectToolInfo()
{
	while (CollectToolInfoProcess->canReadLineStderr())
	{
		TQString msg = TQString( CollectToolInfoProcess->readLineStderr() );
// 		if (GlobalConfig->KvpncDebugLevel > 2)
// 		{
// 			std::cout << "Checking for: " << Name.ascii() << std::endl;
// 			std::cout << "stderr collectToolInfo: " << msg.ascii() <<std::endl;
// 		}

		if (Name == "pppd")
		{
			if ( msg.find( "version", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "killall")
		{
			if ( msg.find( "killall", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2);
			}
		}
		else	if (Name == "ifconfig")
		{
			//KMessageBox::information(0,TQString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version),"aaa");
			if ( msg.find( "ifconfig", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "route")
		{
			if ( msg.find( "route", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',1,1);
			}
		}
		else	if (Name == "pptp")
		{
			if ( msg.find( "pptp version", 0, false ) > -1 )
			{
				//				std::cout << "stdout collectToolInfo: " << msg.ascii() << std::endl;
				Version = msg.section(' ',2,2).section(')',0,0);
			}
		}
		else	if (Name == "l2tpd")
		{
			if ( msg.find( "l2tpd", 0, false ) > -1 )
			{
				//std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',2,2).section(')',0,0);
			}
		}
		else	if (Name == "pkcs11-tool")
		{
			if ( msg.find( "version", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo (pkcs11): " << msg.ascii() << std::endl;
				Version = msg.section(' ',2,2);
			}
			else if ( msg.find( "Error: can't open /var/run/openct/status", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo (pkcs11): " << msg.ascii() << std::endl;
				CollectToolInfoProcess->kill();
			}
		}
		else	if (Name == "ssh")
		{
			if ( msg.find( "OpenSSH", 0, false ) > -1 )
			{
// 				std::cout << "stdout collectToolInfo: " << msg << std::endl;
				Version = msg.section(' ',0,0).section('_',1,1).stripWhiteSpace();
			}
		}
		else
		{
// 			KMessageBox::information(0,TQString("Name: "+Name+", Path: "+PathToExec+", Version: "+Version+", err: "+msg),"aaa");
		}
	}
}

void ToolInfo::readStdOutCollectOpenvpnCapabilies()
{
	while (CollectOpenvpnCapabilitiesProcess->canReadLineStdout())
	{
		TQString msg = TQString( CollectOpenvpnCapabilitiesProcess->readLineStdout() );
		//	TQString msg = TQString( CollectOpenvpnCapabilitiesProcess->readStdout() );
		// 		std::cout << "stdout collectOpenvpnCapabilities: " << msg.ascii() <<std::endl;
		if ( msg.find( "PKCS#11 Options:", 0, false ) > -1 )
			Capabilities+=i18n("pkcs11 support")+";";

	}
	collectOpenvpnCapabilitiesRunning=false;
}

void ToolInfo::readStdErrCollectOpenvpnCapabilies()
{
	while (CollectOpenvpnCapabilitiesProcess->canReadLineStderr())
	{
		TQString msg = TQString( CollectOpenvpnCapabilitiesProcess->readLineStderr() );
		// 		std::cout << "stderr collectOpenvpnCapabilities: " << msg.ascii() <<std::endl;

	}
}

void ToolInfo::processFinished()
{
	collectRunning=false;
	collectOpenvpnCapabilitiesRunning=false;
}

#include "toolinfo.moc"
