#ifndef _SCRIPTEDITOR_H_
#define _SCRIPTEDITOR_H_

//=============================================================================
//
//   File : scripteditor.h
//   Created on Sun Mar 28 1999 16:11:48 CEST by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_scripteditor.h"

#include <tqlabel.h>
#include <kvi_tal_textedit.h>
#include <tqsyntaxhighlighter.h>
#include <tqdialog.h>
#include <tqcheckbox.h>
#include "kvi_tal_listbox.h"
#include <tqevent.h> 
#include "kvi_qcstring.h"

#include "kvi_tal_popupmenu.h"

#include "kvi_pointerlist.h"
#include "kvi_selectors.h"
typedef KviPointerList<int> ColumnList;

class KviCompletionBox: public KviTalListBox
{
	TQ_OBJECT
  
public:
	KviCompletionBox(TQWidget * parent = 0);
	~KviCompletionBox(){};
	
	void updateContents(TQString word);
protected:
	virtual void keyPressEvent(TQKeyEvent * e);
};

class KviScriptEditorWidget : public KviTalTextEdit
{
	TQ_OBJECT
  
	TQ_PROPERTY(bool contextSensitiveHelp READ contextSensitiveHelp)
public:
	KviScriptEditorWidget(TQWidget * pParent);
	virtual ~KviScriptEditorWidget();
public:
	void updateOptions();
	void find1();
	TQString m_szFind;
	KviCompletionBox *completelistbox;
	void completition(bool bCanComplete = 1);
	void getWordBeforeCursor(TQString &buffer,int index,bool *);
	void getWordOnCursor(TQString &buffer,int index) const;
	bool contextSensitiveHelp() const;
public slots:
	void slotFind();
	void slotHelp();
	void slotReplace();
	void slotComplete(const TQString &str);

signals:
	void keyPressed();
protected:
	virtual void keyPressEvent(TQKeyEvent * e);
	void contentsMousePressEvent(TQMouseEvent *);
	TQPopupMenu *createPopupMenu( const TQPoint& pos );
	TQWidget *m_pParent;
	TQString m_szHelp;

};

	#include <tqobjectlist.h>
class KviScriptSyntaxHighlighter : public TQSyntaxHighlighter
{
public:
	KviScriptSyntaxHighlighter(KviScriptEditorWidget * pWidget);
	virtual ~KviScriptSyntaxHighlighter();
public:
	virtual int highlightParagraph(const TQString & text,int endStateOfLastPara);
};

class KviScriptEditorWidgetColorOptions : public TQDialog
{
	TQ_OBJECT
  
public:
	KviScriptEditorWidgetColorOptions(TQWidget * pParent);
	~KviScriptEditorWidgetColorOptions();
private:
	KviPointerList<KviSelectorInterface> * m_pSelectorInterfaceList;
protected:
	KviColorSelector * addColorSelector(TQWidget * pParent,const TQString & txt,TQColor * pOption,bool bEnabled);

protected slots:
	void okClicked();
};

class TQTimer;

class KviScriptEditorImplementation : public KviScriptEditor
{
	TQ_OBJECT
  
public:
	KviScriptEditorImplementation(TQWidget * par);
	virtual ~KviScriptEditorImplementation();
protected:
	KviScriptEditorWidget * m_pEditor;
	TQLabel                * m_pRowColLabel;
	TQPoint                  m_lastCursorPos;
public:
	virtual void setText(const TQString &txt);
	virtual void getText(TQString &txt);
	virtual void setText(const KviTQCString &txt);
	virtual void getText(KviTQCString &txt);
	virtual void setFindText(const TQString & text);
	virtual void setEnabled(bool bEnabled);
	virtual void setFocus();
	virtual bool isModified();
	void setFindLineeditReadOnly(bool b);
	void setCursorPosition(TQPoint);
	TQPoint getCursor();
	TQLineEdit *m_pFindlineedit;
	TQLineEdit * getFindlineedit();
protected:
	virtual void focusInEvent(TQFocusEvent *e);
	void loadOptions();
	void saveOptions();
protected slots:
	void saveToFile();
	void loadFromFile();
	void configureColors();
	void updateRowColLabel();
	void slotFind();
	void slotReplaceAll(const TQString &,const TQString &);
	void slotInitFind();
	void slotNextFind(const TQString &);
signals:
	void find( const TQString &);
	void replaceAll( const TQString &, const TQString &);
	void initFind();
	void nextFind(const TQString &);
};

class KviScriptEditorReplaceDialog: public TQDialog
{
	TQ_OBJECT
  
public:
	KviScriptEditorReplaceDialog( TQWidget* parent = 0, const char* name = 0);
    ~KviScriptEditorReplaceDialog();
	TQLineEdit *m_pFindlineedit;
	TQLineEdit *m_pReplacelineedit;
protected:
	TQLabel *findlabel;
	TQLabel *replacelabel;
	TQPushButton *replacebutton;
	TQPushButton *replace;
	TQPushButton *findNext;

//	TQPushButton *cancelbutton;
	KviStyledCheckBox *checkReplaceAll;
	TQWidget *m_pParent;
protected slots:
	void textChanged(const TQString &);
	void slotReplace();
	void slotNextFind();
signals:
	void replaceAll( const TQString &,const TQString &);
	void initFind();
	void nextFind(const TQString &);
	
};


#endif //!_SCRIPTEDITOR_H_
