/***************************************************************************
 *   Copyright (C) 2003-2005 by David Saxton                               *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef ASMFORMATTER_H
#define ASMFORMATTER_H

#include <tqstringlist.h>

/**
@author David Saxton
 */
class InstructionParts
{
	public:
		/**
		 * Breaks up the line into parts.
		 */
		InstructionParts( TQString line );
		
		TQString label() const { return m_label; }
		TQString operand() const { return m_operand; }
		TQString operandData() const { return m_operandData; }
		TQString comment() const { return m_comment; }
		
	protected:
		TQString m_label;
		TQString m_operand;
		TQString m_operandData;
		TQString m_comment; ///< includes the ";" part
};

/**
@author David Saxton
*/
class AsmFormatter
{
	public:
		AsmFormatter();
		~AsmFormatter();
	
		enum LineType
		{
			Equ,
			Instruction, // could include label
			Other, // eg comments, __config
		};
	
		TQString tidyAsm( TQStringList lines );
	
		static LineType lineType( TQString line );
	
	protected:
		TQString tidyInstruction( const TQString & line );
		TQString tidyEqu( const TQString & line );
		/**
		 * Appends spaces to the end of text until it is greater or equakl to
		 * length.
		 */
		static void pad( TQString & text, int length );
	
		int m_indentAsmName;
		int m_indentAsmData;
		int m_indentEqu;
		int m_indentEquValue;
		int m_indentEquComment;
		int m_indentComment;
};

#endif
