###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### look for gpsim

if( NOT WITH_GPSIM )
    set( NO_GPSIM 1 )
 else()
    find_path( HAVE_GPSIM_INCLUDE "gpsim/cod.h" )
    find_library( HAVE_GPSIM_LIBRARY gpsim)

    if( (NOT HAVE_GPSIM_INCLUDE) OR (NOT HAVE_GPSIM_LIBRARY) )
        tde_message_fatal( "gpsim support have been requested but was not found on your system" )
     else()
        set( GPSIM_INCLUDE_DIRS ${HAVE_GPSIM_INCLUDE} )
        set( GPSIM_LIBRARIES gpsim;gpsimcli )

##### glib-1.2 or glib-2.0

        pkg_search_module( GLIB glib-2.0 glib )
        message( STATUS "glib version: ${GLIB_VERSION}" )

        if( NOT GLIB_FOUND )
            tde_message_fatal( "glib is required but was not found on your system" )
        endif()

        tde_save( CMAKE_REQUIRED_INCLUDES )
        set( CMAKE_REQUIRED_INCLUDES ${GLIB_INCLUDE_DIRS} ${GPSIM_INCLUDE_DIRS})

##### check for gpsim version

        if( EXISTS ${GPSIM_INCLUDE_DIRS}/gpsim/breakpoints.h )
          file( STRINGS ${GPSIM_INCLUDE_DIRS}/gpsim/breakpoints.h
                GPSIM_BROKEN_INCLUDE
                REGEX "^#include \"../config.h" )
          if( NOT "${GPSIM_BROKEN_INCLUDE}" STREQUAL "" )
            message( STATUS "Create fake config.h, due to broken gpsim includes" )
            list( APPEND CMAKE_REQUIRED_INCLUDES "${CMAKE_BINARY_DIR}/CMakeFiles" )
            list( APPEND GPSIM_INCLUDE_DIRS "${CMAKE_BINARY_DIR}/src" )
            if( NOT EXISTS "${CMAKE_BINARY_DIR}/config.h" )
              file( WRITE "${CMAKE_BINARY_DIR}/config.h"
                    "/* fake config.h - due to broken gpsim includes */" )
            endif()
          endif()
        endif()

        check_cxx_source_compiles( "
        #include <gpsim/interface.h>
        #include <gpsim/gpsim_interface.h>
        #include <gpsim/breakpoints.h>
        #include <gpsim/gpsim_time.h>
        void func()
        {
            (void)cycles;
            (void)initialize_gpsim_core();
            (void)load_symbol_file(0,0);
        }
        int main()
        {
            return 0;
        } "
        GPSIM_0_21_4
        )

        check_cxx_source_compiles( "
        #include <gpsim/interface.h>
        #include <gpsim/gpsim_interface.h>
        #include <gpsim/breakpoints.h>
        #include <gpsim/gpsim_time.h>
        #include <gpsim/symbol.h>
        #include <gpsim/program_files.h>
        void func()
        {
            (void)cycles;
            (void)initialize_gpsim_core();
        }
        int main()
        {
            return 0;
        } "
        GPSIM_0_21_11
        )
   
        check_cxx_source_compiles( "
        #include <gpsim/ValueCollections.h>
        int main()
        {
            return 0;
        } "
        GPSIM_0_21_12
        )

        check_cxx_source_compiles( "
        #include <gpsim/pic-processor.h>
        void func()
        {
            pic_processor *Processor;
            sizeof(Processor->Wreg);
        }
        int main()
        {
            return 0;
        } "
        GPSIM_0_27_0
        )
       tde_restore( CMAKE_REQUIRED_INCLUDES )
    endif((NOT HAVE_GPSIM_INCLUDE) OR (NOT HAVE_GPSIM_LIBRARY))
endif( NOT WITH_GPSIM )


##### mechanics

if( WITH_MECHANICS )
    set( MECHANICS 1 )
endif()
