/***************************************************************************
 *   Copyright (C) 2003 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "libraryitem.h"

#include <kiconloader.h>
#include <kicontheme.h>
#include <tdestandarddirs.h>
#include <tqimage.h>

LibraryItem::LibraryItem( TQStringList idList, const TQString &name, const TQString &category, TQPixmap icon, Type type, createItemPtr _createItem )
{
	m_idList = idList;
	m_name = name;
	m_category = category;
	m_icon_full = icon;
	m_type = type;
	createItem = _createItem;
	createIcon16();
}


LibraryItem::LibraryItem( TQStringList idList, const TQString &name, const TQString &category, const TQString &iconName, Type type, createItemPtr _createItem )
{
	m_idList = idList;
	m_name = name;
	m_category = category;
	m_icon_full.load( locate( "appdata", "icons/"+iconName ) );
	m_type = type;
	createItem = _createItem;
	createIcon16();
}


LibraryItem::LibraryItem( TQStringList idList, const TQString &name, const TQString &category, Type type, createItemPtr _createItem )
{
	m_idList = idList;
	m_name = name;
	m_category = category;
	m_type = type;
	createItem = _createItem;
	createIcon16();
}


LibraryItem::~LibraryItem()
{
}


void LibraryItem::createIcon16()
{
	if ( m_icon_full.isNull() )
		m_icon_full = TDEGlobal::iconLoader()->loadIcon( "null", TDEIcon::Small );
	
// 	const int size = TDEIcon::SizeSmallMedium;
// 	const int size = 22;
	const int size = 16;
	
	if ( m_icon_full.width() == size && m_icon_full.height() == size )
	{
		m_icon_16 = m_icon_full;
		return;
	}
	
	TQImage im = m_icon_full.convertToImage();
	im = im.smoothScale( size, size, TQImage::ScaleMin );
	m_icon_16.convertFromImage(im);
}

TQString LibraryItem::activeID( ) const
{
	return m_idList.isEmpty() ? "" : m_idList[0];
}
