/***************************************************************************
 *   Copyright (C) 2005 by Nicolas Ternisien                               *
 *   nicolas.ternisien@gmail.com                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <tdemessagebox.h>

#include "parsingHelper.h"
#include "cupsReader.h"

#define DEBUG2_LOG_LEVEL_ICON "text-x-src"

CupsReader::CupsReader(TQObject *parent, const char *name) : 
	DefaultReader(parent, name)
	{
	
	initializeTypeLevels();
}


CupsReader::~CupsReader() {

}


void CupsReader::initColumns(LogViewColumns* columns) {
	columns->append(new LogViewColumn(i18n("Date"), true, false));
	columns->append(new LogViewColumn(i18n("Message"), true, false));

}


LogLine* CupsReader::parseMessage(TQString& logLine, LogFile* logFile) {
	/*
	 * Log line examples :
	 * I [15/Feb/2004:01:29:32 +0100] LoadPPDs: No new or changed PPDs...
	 * E [15/Feb/2004:01:43:15 +0100] Scheduler shutting down due to SIGTERM.
	 */
	
	TQChar level=logLine[0];
	
	TQString strDateTime=logLine.mid(2, 28);
	TQDateTime dateTime=ParsingHelper::parseDateTimeFromHTTP(strDateTime);
	TQDate date=dateTime.date();
	TQTime time=dateTime.time();
		
	TQString message=logLine.remove(0, 31);
	
	LogLevel* logLevel=getTypeLevel(level);
	
	TQStringList list;
	list.push_back(message);
	
	TQString filePath=logFile->url.path();
		
	LogLine* line=new LogLine(date, time, list, filePath, logLevel, Globals::cupsMode->id);
	
	return(line);
}


void CupsReader::initializeTypeLevels() {
	mapTypeLevels['d']=new LogLevel(20, i18n("debug 2"), DEBUG2_LOG_LEVEL_ICON, TQColor(169, 189, 165));
	mapTypeLevels['D']=Globals::debugLogLevel;
	mapTypeLevels['I']=Globals::informationLogLevel;
	mapTypeLevels['N']=Globals::noticeLogLevel;
	mapTypeLevels['W']=Globals::warningLogLevel;
	mapTypeLevels['E']=Globals::errorLogLevel;
	mapTypeLevels['C']=Globals::criticalLogLevel;
	mapTypeLevels['A']=Globals::alertLogLevel;
	mapTypeLevels['X']=Globals::emergencyLogLevel;
	mapTypeLevels[' ']=Globals::noneLogLevel;
}

LogLevel* CupsReader::getTypeLevel(const TQChar& type) {
	TQMap<TQChar, LogLevel*>::iterator it;
	
	it=mapTypeLevels.find(type);
	if (it!=mapTypeLevels.end()) {
		return(*it);
	}
	else {
		kdDebug() << i18n("New Log Level detected: Please send this log file to the KSystemLog developer to add it.") << endl;
		return(Globals::noneLogLevel);
	}
}



#include "cupsReader.moc"
