/***************************************************************************
                          sq_progressbox.cpp  -  description
                             -------------------
    begin                : ??? Jan 21 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqpushbutton.h>

#include "sq_iconloader.h"
#include "sq_progressbox.h"

SQ_ProgressBox::SQ_ProgressBox(TQWidget *parent, const char *name) : TQHBox(parent, name)
{
//    TQToolBar *progressBoxBar = new TQToolBar(TQString(), NULL, this);
    buttonStop = new TQPushButton(this);
    buttonStop->setFlat(true);
    buttonStop->setPixmap(SQ_IconLoader::instance()->loadIcon("media-playback-stop", TDEIcon::Desktop, TDEIcon::SizeSmall));
    connect(buttonStop, TQ_SIGNAL(clicked()), parent, TQ_SLOT(slotThumbnailUpdateToggle()));

    // create progress bar
    p = new SQ_Progress(this);

    // setup progress bar
    setFrameShape(TQFrame::NoFrame);
    setSpacing(0);
    setMargin(0);
    setStretchFactor(p, 1);
    setGeometry(5, 5, 160, 22);

    hide();
}

SQ_ProgressBox::~SQ_ProgressBox()
{}

void SQ_ProgressBox::startButtonPixmap()
{
    buttonStop->setPixmap(SQ_IconLoader::instance()->loadIcon("media-playback-start", TDEIcon::Desktop, TDEIcon::SizeSmall));
}

void SQ_ProgressBox::stopButtonPixmap()
{
    buttonStop->setPixmap(SQ_IconLoader::instance()->loadIcon("media-playback-stop", TDEIcon::Desktop, TDEIcon::SizeSmall));
}
