/***************************************************************************
                          sq_progress.h  -  description
                             -------------------
    begin                : ??? ??? 29 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_PROGRESS_H
#define SQ_PROGRESS_H

#include <tqlabel.h>
#include <tqcolor.h>

class TQPainter;

/*
 *  SQ_Progress is a simple replacement for TQProgressBar
 */

class SQ_Progress : public TQLabel
{
    public:
        SQ_Progress(TQWidget *parent = 0, const char *name = 0);
        ~SQ_Progress();

        void setTotalSteps(int totalSteps);
        void addSteps(int steps);

        void setColor(const TQColor &c); // alternative progress color

        /*
         *  Set current progress to 'progress'.
         */
        void setIndicator(int progress);

        /*
         *  Add 'step_new' to current step.
         */
        void advance(int step_new = 1);

        /*
         *  Clear drawing.
         */
        void flush();

        bool showText() const;

        void setShowText(bool sh);

    protected:
            virtual void paintEvent(TQPaintEvent *);

    private:
        void drawProgress();

    private:
        int percentage, total_steps, step;
        bool m_text;
        TQColor color;

        TQPainter *painter;
};

inline
bool SQ_Progress::showText() const
{
    return m_text;
}

inline
void SQ_Progress::setShowText(bool sh)
{
    m_text = sh;
}

inline
void SQ_Progress::setColor(const TQColor &c)
{
    color = c;
}

inline
void SQ_Progress::addSteps(int steps)
{
    total_steps += steps;
    setIndicator(step);
}

#endif
