#include <tqpoint.h>
#include <tqwidget.h>
#include <tqstylesheet.h>

#include <tdelocale.h>
#include <kurl.h>
#include <tdeio/job.h>
#include <kpropertiesdialog.h>
#include <kinputdialog.h>
#include <tdemessagebox.h>

#include "sq_treeviewmenu.h"
#include "ksquirrel.h"
#include "sq_iconloader.h"

SQ_TreeViewMenu::SQ_TreeViewMenu(TQWidget *parent, const char *name) : TDEPopupMenu(parent, name)
{
    id_new = insertItem(SQ_IconLoader::instance()->loadIcon("folder-new", TDEIcon::Desktop, TDEIcon::SizeSmall), i18n("New folder..."), this, TQ_SLOT(slotDirectoryNew()));
    insertSeparator();
    id_rename = insertItem(i18n("Rename"), this, TQ_SLOT(slotDirectoryRename()));
    id_clear  = insertItem(i18n("Clear contents"), this, TQ_SLOT(slotDirectoryClear()));
    id_delete = insertItem(SQ_IconLoader::instance()->loadIcon("edit-delete", TDEIcon::Desktop, TDEIcon::SizeSmall), i18n("Delete"), this, TQ_SLOT(slotDirectoryDelete()));
    insertSeparator();
    id_prop = insertItem(i18n("Properties"), this, TQ_SLOT(slotDirectoryProperties()));
}

SQ_TreeViewMenu::~SQ_TreeViewMenu()
{}

void SQ_TreeViewMenu::reconnect(Element elem, TQObject *receiver, const char *member)
{
    int id;

    if(elem == SQ_TreeViewMenu::New)
        id = id_new;
    else if(elem == SQ_TreeViewMenu::Delete)
        id = id_delete;
    else if(elem == SQ_TreeViewMenu::Rename)
        id = id_rename;
    else if(elem == SQ_TreeViewMenu::Clear)
        id = id_clear;
    else
        id = id_prop;

    disconnectItem(id, 0, 0);
    connectItem(id, receiver, member);
}

void SQ_TreeViewMenu::updateDirActions(bool isdir, bool isroot)
{
    setItemEnabled(id_new, isdir);
    setItemEnabled(id_clear, isdir);

    setItemEnabled(id_delete, !isroot);
    setItemEnabled(id_rename, isdir && !isroot);
}

void SQ_TreeViewMenu::slotDirectoryNew()
{
    if(!m_url.isEmpty())
    {
        bool ok;

        TQString mNewFilename = KInputDialog::getText(i18n("Create Subfolder"),
                i18n("<p>Create new folder in <b>%1</b>:</p>").arg(TQStyleSheet::escape(m_url.filename())),
                TQString(), &ok, KSquirrel::app());

        if(ok)
        {
            KURL dstURL = m_url;
            dstURL.addPath(mNewFilename);
            TDEIO::Job *job = TDEIO::mkdir(dstURL);

            connect(job, TQ_SIGNAL(result(TDEIO::Job*)), this, TQ_SLOT(slotDirectoryResult(TDEIO::Job *)));
        }
    }
}

void SQ_TreeViewMenu::slotDirectoryRename()
{
    if(!m_url.isEmpty())
    {
        KURL renameSrcURL = m_url;
        bool ok;

        TQString filename = TQStyleSheet::escape(renameSrcURL.filename());

        TQString mNewFilename = KInputDialog::getText(i18n("Rename Folder"),
                i18n("<p>Rename folder <b>%1</b> to:</p>").arg(filename),
                renameSrcURL.filename(), &ok, KSquirrel::app());

        if(ok)
        {
            KURL renameDstURL = renameSrcURL;
            renameDstURL.setFileName(mNewFilename);

            TDEIO::Job *job = TDEIO::rename(renameSrcURL, renameDstURL, true);

            connect(job, TQ_SIGNAL(result(TDEIO::Job*)), this, TQ_SLOT(slotDirectoryResult(TDEIO::Job *)));
        }
    }
}

void SQ_TreeViewMenu::slotDirectoryDelete()
{
    if(!m_url.isEmpty())
    {
        TQString dir = TQStyleSheet::escape(m_url.path());

        if(KMessageBox::questionYesNo(KSquirrel::app(),
            "<qt>" + i18n("Are you sure you want to delete <b>%1</b>?").arg(dir) + "</qt>") == KMessageBox::No)
            return;

        TDEIO::Job *job = TDEIO::del(m_url);

        connect(job, TQ_SIGNAL(result(TDEIO::Job*)), this, TQ_SLOT(slotDirectoryResult(TDEIO::Job *)));
    }
}

void SQ_TreeViewMenu::slotDirectoryClear()
{
    if(!m_url.isEmpty())
    {
        urlstodel.clear();

        if(KMessageBox::questionYesNo(KSquirrel::app(),
            "<qt>" + i18n("Are you sure you want to delete contents of <b>%1</b>?").arg(m_url.path()) + "</qt>") == KMessageBox::No)
            return;

        TDEIO::Job *job = TDEIO::listDir(m_url, false, true);

        connect(job, TQ_SIGNAL(entries(TDEIO::Job *, const TDEIO::UDSEntryList &)), this, TQ_SLOT(slotEntries(TDEIO::Job *, const TDEIO::UDSEntryList &)));
        connect(job, TQ_SIGNAL(result(TDEIO::Job *)), this, TQ_SLOT(slotListResult(TDEIO::Job *)));
    }
}

void SQ_TreeViewMenu::slotEntries(TDEIO::Job *, const TDEIO::UDSEntryList &list)
{
    TDEIO::UDSEntryListConstIterator itEnd = list.end();
    TQString suff;
    KURL u;

    static const TQString &dot    = TDEGlobal::staticQString(".");
    static const TQString &dotdot = TDEGlobal::staticQString("..");

    // go through list of TDEIO::UDSEntrys
    for(TDEIO::UDSEntryListConstIterator it = list.begin(); it != itEnd; ++it)
    {
        TDEIO::UDSEntry entry = *it;
        TDEIO::UDSEntry::ConstIterator itEnd = entry.end();

        for(TDEIO::UDSEntry::ConstIterator it = entry.begin(); it != itEnd; ++it)
        {
            if((*it).m_uds == TDEIO::UDS_NAME)
            {
                suff = (*it).m_str;

                if(suff != dot && suff != dotdot)
                {
                    u = m_url;
                    u.addPath(suff);
                    urlstodel.append(u);
                }

                break;
            }
        }
    }
}

void SQ_TreeViewMenu::slotListResult(TDEIO::Job *job)
{
    if(!job) return;

    if(job->error())
        job->showErrorDialog(KSquirrel::app());
    else if(!urlstodel.isEmpty())
    {
        TDEIO::Job *job = TDEIO::del(urlstodel);
        connect(job, TQ_SIGNAL(result(TDEIO::Job *)), this, TQ_SLOT(slotDirectoryResult(TDEIO::Job *)));
    }
}

void SQ_TreeViewMenu::slotDirectoryResult(TDEIO::Job *job)
{
    if(job && job->error())
        job->showErrorDialog(KSquirrel::app());
}

void SQ_TreeViewMenu::slotDirectoryProperties()
{
    if(!m_url.isEmpty())
        (void)new KPropertiesDialog(m_url, KSquirrel::app());
}

#include "sq_treeviewmenu.moc"
