/***************************************************************************
 *   Copyright (C) by                                                      *
 *     - 2005: Christian Leh <moodwrod@web.de>                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCALER_H
#define SCALER_H

#include <tqpoint.h>
#include <tqimage.h>
#include <tqfont.h>

class Scaler
{
  private:
    TQSize mBaseResolution;  
    TQSize mTargetResolution;

  public:
    Scaler(TQSize baseResolution, TQSize targetResolution);

    const TQSize& baseResolution() { return mBaseResolution; };
    const TQSize& targetResolution() { return mTargetResolution; };

    void autoCoords(TQPoint* pt, const TQFont& f, const TQString& s);
    void autoCoords(TQPoint* pt, const TQSize s);
    void scaleCoords(TQPoint* pt);
    bool scaleSize(TQImage* i);
    bool scaleSize(TQFont* f);

    bool resolutionDiff();
  
    int center(int width, int size, int offset = 0);
    int intIt(const float v);
};

#endif
