/***************************************************************************
                          showlistviewitem.cpp  -  description
                             -------------------
    begin                : Son Apr 21 2002
    copyright            : (C) 2002 by Eggert Ehmke
    email                : eggert.ehmke@berlin.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "showlistviewitem.h"

ShowListViewItem::ShowListViewItem (TQListView * parent,
                  ShowListViewItem* after):
TQListViewItem (parent, after)
{}

ShowListViewItem::ShowListViewItem( TQListView * parent ) :
    TQListViewItem( parent )
{
}

ShowListViewItem::~ShowListViewItem()
{}

TQString ShowListViewItem::key (int column, bool /*ascending*/) const
{
	switch (column)
	{
	case _colNumber:
		return text (_colAccount) + text (_colNumber);
	case _colDate:
		return m_time;
	default:
		return text (column);
	}
}

/**
  * reimplement compare to solve bug #856005
  * standard compare is locale dependant
  */
int ShowListViewItem::compare( TQListViewItem *i, int col,
                               bool ascending ) const
{
  if( col == _colNumber )
  {
    return text( _colNumber ).toInt() - i->text( _colNumber ).toInt();
  }
  else if( col == _colSize )
  {
    return text( _colSize ).toInt() - i->text( _colSize ).toInt();
  }
  else
    return key( col, ascending ).compare( i->key( col, ascending) );
}

void ShowListViewItem::setNumber (const TQString& number)
{
  setText (_colNumber, number);
}

void ShowListViewItem::setAccount(const TQString& account)
{
  setText (_colAccount, account);
}

void ShowListViewItem::setFrom(const TQString& from)
{
  setText (_colFrom, from);
}

void ShowListViewItem::setTo(const TQString& to)
{
  setText (_colTo, to);
}

void ShowListViewItem::setSubject(const TQString& subject)
{
  setText (_colSubject, subject);
}

void ShowListViewItem::setDate(const TQString& date)
{
  setText (_colDate, date);
}

void ShowListViewItem::setSize(const TQString& size)
{
  setText (_colSize, size);
}

void ShowListViewItem::setContent(const TQString& content)
{
  setText (_colContent, content);
}

void ShowListViewItem::setState(const TQString& state)
{
  setText (_colState, state);
}

void ShowListViewItem::setTime (const TQString& time)
{
	m_time = time;
}

