//
// C++ Implementation: configaccounts
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "configaccounts.h"

typedef KGenericFactory<ConfigAccounts, TQWidget> ConfigAccountsFactory;

K_EXPORT_COMPONENT_FACTORY( kcm_kshowmailconfigaccounts, ConfigAccountsFactory(
    "kcm_kshowmailconfigaccounts" ) );

ConfigAccounts::ConfigAccounts( TQWidget * parent, const char * name, const TQStringList & args )
  : TDECModule( ConfigAccountsFactory::instance(), parent, args )
{
  //set the module name
  if ( !name )
    setName( "configaccounts" );

  //build GUI
  //---------

  //main layout
  TQHBoxLayout* layMain = new TQHBoxLayout( this, 0, 10 );

  //account list view
  AccountListView = new TDEListView( this, "AccountListView" );
  AccountListView->addColumn( i18n( "Name" ) );
  AccountListView->setColumnWidthMode( 0, TQListView::Maximum );
  AccountListView->setResizeMode( TQListView::LastColumn );

  layMain->addWidget( AccountListView );

  //button layout
  TQVBoxLayout* layButtons = new TQVBoxLayout( layMain );

  //Buttons
  btnAdd = new KPushButton( KStdGuiItem::add(), this, "btnAdd" );
  layButtons->addWidget( btnAdd );
  btnAdd->setSizePolicy( TQSizePolicy::Preferred, TQSizePolicy::Maximum );
  connect( btnAdd, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotAdd() ) );

  btnEdit = new KPushButton( KStdGuiItem::configure(), this, "btnEdit" );
  layButtons->addWidget( btnEdit );
  btnEdit->setSizePolicy( TQSizePolicy::Preferred, TQSizePolicy::Maximum );
  connect( btnEdit, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotEdit() ) );

  btnRemove = new KPushButton( KStdGuiItem::remove(), this, "btnRemove" );
  layButtons->addWidget( btnRemove );
  btnRemove->setSizePolicy( TQSizePolicy::Preferred, TQSizePolicy::Maximum );
  connect( btnRemove, TQ_SIGNAL( clicked() ), this, TQ_SLOT( slotRemove() ) );

  layButtons->addItem( new TQSpacerItem( 1, 1, TQSizePolicy::Minimum, TQSizePolicy::Expanding ) );


  //get application config object (kshowmailrc)
  config = tdeApp->config();

  //load configured values
  load();

}

ConfigAccounts::~ConfigAccounts()
{
}

void ConfigAccounts::load()
{
  //get list of account names
  config->setGroup( CONFIG_GROUP_ACCOUNTS );
  TQStringList accounts = config->readListEntry( CONFIG_ENTRY_ACCOUNTS_LIST, TQStringList() );

  //create list view items and order accounts to load their config
  for( TQStringList::Iterator it = accounts.begin(); it != accounts.end(); ++it )
  {
    //create item
    AccountSetupItem* item = new AccountSetupItem( AccountListView, *it );

    //load item config
    item->load();

  }
}

void ConfigAccounts::save()
{
  config->setGroup( CONFIG_GROUP_ACCOUNTS );

  //get old account list from config file to remove old account entries
  TQStringList oldList = config->readListEntry( CONFIG_ENTRY_ACCOUNTS_LIST, TQStringList() );

  //remove all account entries
  for( TQStringList::Iterator it = oldList.begin(); it != oldList.end(); ++it )
  {
    config->deleteGroup( *it );
  }


  //write a list with all account names into the config
  TQStringList accounts;       //list of all account names
  AccountSetupItem* item = NULL;
  int index = 0;

  do  //get all account names
  {
    item = (AccountSetupItem*)( AccountListView->itemAtIndex( index ) );
    if( item != NULL )
    {
      index++;
      accounts.append( item->getAccountName() );
    }
  } while( item != NULL );

  config->writeEntry( CONFIG_ENTRY_ACCOUNTS_LIST, accounts ); //write list of account names

  //order the items to save their configuration
  index = 0;
  item = NULL;
  do
  {
    item = (AccountSetupItem*)( AccountListView->itemAtIndex( index ) );
    if( item != NULL )
    {
      index++;
      item->save();
    }
  } while( item != NULL );

  //write configuration to disk
  config->sync();
}

void ConfigAccounts::defaults()
{
}

void ConfigAccounts::slotChanged( )
{
  TDECModule::changed();
}

void ConfigAccounts::slotAdd( )
{
  //open setup dialog
  AccountSetupDialog* dlg = new AccountSetupDialog( this, AccountListView, NULL );
  int res = dlg->exec();

  //inform application setup dialog about changes
  if( res == KDialogBase::Accepted )
    slotChanged();

  //delete dialog
  delete dlg;
}

void ConfigAccounts::slotEdit( )
{
  //get selected item
  AccountSetupItem* account = (AccountSetupItem*)( AccountListView->selectedItem() );

  //test item
  if( account == NULL )
    return;

  //open dialog
  AccountSetupDialog* dlg = new AccountSetupDialog( this, AccountListView, account );
  int res = dlg->exec();

  //inform application setup dialog about changes
  if( res == KDialogBase::Accepted )
    slotChanged();

  //delete dialog
  delete dlg;
}

void ConfigAccounts::slotRemove( )
{
  //get selected item
  AccountSetupItem* account = (AccountSetupItem*)( AccountListView->selectedItem() );

  //test item
  if( account == NULL )
    return;

  //remove item
  int result = KMessageBox::questionYesNo( this, i18n( "Do you really want to remove account %1?").arg( account->getAccountName() ) );
  if( result == KMessageBox::Yes )
  {
    delete account;
    slotChanged();
  }
}


#include "configaccounts.moc"
