//
// C++ Implementation: filterlogviewdeleteditem
//
// Description:
//
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "filterlogviewdeleteditem.h"

FilterLogViewDeletedItem::FilterLogViewDeletedItem( TDEListView* parent )
 : TDEListViewItem( parent )
{
}


FilterLogViewDeletedItem::~FilterLogViewDeletedItem()
{
}

void FilterLogViewDeletedItem::setValues( TQDateTime date, TQString sender, TQString account, TQString subject )
{
  //store values
  this->date = date;
  this->sender = sender;
  this->account = account;
  this->subject = subject;

  //set column text
  setText( ColDate, date.toString( TQt::LocalDate ) );
  setText( ColSender, sender );
  setText( ColAccount, account );
  setText( ColSubject, subject );
}

int FilterLogViewDeletedItem::compare( TQListViewItem * i, int col, bool ascending ) const
{
  if( col == ColDate )
  {
    if( this->date < ((FilterLogViewDeletedItem*)i)->getDate() ) return -1;
    if( this->date > ((FilterLogViewDeletedItem*)i)->getDate() ) return 1;
    else return 0;
  }
  else
    return key( col, ascending ).compare( i->key( col, ascending) );

}

TQDateTime FilterLogViewDeletedItem::getDate( )
{
  return date;
}



