#################################################
#
#  (C) 2019 Slávek Banko
#  slavek.banko (AT) axis.cz
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 3
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_compiler_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support #########

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( )


##### check headers #############################

check_function_exists( strlcat HAVE_STRLCAT )
check_symbol_exists( strlcat "string.h" HAVE_STRLCAT_PROTO )
check_function_exists( strlcpy HAVE_STRLCPY )
check_symbol_exists( strlcpy "string.h" HAVE_STRLCPY_PROTO )


##### check libraries ###########################

pkg_search_module( PILOTLINK pilot-link )
if( NOT PILOTLINK_FOUND)
  tde_message_fatal( "PilotLink is required but not found on your system." )
endif( )
