/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2002 Dario Abatianni <eisfuchs@tigress.com>
  Copyright (C) 2007-2007 Eike Hein <hein@kde.org>
*/

#ifndef KONV_IFACE_H
#define KONV_IFACE_H

#include "ignore.h"

#include <tqobject.h>
#include <tqstringlist.h>

#include <dcopobject.h>


class KonvIface : virtual public DCOPObject
{
    K_DCOP

        k_dcop:
    virtual void setAway(const TQString &awaymessage) = 0;
    virtual void setBack() = 0;
    virtual void sayToAll(const TQString &message) = 0;
    virtual void actionToAll(const TQString &message) = 0;

    virtual void raw(const TQString& server,const TQString& command) = 0;
    virtual void say(const TQString& server,const TQString& target,const TQString& command) = 0;
    virtual void info(const TQString& string) = 0;
    virtual void debug(const TQString& string) = 0;
    virtual void error(const TQString& string) = 0;
    virtual void insertMarkerLine() = 0;
    virtual void connectToServer(const TQString& address, int port, const TQString& channel, const TQString& password) = 0;
    virtual TQString getNickname (const TQString &serverid) = 0;
    virtual TQString getAnyNickname () = 0;
    virtual TQStringList listServers() = 0;
    virtual TQStringList listConnectedServers() = 0;
    virtual TQString getChannelEncoding(const TQString& server, const TQString& channel) = 0;

    virtual void setScreenSaverStarted() = 0;
    virtual void setScreenSaverStopped() = 0;
};

class KonvIdentityIface : virtual public DCOPObject
{
    K_DCOP
        k_dcop:

    virtual void setrealName(const TQString &identity, const TQString& name) = 0;
    virtual TQString getrealName(const TQString &identity) = 0;
    virtual void setIdent(const TQString &identity, const TQString& ident) = 0;
    virtual TQString getIdent(const TQString &identity) = 0;

    virtual void setNickname(const TQString &identity, int index,const TQString& nick) = 0;
    virtual TQString getNickname(const TQString &identity, int index) = 0;

    virtual void setBot(const TQString &identity, const TQString& bot) = 0;
    virtual TQString getBot(const TQString &identity) = 0;
    virtual void setPassword(const TQString &identity, const TQString& password) = 0;
    virtual TQString getPassword(const TQString &identity) = 0;

    virtual void setNicknameList(const TQString &identity, const TQStringList& newList) = 0;
    virtual TQStringList getNicknameList(const TQString &identity) = 0;

    virtual void setQuitReason(const TQString &identity, const TQString& reason) = 0;
    virtual TQString getQuitReason(const TQString &identity) = 0;
    virtual void setPartReason(const TQString &identity, const TQString& reason) = 0;
    virtual TQString getPartReason(const TQString &identity) = 0;
    virtual void setKickReason(const TQString &identity, const TQString& reason) = 0;
    virtual TQString getKickReason(const TQString &identity) = 0;

    virtual void setShowAwayMessage(const TQString &identity, bool state) = 0;
    virtual bool getShowAwayMessage(const TQString &identity) = 0;

    virtual void setAwayMessage(const TQString &identity, const TQString& message) = 0;
    virtual TQString getAwayMessage(const TQString &identity) = 0;
    virtual void setReturnMessage(const TQString &identity, const TQString& message) = 0;
    virtual TQString getReturnMessage(const TQString &identity) = 0;

    virtual TQStringList listIdentities() = 0;
};
#endif
