/*
  begin:     Mit Aug 7 2002
  copyright: (C) 2002 by Dario Abatianni
  email:     eisfuchs@tigress.com
*/
// Copyright (C) 2004-2007 Shintaro Matsuoka <shin@shoegazed.org>
// Copyright (C) 2004,2005 John Tapsell <john@geola.co.uk>

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

#ifndef DCCTRANSFERPANELITEM_H
#define DCCTRANSFERPANELITEM_H

#include "dcctransfer.h"

#include <tqdatetime.h>

#include <tdelistview.h>
#include <kurl.h>
#include <tdeio/global.h>


class TQStringList;
class TQTimer;

class KProgress;

namespace TDEIO
{
    class Job;
}

class DccTransferPanel;

class DccTransferPanelItem : public TQObject, public TDEListViewItem
{
    TQ_OBJECT
  

    public:
        DccTransferPanelItem( DccTransferPanel* panel, DccTransfer* transfer );
        virtual ~DccTransferPanelItem();

        virtual void paintCell( TQPainter* painter, const TQColorGroup& colorgroup, int column, int width, int alignment );

        virtual int compare( TQListViewItem* i, int col, bool ascending ) const;

        void runFile();
        void openFileInfoDialog();

        DccTransfer* transfer() const { return m_transfer; }

        // called from updateView()
        TQString getTypeText()                                  const;
        TQPixmap getTypeIcon()                                  const;
        TQPixmap getStatusIcon()                                const;
        TQString getStatusText()                                const;
        TQString getFileSizePrettyText()                        const;
        TQString getPositionPrettyText( bool detailed = false ) const;
        TQString getTimeLeftPrettyText()                        const;
        TQString getAverageSpeedPrettyText()                    const;
        TQString getCurrentSpeedPrettyText()                    const;
        TQString getSenderAddressPrettyText()                   const;

        static TQString getSpeedPrettyText( transferspeed_t speed );
        static TQString secToHMS( long sec );

    private slots:
        void slotStatusChanged( DccTransfer* transfer, int newStatus, int oldStatus );
        void updateView();

    private:
        DccTransferPanel* m_panel;
        DccTransfer* m_transfer;
        bool m_isTransferInstanceBackup;

    private slots:
        void startAutoViewUpdate();
        void stopAutoViewUpdate();

        void backupTransferInfo( DccTransfer* transfer );

    private:
        void updateTransferInfo();
        void updateTransferMeters();

        void showProgressBar();                   // called from printCell()

        // UI
        TQTimer* m_autoUpdateViewTimer;
        KProgress* m_progressBar;
};

#endif  // DCCTRANSFERPANELITEM_H
