/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
*/

/*
  Copyright (C) 2008 Eike Hein <hein@kde.org>
*/

#ifndef AWAYMANAGER_H
#define AWAYMANAGER_H


#include <tqobject.h>
#include <tqdatetime.h>


class ConnectionManager;

class TQTimer;


struct AwayManagerPrivate;


class AwayManager : public TQObject
{
    TQ_OBJECT
  

    public:
        explicit AwayManager(TQObject* parent = 0);
        ~AwayManager();


    public slots:
        void identitiesChanged();

        void identityOnline(int identityId);
        void identityOffline(int identityId);

        void requestAllAway(const TQString& reason = "");
        void requestAllUnaway();

        void setManagedIdentitiesAway();
        void setManagedIdentitiesUnaway();

        void toggleGlobalAway(bool away);
        void updateGlobalAwayAction(bool away);


    private slots:
        void checkActivity();


    private:
        void toggleTimer();
        bool Xactivity();

        void implementIdleAutoAway(bool activity);

        AwayManagerPrivate* d;

        TQTime m_idleTime;
        TQTimer* m_activityTimer;

        TQValueList<int> m_identitiesOnAutoAway;

        ConnectionManager* m_connectionManager;
};

#endif
