#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <KoStore.h>
#include <tqtextbrowser.h>
#include <tqstringlist.h>
#include <tqbuffer.h>
#include <tqclipboard.h>

class StoreDropTest : public TQTextBrowser
{
public:
    StoreDropTest( TQWidget* parent );
protected:
    virtual void contentsDragEnterEvent( TQDragEnterEvent * e );
    virtual void contentsDragMoveEvent( TQDragMoveEvent * e );
    virtual void contentsDropEvent( TQDropEvent * e );
    virtual void keyPressEvent( TQKeyEvent * e );
    virtual void paste();
private:
    bool processMimeSource( TQMimeSource* ev );
    void showZipContents( TQByteArray data, const char* mimeType, bool oasis );
    TQString loadTextFile( KoStore* store, const TQString& fileName );
};

int main( int argc, char** argv )
{
    TDEApplication::disableAutoDcopRegistration();
    TDECmdLineArgs::init(argc, argv, "storedroptest", 0, 0, 0, 0);
    TDEApplication app;

    StoreDropTest* window = new StoreDropTest( 0 );
    window->resize( 500, 500 );
    window->show();

    TQObject::connect( tqApp, TQ_SIGNAL( lastWindowClosed() ), tqApp, TQ_SLOT( quit() ) );
    return app.exec();
}

StoreDropTest::StoreDropTest( TQWidget* parent )
    : TQTextBrowser( parent )
{
    setText( "KoStore drop/paste test\nDrop or paste a selection from a KOffice application into this widget to see the ZIP contents" );
    setAcceptDrops( true );
}

void StoreDropTest::contentsDragEnterEvent( TQDragEnterEvent * ev )
{
    ev->acceptAction();
}

void StoreDropTest::contentsDragMoveEvent( TQDragMoveEvent * ev )
{
    ev->acceptAction();
}

void StoreDropTest::keyPressEvent( TQKeyEvent * e )
{
    if ( ( ( e->state() & ShiftButton ) && e->key() == Key_Insert ) ||
         ( ( e->state() & ControlButton ) && e->key() == Key_V ) )
        paste();
    //else
    //    TQTextBrowser::keyPressEvent( e );
}

void StoreDropTest::paste()
{
    tqDebug( "paste" );
    TQMimeSource* m = TQApplication::clipboard()->data();
    if ( !m )
        return;
    processMimeSource( m );
}

void StoreDropTest::contentsDropEvent( TQDropEvent *ev )
{
    if ( processMimeSource( ev ) )
        ev->acceptAction();
    else
        ev->ignore();
}

bool StoreDropTest::processMimeSource( TQMimeSource* ev )
{
    const TQCString acceptMimeType = "application/vnd.oasis.opendocument.";
    const char* fmt;
    TQStringList formats;
    for (int i=0; (fmt = ev->format(i)); i++) {
        formats += fmt;
        bool oasis = TQString( fmt ).startsWith( acceptMimeType );
        if ( oasis || TQString( fmt ) == "application/x-kpresenter" ) {
            TQByteArray data = ev->encodedData( fmt );
            showZipContents( data, fmt, oasis );
            return true;
        }
    }
    setText( "No acceptable format found. All I got was:\n" + formats.join( "\n" ) );
    return false;
}

void StoreDropTest::showZipContents( TQByteArray data, const char* mimeType, bool oasis )
{
    if ( data.isEmpty() ) {
        setText( "No data!" );
        return;
    }
    TQBuffer buffer( data );
    KoStore * store = KoStore::createStore( &buffer, KoStore::Read );
    if ( store->bad() ) {
        setText( "Invalid ZIP!" );
        return;
    }
    store->disallowNameExpansion();

    TQString txt = TQString( "Valid ZIP file found for format " ) + mimeType + "\n";

    if ( oasis ) {
        txt += loadTextFile( store, "content.xml" );
        txt += loadTextFile( store, "styles.xml" );
        txt += loadTextFile( store, "settings.xml" );
        txt += loadTextFile( store, "META-INF/manifest.xml" );
    } else {
        txt += loadTextFile( store, "maindoc.xml" );
    }
    setText( txt );
}

TQString StoreDropTest::loadTextFile( KoStore* store, const TQString& fileName )
{
    if ( !store->open( fileName ) )
        return TQString( "%1 not found\n" ).arg( fileName );

    TQByteArray data = store->device()->readAll();
    store->close();
    TQString txt = TQString( "Found %1: \n" ).arg( fileName );
    txt += TQString::fromUtf8( data.data(), data.size() );
    txt += "\n";
    return txt;
}
