/***************************************************************************
 * exception.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "object.h"
#include "exception.h"

//#include <tqstring.h>
//#include <ksharedptr.h>

using namespace Kross::Api;

Exception::Exception(const TQString& error, long lineno)
    : Object()
    , m_error(error)
    , m_lineno(lineno)
{
    krosswarning( TQString("Kross::Api::Exception error='%1' lineno='%3'").arg(m_error).arg(m_lineno) );
}

Exception::~Exception()
{
}

const TQString Exception::getClassName() const
{
    return "Kross::Api::Exception";
}

const TQString Exception::toString()
{
    return (m_lineno != -1)
        ? TQString("Exception at line %1: %2").arg(m_lineno).arg(m_error)
        : TQString("Exception: %1").arg(m_error);
}

const TQString Exception::getError() const
{
    return m_error;
}

const TQString Exception::getTrace() const
{
    return m_trace;
}

void Exception::setTrace(const TQString& tracemessage)
{
    m_trace = tracemessage;
}

long Exception::getLineNo() const
{
    return m_lineno;
}

