/* This file is part of the KDE project
   Copyright (C) 2005 Peter Simonsson <psn@linux.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/
#ifndef KOOPENPANE_H
#define KOOPENPANE_H

#include <tqlistview.h>

#include <koOpenPaneBase.h>

class KoCustomDocumentCreator;
class TDEConfig;
class KoTemplateGroup;
class KoOpenPanePrivate;
class TDEInstance;
class TQPixmap;
class TDEListViewItem;
class KoTemplatesPane;
class KoDetailsPaneBase;

class KoOpenPane : public KoOpenPaneBase
{
  TQ_OBJECT
  

  public:
    /**
     * Constructor
     * @param parent the parent widget
     * @param instance the TDEInstance to be used for TDEConfig data
     * @param templateType the template-type (group) that should be selected on creation.
     */
    KoOpenPane(TQWidget *parent, TDEInstance* instance, const TQString& templateType = TQString());
    virtual ~KoOpenPane();

    TQListViewItem* addPane(const TQString& title, const TQString& icon, TQWidget* widget, int sortWeight);
    TQListViewItem* addPane(const TQString& title, const TQPixmap& icon, TQWidget* widget, int sortWeight);

    /**
     * If the application has a way to create a document not based on a template, but on user
     * provided settings, the widget showing these gets set here.
     * @see KoDocument::createCustomDocumentWidget()
     * @param widget the widget.
     */
    void setCustomDocumentWidget(TQWidget *widget);

  protected slots:
    void showOpenFileDialog();

    void selectionChanged(TQListViewItem* item);
    void itemClicked(TQListViewItem* item);

    /// Saves the splitter sizes for KoDetailsPaneBase based panes
    void saveSplitterSizes(KoDetailsPaneBase* sender, const TQValueList<int>& sizes);

  signals:
    void openExistingFile(const TQString&);
    void openTemplate(const TQString&);

    /// Emitted when the always use template has changed
    void alwaysUseChanged(KoTemplatesPane* sender, const TQString& alwaysUse);

    /// Emitted when one of the detail panes have changed it's splitter
    void splitterResized(KoDetailsPaneBase* sender, const TQValueList<int>& sizes);

  protected:
    void initRecentDocs();
     /**
      * Populate the list with all templates the user can choose.
      * @param templateType the template-type (group) that should be selected on creation.
      */
    void initTemplates(const TQString& templateType);

  private:
    KoOpenPanePrivate* d;
};

#endif //KOOPENPANE_H
