/* This file is part of the KDE project
   Copyright (C) 2000 David Faure <faure@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include "KoDocument.h"
#include "KoDocumentIface.h"
#include "KoDocumentInfoDlg.h"
#include "KoDocumentInfo.h"
#include "KoView.h"
#include <tdeapplication.h>
#include <dcopclient.h>
#include <kdcopactionproxy.h>
#include <tdeaction.h>
#include <kdebug.h>
#include <kdcoppropertyproxy.h>

//static
TQCString KoDocumentIface::newIfaceName()
{
    static int s_docIFNumber = 0;
    TQCString name; name.setNum( s_docIFNumber++ ); name.prepend("Document-");
    return name;
}

KoDocumentIface::KoDocumentIface( KoDocument * doc, const char * name )
    : DCOPObject( name ? TQCString(name) : newIfaceName() )
{
  m_pDoc = doc;
  m_actionProxy = new KDCOPActionProxy( doc->actionCollection(), this );
}

KoDocumentIface::~KoDocumentIface()
{
    delete m_actionProxy;
}

void KoDocumentIface::openURL( TQString url )
{
  m_pDoc->openURL( KURL( url ) );
}

bool KoDocumentIface::isLoading()
{
  return m_pDoc->isLoading();
}

TQString KoDocumentIface::url()
{
  return m_pDoc->url().url();
}

bool KoDocumentIface::isModified()
{
  return m_pDoc->isModified();
}

int KoDocumentIface::viewCount()
{
  return m_pDoc->viewCount();
}

DCOPRef KoDocumentIface::view( int idx )
{
  TQPtrList<KoView> views = m_pDoc->views();
  KoView *v = views.at( idx );
  if ( !v )
    return DCOPRef();

  DCOPObject *obj = v->dcopObject();

  if ( !obj )
    return DCOPRef();

  return DCOPRef( tdeApp->dcopClient()->appId(), obj->objId() );
}

DCOPRef KoDocumentIface::action( const TQCString &name )
{
    return DCOPRef( tdeApp->dcopClient()->appId(), m_actionProxy->actionObjectId( name ) );
}

QCStringList KoDocumentIface::actions()
{
    QCStringList res;
    TQValueList<TDEAction *> lst = m_actionProxy->actions();
    TQValueList<TDEAction *>::ConstIterator it = lst.begin();
    TQValueList<TDEAction *>::ConstIterator end = lst.end();
    for (; it != end; ++it )
        res.append( (*it)->name() );

    return res;
}

TQMap<TQCString,DCOPRef> KoDocumentIface::actionMap()
{
    return m_actionProxy->actionMap();
}

void KoDocumentIface::save()
{
    m_pDoc->save();
}

void KoDocumentIface::saveAs( const TQString & url )
{
    m_pDoc->saveAs( KURL( url ) );
    m_pDoc->waitSaveComplete(); // see ReadWritePart
}

void KoDocumentIface::setOutputMimeType( const TQCString & mimetype )
{
    m_pDoc->setOutputMimeType( mimetype );
}

TQString KoDocumentIface::documentInfoAuthorName() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->fullName();
}

TQString KoDocumentIface::documentInfoEmail() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->email();
}

TQString KoDocumentIface::documentInfoCompanyName() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->company();
}

TQString KoDocumentIface::documentInfoTelephone() const
{
    kdDebug()<<" Keep compatibility with koffice <= 1.3 : use documentInfoTelephoneWork\n";
    return documentInfoTelephoneWork();
}

TQString KoDocumentIface::documentInfoTelephoneWork() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->telephoneWork();
}

TQString KoDocumentIface::documentInfoTelephoneHome() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->telephoneHome();
}


TQString KoDocumentIface::documentInfoFax() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->fax();

}
TQString KoDocumentIface::documentInfoCountry() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->country();

}
TQString KoDocumentIface::documentInfoPostalCode() const
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->postalCode();

}
TQString KoDocumentIface::documentInfoCity() const
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->city();

}

TQString KoDocumentIface::documentInfoInitial() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->initial();
}

TQString KoDocumentIface::documentInfoAuthorPostion() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->position();
}


TQString KoDocumentIface::documentInfoStreet() const
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return authorPage->street();

}

TQString KoDocumentIface::documentInfoTitle() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return aboutPage->title();

}

TQString KoDocumentIface::documentInfoAbstract() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return aboutPage->abstract();
}

TQString KoDocumentIface::documentInfoKeywords() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return aboutPage->keywords();
}

TQString KoDocumentIface::documentInfoSubject() const
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
        return TQString();
    }
    else
        return aboutPage->subject();
}
void KoDocumentIface::setDocumentInfoKeywords(const TQString & text )
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
    }
    else
       aboutPage->setKeywords(text);
}

void KoDocumentIface::setDocumentInfoSubject(const TQString & text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
    }
    else
       aboutPage->setSubject(text);
}

void KoDocumentIface::setDocumentInfoAuthorName(const TQString & text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setFullName(text);

}

void KoDocumentIface::setDocumentInfoEmail(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setEmail(text);
}

void KoDocumentIface::setDocumentInfoCompanyName(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setCompany(text);
}

void KoDocumentIface::setDocumentInfoAuthorPosition(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setPosition(text);
}


void KoDocumentIface::setDocumentInfoTelephone(const TQString &text)
{
    kdDebug()<<"Keep compatibility with koffice <= 1.3 : use setDocumentInfoTelephoneWork\n";
    setDocumentInfoTelephoneWork(text);
}

void KoDocumentIface::setDocumentInfoTelephoneWork(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setTelephoneWork(text);
}

void KoDocumentIface::setDocumentInfoTelephoneHome(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setTelephoneHome(text);
}


void KoDocumentIface::setDocumentInfoFax(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setFax(text);
}

void KoDocumentIface::setDocumentInfoCountry(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setCountry(text);

}

void KoDocumentIface::setDocumentInfoTitle(const TQString & text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
    }
    else
        aboutPage->setTitle(text);
}

void KoDocumentIface::setDocumentInfoPostalCode(const TQString &text)
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setPostalCode(text);

}


void KoDocumentIface::setDocumentInfoCity(const TQString & text)
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setCity(text);
}

void KoDocumentIface::setDocumentInfoInitial(const TQString & text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setInitial(text);
}


void KoDocumentIface::setDocumentInfoStreet(const TQString &text)
{
        KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAuthor * authorPage = static_cast<KoDocumentInfoAuthor *>(info->page( "author" ));
    if ( !authorPage )
    {
        kdWarning() << "Author information not found in documentInfo !" << endl;
    }
    else
        authorPage->setStreet(text);

}


void KoDocumentIface::setDocumentInfoAbstract(const TQString &text)
{
    KoDocumentInfo * info = m_pDoc->documentInfo();
    KoDocumentInfoAbout * aboutPage = static_cast<KoDocumentInfoAbout *>(info->page( "about" ));
    if ( !aboutPage )
    {
        kdWarning() << "'About' page not found in documentInfo !" << endl;
    }
    else
       aboutPage->setAbstract(text);
}

QCStringList KoDocumentIface::functionsDynamic()
{
    return DCOPObject::functionsDynamic() + KDCOPPropertyProxy::functions( m_pDoc );
}

bool KoDocumentIface::processDynamic( const TQCString &fun, const TQByteArray &data,
                                      TQCString& replyType, TQByteArray &replyData )
{
    if ( KDCOPPropertyProxy::isPropertyRequest( fun, m_pDoc ) )
        return KDCOPPropertyProxy::processPropertyRequest( fun, data, replyType, replyData, m_pDoc );

    return DCOPObject::processDynamic( fun, data, replyType, replyData );
}

