/* This file is part of the KDE project
   Original file (KWMailMergeDataBase.h): Copyright (C) 1998, 1999 Reginald Stadlbauer <reggie@kde.org>
   Copyright (C) 2001 Joseph Wenninger <jowenn@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef _SERIALLETTER_CLASSIC_PLUGIN_H_
#define _SERIALLETTER_CLASSIC_PLUGIN_H_

#include <tqdom.h>
#include <tqlistview.h>
#include <kdialogbase.h>
#include <KoCustomVariablesDia.h>
#include "KWMailMergeDataSource.h"
#include <tqspinbox.h>

class TQHBox;
class TQVBox;
class TQPushButton;
class TQListBox;
class TQLabel;
class TQLineEdit;
class TQToolButton;

/******************************************************************
 *
 * Class: KWClassicSerialDataSource
 *
 ******************************************************************/
typedef TQValueList< DbRecord > Db;

class KWClassicSerialDataSource: public KWMailMergeDataSource
{
    TQ_OBJECT
  
    public:
    KWClassicSerialDataSource(TDEInstance *inst,TQObject *parent);
    ~KWClassicSerialDataSource();

    virtual void save( TQDomDocument &doc,TQDomElement&);
    virtual void load( TQDomElement& elem );
    virtual class TQString getValue( const class TQString &name, int record = -1 ) const;
    virtual int getNumRecords() const {
        return (int)db.count();
    }
    virtual  bool showConfigDialog(TQWidget *,int);
    virtual void refresh(bool){};

    protected:
    friend class KWClassicMailMergeEditor;
    friend class KWClassicMailMergeEditorList;

    void setValue( const TQString &name, const TQString &value, int record = -1 );
    void appendRecord();
    void addEntry( const TQString &name );
    void removeEntry( const TQString &name );
    void removeRecord( int i );
    Db db;
};

/******************************************************************
 *
 * Class: KWClassicMailMergeEditorListItem
 *
 ******************************************************************/

class KWClassicMailMergeEditorListItem : public TQListViewItem
{
public:
    KWClassicMailMergeEditorListItem( TQListView *parent );
    KWClassicMailMergeEditorListItem( TQListView *parent, TQListViewItem *after );
    virtual ~KWClassicMailMergeEditorListItem();

    virtual void setText( int i, const TQString &text );
    virtual TQString text( int i ) const;
    void setup();
    void update();

protected:
    TQLineEdit *editWidget;

};

/******************************************************************
 *
 * Class: KWClassicMailMergeEditorList
 *
 ******************************************************************/

class KWClassicMailMergeEditorList : public TQListView
{
    TQ_OBJECT
  

public:
    KWClassicMailMergeEditorList( TQWidget *parent, KWClassicSerialDataSource *db_ );
    virtual ~KWClassicMailMergeEditorList();

    void invalidateCurrentRecord();
    void updateItems();
    void displayRecord( int i );

    void setSorting( int, bool increasing = true ) {
        TQListView::setSorting( -1, increasing );
    }

protected slots:
    void columnSizeChange( int c, int os, int ns );
    void sectionClicked( int c );

protected:
    KWClassicSerialDataSource *db;
    int currentRecord;

};

/******************************************************************
 *
 * Class: KWClassicMailMergeEditor
 *
 ******************************************************************/

class KWClassicMailMergeEditor : public KDialogBase
{
    TQ_OBJECT
  

public:
    KWClassicMailMergeEditor( TQWidget *parent, KWClassicSerialDataSource *db_ );

protected:
    void resizeEvent( TQResizeEvent *e );
    void updateButton();

    TQSpinBox *records;
    KWClassicMailMergeEditorList *dbList;
    TQWidget *back;
    KWClassicSerialDataSource *db;

    TQToolButton *first;
    TQToolButton *back_;
    TQToolButton *forward;
    TQToolButton *finish;
    TQToolButton *newRecord;
    TQToolButton *newEntry;
    TQToolButton *deleteRecord;
    TQToolButton *deleteEntry;

protected slots:
    void changeRecord( int i );
    void addEntry();
    void addRecord();
    void removeEntry();
    void removeRecord();
    void firstRecord();
    void prevRecord();
    void nextRecord();
    void lastRecord();
};

#endif
