/*

 $Id: configdlg.cpp 466447 2005-10-02 17:54:10Z zander $

 KCalc

 Copyright (C) Bernd Johannes Wuebben
               wuebben@math.cornell.edu
	       wuebben@kde.org

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.

 */

#include "configdlg.h"

#include <tdelocale.h>
#include <kdialog.h>
#include <tqlayout.h>

// Undefine HAVE_LONG_DOUBLE for Beta 4 since RedHat 5.0 comes with a borken
// glibc

#ifdef HAVE_LONG_DOUBLE
#undef HAVE_LONG_DOUBLE
#endif

ConfigDlg::ConfigDlg(TQWidget *parent, const char *name, DefStruct *defstruct)
  : TQDialog(parent, name)
{
  defst = defstruct;

  TQVBoxLayout *lay1 = new TQVBoxLayout( this );
  lay1->setMargin( KDialog::marginHint() );
  lay1->setSpacing( KDialog::spacingHint() );

  box = new TQGroupBox(0, TQt::Vertical, i18n("Defaults"), this, "box");
  box->layout()->setSpacing(KDialog::spacingHint());
  box->layout()->setMargin(KDialog::marginHint());

  TQGridLayout *grid1 = new TQGridLayout(box->layout(),8,2);
  label1 = new TQLabel(box);
  label1->setText(i18n("Foreground color:"));
  grid1->addWidget(label1,0,0);

  button1 = new KColorButton( box, "button1" );
  grid1->addWidget(button1,0,1);
  button1->setColor( defst->forecolor );

  connect(button1 , TQ_SIGNAL( changed( const TQColor & ) ),
             this, TQ_SLOT( set_fore_color( const TQColor & ) ) );

  label2 = new TQLabel(box);
  grid1->addWidget(label2,1,0);
  label2->setText(i18n("Background color:"));

  button2 = new KColorButton( box, "button2" );
  grid1->addWidget(button2,1,1);
  button2->setColor( defst->backcolor );

  connect(button2 , TQ_SIGNAL( changed( const TQColor & ) ),
             this, TQ_SLOT( set_background_color( const TQColor & ) ) );


  //  connect(button2,TQ_SIGNAL(clicked()),this,TQ_SLOT(set_background_color()));


  label5 = new TQLabel(box);
  grid1->addWidget(label5,2,0);
  label5->setText(i18n("Precision:"));

  int maxprec;
#ifdef HAVE_LONG_DOUBLE
  maxprec = 16 ;
#else
  maxprec = 12 ;
#endif

  precspin = new TQSpinBox( box );
  precspin->setRange( 0, maxprec );
  grid1->addWidget(precspin,2,1);

  if( defst->precision <= maxprec)
    precspin->setValue(defst->precision);
  else
    precspin->setValue(maxprec);


  cb = new TQCheckBox(box);
  grid1->addWidget(cb,3,0);
  cb->setText(i18n("Set fixed precision at:"));
  if(defst->fixed)
    cb->setChecked(true);

  int fixprec;
#ifdef HAVE_LONG_DOUBLE
  fixprec = 14 ;
#else
  fixprec = 10 ;
#endif

  precspin2 = new TQSpinBox( box );
  precspin2->setRange(0,fixprec);
  grid1->addWidget(precspin2,3,1);

  if( defst->fixedprecision <= fixprec)
    precspin2->setValue(defst->fixedprecision);
  else
    precspin2->setValue(fixprec);



  cb2 = new TQCheckBox(box);
  grid1->addWidget(cb2,4,0);
  cb2->setText(i18n("Beep on error"));
  if(defst->beep)
    cb2->setChecked(true);


  stylegroup = new TQButtonGroup(box,"stylegroup");
  grid1->addMultiCellWidget(stylegroup,5,7,0,1);
  stylegroup->setFrameStyle(TQFrame::NoFrame);

  TQGridLayout *grid2 = new TQGridLayout(stylegroup,2,2,KDialog::marginHint(), KDialog::spacingHint());

  trigstyle = new TQRadioButton(i18n("Trigonometry mode"),stylegroup,"trigstyle");
  grid2->addWidget(trigstyle,0,0);
  trigstyle->adjustSize();
  trigstyle->setChecked(defst->style == 0 );

  statstyle = new TQRadioButton(i18n("Statistical mode"),stylegroup,"Stats");
  grid2->addWidget(statstyle,1,0);
  statstyle->adjustSize();
  statstyle->setChecked(defst->style == 1 );

  sheetstyle = new TQRadioButton(i18n("Sheet mode"),stylegroup,"Sheet");
  grid2->addWidget(sheetstyle,2,0);
  sheetstyle->adjustSize();

  sheetstyle->setChecked(defst->style == 2 );
  button3 = new TQPushButton(stylegroup);
  grid2->addWidget(button3,0,1);
  button3->setText(i18n("Help"));

  connect(button3,TQ_SIGNAL(clicked()),this,TQ_SLOT(help()));

  lay1->addWidget(box);
  connect(parent,TQ_SIGNAL(applyButtonPressed()),TQ_SLOT(okButton()));
}

void ConfigDlg::help()
{
}

void ConfigDlg::okButton()
{
  defst->precision = precspin->value();
  defst->fixedprecision = precspin2->value();
  defst->fixed = cb->isChecked();
  defst->beep = cb2->isChecked();


  if( trigstyle->isChecked())
    defst->style = 0;
  else if ( statstyle->isChecked() )
    defst->style = 1;
  else
    defst->style = 2;
}

void ConfigDlg::cancelbutton()
{
  reject();
}

void ConfigDlg::set_fore_color(const TQColor &_color)
{
        defst->forecolor=_color;
}

void ConfigDlg::set_background_color( const TQColor &_color )
{
        defst->backcolor=_color;
}

#include "configdlg.moc"
