/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef KFORMDESIGNERPIXMAPCOLLECTION_H
#define KFORMDESIGNERPIXMAPCOLLECTION_H

#include <tqobject.h>
#include <tqmap.h>
#include <tqpair.h>
#include <tqintdict.h>
#include <tqtoolbutton.h>

#include <kicontheme.h>
#include <kdialogbase.h>
#include <kiconview.h>
#include <kurl.h>

class TQPixmap;
class TDEIconView;
class TDEIconButton;
class KLineEdit;
class TQDomNode;

typedef TQMap<TQString, TQPair<TQString, int> > PixmapMap;

//! A class that store pixmaps (by path or by name for KDE icons)
class KEXIEXTWIDGETS_EXPORT PixmapCollection : public TQObject
{
	TQ_OBJECT
  

	public:
		PixmapCollection(const TQString &collectionName, TQObject *parent = 0, const char *name = 0);
		~PixmapCollection() {;}

		TQString addPixmapPath(const KURL &url);
		TQString addPixmapName(const TQString &name, int size = TDEIcon::SizeMedium);
		void removePixmap(const TQString &name);

		bool   contains(const TQString &name);
		TQPixmap  getPixmap(const TQString &name);

		void save(TQDomNode parentNode);
		void load(TQDomNode node);

		TQString collectionName() {return m_name; }

	signals:
		void itemRenamed(const TQString &oldName, const TQString &newName);
		void itemRemoved(const TQString &name);

	protected:
		TQString  m_name;
		PixmapMap  m_pixmaps;

	friend class PixmapCollectionEditor;
	friend class PixmapCollectionChooser;
};

//! A dialog to edit the contents of a PixmapCollection
class KEXIEXTWIDGETS_EXPORT PixmapCollectionEditor : public KDialogBase
{
	TQ_OBJECT
  

	public:
		PixmapCollectionEditor(PixmapCollection *collection, TQWidget *parent = 0);
		~PixmapCollectionEditor() {;}

	protected:
		TQPixmap getPixmap(const TQString &name);
		void createIconViewItem(const TQString &name);

	protected slots:
		void newItemByPath();
		void newItemByName();
		void removeItem();
		void renameItem();
		void renameCollectionItem(TQIconViewItem *item, const TQString &name);
		void displayMenu(TQIconViewItem *item, const TQPoint &p);

	private:
		enum { BNewItemPath = 101, BNewItemName, BDelItem};
		TDEIconView  *m_iconView;
		TQIntDict<TQToolButton>  m_buttons;
		PixmapCollection  *m_collection;
};

//! A dialog to choose an icon in a PixmapCollection
class KEXIEXTWIDGETS_EXPORT PixmapCollectionChooser : public KDialogBase
{
	TQ_OBJECT
  

	public:
		PixmapCollectionChooser(PixmapCollection *collection, const TQString &selectedItem, TQWidget *parent = 0);
		~PixmapCollectionChooser() {;}

		TQPixmap  pixmap();
		TQString  pixmapName();

	protected:
		TQPixmap getPixmap(const TQString &name);
	protected slots:
		virtual void slotUser1();

	private:
		PixmapCollection  *m_collection;
		TDEIconView  *m_iconView;
};

//! A simple dialog to choose a KDE icon
class KEXIEXTWIDGETS_EXPORT LoadIconDialog : public KDialogBase
{
	TQ_OBJECT
  

	public:
		LoadIconDialog(TQWidget *parent = 0);
		~LoadIconDialog() {;}

		int iconSize();
		TQString iconName();

	protected slots:
		void changeIconSize(int);
		void updateIconName(TQString);
		void setIcon(const TQString &);

	private:
		KLineEdit *m_nameInput;
		TDEIconButton *m_button;
};

//! A Special TDEIconViewItem that holds the name of its associated pixmap (to allow renaming)
class KEXIEXTWIDGETS_EXPORT PixmapIconViewItem : public TDEIconViewItem
{
	public:
		PixmapIconViewItem(TDEIconView *parent, const TQString &text, const TQPixmap &icon)
		: TDEIconViewItem(parent, text, icon)  { m_name = text; }
		~PixmapIconViewItem() {;}

		void setName(const TQString &name) { m_name = name; }
		TQString name() { return m_name;}

	private:
		TQString  m_name;
};

#endif
