/* This file is part of the KDE project
   Copyright (C) 2004 Cedric Pasteur <cedric.pasteur@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef STDWIDGETFACTORY_H
#define STDWIDGETFACTORY_H

#include <tqframe.h>

#include "widgetfactory.h"
#include "container.h"

class KFORMEDITOR_EXPORT KexiPictureLabel : public TQLabel
{
	TQ_OBJECT
  

	public:
		KexiPictureLabel(const TQPixmap &pix, TQWidget *parent, const char *name);
		~KexiPictureLabel(){;}

		virtual bool setProperty(const char *name, const TQVariant &value);
};

class KFORMEDITOR_EXPORT Line : public TQFrame
{
	TQ_OBJECT
  
	TQ_PROPERTY(Orientation orientation READ orientation WRITE setOrientation)

	public:
		Line(Orientation orient, TQWidget *parent, const char *name);
		~Line(){;}

		void setOrientation(Orientation orient);
		Orientation  orientation() const;
};

//! Factory for all basic widgets, including Spring (not containers)
class StdWidgetFactory : public KFormDesigner::WidgetFactory
{
	TQ_OBJECT
  

	public:
		StdWidgetFactory(TQObject *parent, const char *name, const TQStringList &args);
		~StdWidgetFactory();

		virtual TQWidget *createWidget(const TQCString &c, TQWidget *p, const char *n, 
			KFormDesigner::Container *container, int options = DefaultOptions);

		virtual bool createMenuActions(const TQCString &classname, TQWidget *w, TQPopupMenu *menu,
		   KFormDesigner::Container *container);
		virtual bool startEditing(const TQCString &classname, TQWidget *w,
			KFormDesigner::Container *container);
		virtual bool previewWidget(const TQCString &classname, TQWidget *widget,
			KFormDesigner::Container *container);
		virtual bool clearWidgetContent(const TQCString &classname, TQWidget *w);

		virtual bool saveSpecialProperty(const TQCString &classname,
			const TQString &name, const TQVariant &value, TQWidget *w,
			TQDomElement &parentNode, TQDomDocument &parent);
		virtual bool readSpecialProperty(const TQCString &classname, TQDomElement &node,
			TQWidget *w, KFormDesigner::ObjectTreeItem *item);
		virtual TQValueList<TQCString> autoSaveProperties(const TQCString &classname);

		virtual void setPropertyOptions( KFormDesigner::WidgetPropertySet& buf,
			 const KFormDesigner::WidgetInfo& info, TQWidget *w );

	public slots:
		void  editText();
		void  editListContents();

	protected:
		virtual bool isPropertyVisibleInternal(const TQCString &classname, TQWidget *w,
			const TQCString &property, bool isTopLevel);
		virtual bool changeText(const TQString &newText);
		virtual void resizeEditor(TQWidget *editor, TQWidget *widget, const TQCString &classname);
		void saveListItem(TQListViewItem *item, TQDomNode &parentNode, TQDomDocument &domDoc);
		void readListItem(TQDomElement &node, TQListViewItem *parent, TDEListView *listview);

	private:
//		KFormDesigner::Container *m_container;
//		TQWidget *m_widget;
};

#endif
