/* This file is part of the KDE project
   Copyright (C) 2002 Ariya Hidayat <ariyahidayat@yahoo.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __PALMDB_H
#define __PALMDB_H

#include <tqcstring.h>
#include <tqdatetime.h>
#include <tqptrlist.h>
#include <tqstring.h>

class PalmDB
{
  public:

    PalmDB();
    virtual ~PalmDB();

    virtual bool load( const char* filename );
    virtual bool save( const char* filename );

    TQString name(){ return m_name; }
    void setName( const TQString& n ){ m_name = n; }

    int attributes(){ return m_attributes; }
    void setAttributes( int a ){ m_attributes = a; }

    int version(){ return m_version; }
    void setVersion( int v ){ m_version = v; }

    TQDateTime creationDate(){ return m_creationDate; }
    void setCreationDate( TQDateTime d ){ m_creationDate = d; }

    TQDateTime modificationDate(){ return m_modificationDate; }
    void setModificationDate( TQDateTime d ){ m_modificationDate = d; }

    TQDateTime lastBackupDate(){ return m_lastBackupDate; }
    void setLastBackupDate( TQDateTime d ){ m_lastBackupDate = d; }

    TQString type(){ return m_type; }
    TQString creator(){ return m_creator; }

    void setType( const TQString& t );
    void setCreator( const TQString& c );

    int uniqueIDSeed(){ return m_uniqueIDSeed; }
    void setUniqueIDSeed( int i ){ m_uniqueIDSeed= i; }

    TQPtrList<TQByteArray> records;

  private:

    TQString m_name;
    int m_attributes, m_version;
    TQDateTime m_creationDate;
    TQDateTime m_modificationDate;
    TQDateTime m_lastBackupDate;
    TQString m_type;
    TQString m_creator;
    int m_uniqueIDSeed;
};

#endif
