/*
 *  Copyright (c) 2005 Boudewijn Rempt <boud@valdyas.org>
 *            (c) 2005 Bart Coppens <kde@bartcoppens.be>
 *
 *  Based on already much changed code by Waldo Bastian <bastian@kde.org> from KisPaletteWidget
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqdrawutil.h>
#include <tqevent.h>
#include <tqfile.h>
#include <tqimage.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqvalidator.h>
#include <tqpainter.h>
#include <tqpushbutton.h>
#include <tqspinbox.h>
#include <tqtimer.h>

#include <tdeapplication.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <tdeglobalsettings.h>
#include <kiconloader.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kseparator.h>
#include <kpalette.h>
#include <kimageeffect.h>

#include <kcolordialog.h>
#include <kcolordrag.h>
#include <config.h>
#include <kdebug.h>

#include <kis_meta_registry.h>
#include <kis_color.h>
#include <kis_factory.h>
#include <kis_colorspace_factory_registry.h>
#include "kis_palette_view.h"
#include "kis_resource.h"
#include "kis_palette.h"

KisPaletteView::KisPaletteView(TQWidget *parent, const char* name, int minWidth, int cols)
    : TQScrollView( parent, name ), mMinWidth(minWidth), mCols(cols)
{
    m_cells = 0;
    m_currentPalette = 0;

    TQSize cellSize = TQSize( mMinWidth, 50);

    setHScrollBarMode(TQScrollView::AlwaysOff);
    setVScrollBarMode(TQScrollView::AlwaysOn);

    TQSize minSize = TQSize(verticalScrollBar()->width(), 0);
    minSize += TQSize(frameWidth(), 0);
    minSize += TQSize(cellSize);

    setMinimumSize(minSize);
    setSizePolicy(TQSizePolicy(TQSizePolicy::Ignored, TQSizePolicy::Ignored));
}

KisPaletteView::~KisPaletteView()
{
}

KisPalette* KisPaletteView::palette() const
{
    return m_currentPalette;
}

void KisPaletteView::setPalette(KisPalette* palette)
{
    m_currentPalette = palette;
    delete m_cells;

    int rows = (m_currentPalette->nColors() + mCols -1 ) / mCols;

    if (rows < 1) rows = 1;

    m_cells = new KColorCells(viewport(), rows, mCols);
    TQ_CHECK_PTR(m_cells);

    m_cells->setShading(false);
    m_cells->setAcceptDrags(false);

    TQSize cellSize = TQSize( mMinWidth, mMinWidth * rows / mCols);
    m_cells->setFixedSize( cellSize );

    for( int i = 0; i < m_currentPalette->nColors(); i++)
    {
        TQColor c = m_currentPalette->getColor(i).color;
        m_cells->setColor( i, c );
    }

    connect(m_cells, TQ_SIGNAL(colorSelected(int)),
            TQ_SLOT(slotColorCellSelected(int)));

    connect(m_cells, TQ_SIGNAL(colorDoubleClicked(int)),
            TQ_SLOT(slotColorCellDoubleClicked(int)) );

    addChild( m_cells );
    m_cells->show();
    updateScrollBars();
}

void KisPaletteView::slotColorCellSelected( int col )
{
    KisColorSpace * cs = KisMetaRegistry::instance()->csRegistry()->getRGB8();
    if (!m_currentPalette || (col >= m_currentPalette->nColors()))
        return;

    m_currentEntry = m_currentPalette->getColor(col);
    emit colorSelected(KisColor(m_currentPalette->getColor(col).color, cs));
    emit colorSelected(m_currentPalette->getColor(col).color);
}

void KisPaletteView::slotColorCellDoubleClicked( int col )
{
    KisColorSpace * cs = KisMetaRegistry::instance()->csRegistry()->getRGB8();
    if (!m_currentPalette || (col >= m_currentPalette->nColors()))
        return;

    emit colorDoubleClicked(KisColor(m_currentPalette->getColor(col).color, cs),
                            m_currentPalette->getColor(col).name);
}

#include "kis_palette_view.moc"

