/*
 * This file is part of Chalk
 *
 * Copyright (c) 1999 Matthias Elter (me@kde.org)
 * Copyright (c) 2001-2002 Igor Jansen (rm@kde.org)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include <tqpushbutton.h>
#include <tqapplication.h>
#include <tqclipboard.h>
#include <tqcolor.h>
#include <tqdrawutil.h>
#include <tqhbox.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqspinbox.h>
#include <tqstyle.h>
#include <tqtooltip.h>
#include <tqwidget.h>
#include <tqframe.h>

#include <kcolordialog.h>
#include <tdelocale.h>
#include <knuminput.h>
#include <koFrameButton.h>

#include <kis_canvas_subject.h>
#include <kis_color.h>
#include <kis_color_cup.h>

KisColorPopup::KisColorPopup(TQColor c, TQWidget * parent, const char * name)
    : TQFrame(parent, name, WType_Popup | WStyle_Customize | WStyle_NoBorder)
{
    m_color = c;
    setMargin(4);
    setFocusPolicy(TQWidget::StrongFocus);
    TQHBoxLayout * l  = new TQHBoxLayout(this);
    l->add(m_khsSelector = new KHSSelector(this));
    m_khsSelector->setMinimumSize(140, 7);
    l->add(m_valueSelector = new KValueSelector(this));
    m_valueSelector->setMinimumSize(26, 70);
    m_khsSelector->show();
    m_valueSelector->show();

}

KisColorCup::KisColorCup(TQWidget * parent, const char * name)
    : TQPushButton(parent, name)
{
    m_color = TQt::black;
    m_popup = new KisColorPopup(m_color, this, "colorpopup");
    connect(this, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotClicked()));
    connect(m_popup, TQ_SIGNAL(changed( const TQColor &)), this, TQ_SLOT(setColor(const TQColor &)));
}

void KisColorCup::setColor(const TQColor & c)
{
    m_color = c;
    emit changed(c);
}

void KisColorCup::slotClicked()
{    
//    m_popup->move(this->mapToGlobal( this->rect().topRight() ) );
//    m_popup->show();
    emit changed(m_color);
}

TQSize KisColorCup::sizeHint() const
{
    return style().sizeFromContents(TQStyle::CT_PushButton, this, TQSize(24, 24)).
            expandedTo(TQApplication::globalStrut());
}

void KisColorCup::drawButtonLabel( TQPainter *painter )
{
    int x, y, w, h;
    TQRect r = style().subRect( TQStyle::SR_PushButtonContents, this );
    r.rect(&x, &y, &w, &h);

    int margin = 2; //style().pixelMetric( TQStyle::PM_ButtonMargin, this );
    x += margin;
    y += margin;
    w -= 2*margin;
    h -= 2*margin;

    if (isOn() || isDown()) {
        x += style().pixelMetric( TQStyle::PM_ButtonShiftHorizontal, this );
        y += style().pixelMetric( TQStyle::PM_ButtonShiftVertical, this );
    }

    qDrawShadePanel( painter, x, y, w, h, colorGroup(), true, 1, NULL);
    if ( m_color.isValid() )
        painter->fillRect( x+1, y+1, w-2, h-2, m_color );

    if ( hasFocus() ) {
        TQRect focusRect = style().subRect( TQStyle::SR_PushButtonFocusRect, this );
        style().drawPrimitive( TQStyle::PE_FocusRect, painter, focusRect, colorGroup() );
    }

}

#include "kis_color_cup.moc"
